/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    private static final Comparator<ScheduledFutureTask<?>> SCHEDULED_FUTURE_TASK_COMPARATOR = new Comparator<ScheduledFutureTask<?>>(){

        @Override
        public int compare(ScheduledFutureTask<?> scheduledFutureTask, ScheduledFutureTask<?> scheduledFutureTask2) {
            return scheduledFutureTask.compareTo(scheduledFutureTask2);
        }
    };
    private static final long START_TIME = System.nanoTime();
    static final Runnable WAKEUP_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue;
    long nextTaskId;

    protected AbstractScheduledEventExecutor() {
    }

    protected AbstractScheduledEventExecutor(EventExecutorGroup eventExecutorGroup) {
        super(eventExecutorGroup);
    }

    protected long getCurrentTimeNanos() {
        return AbstractScheduledEventExecutor.defaultCurrentTimeNanos();
    }

    @Deprecated
    protected static long nanoTime() {
        return AbstractScheduledEventExecutor.defaultCurrentTimeNanos();
    }

    static long defaultCurrentTimeNanos() {
        return System.nanoTime() - START_TIME;
    }

    static long deadlineNanos(long l, long l2) {
        long l3 = l + l2;
        return l3 < 0L ? Long.MAX_VALUE : l3;
    }

    protected static long deadlineToDelayNanos(long l) {
        return ScheduledFutureTask.deadlineToDelayNanos(AbstractScheduledEventExecutor.defaultCurrentTimeNanos(), l);
    }

    protected static long initialNanoTime() {
        return START_TIME;
    }

    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new DefaultPriorityQueue(SCHEDULED_FUTURE_TASK_COMPARATOR, 11);
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue) {
        return queue == null || queue.isEmpty();
    }

    protected void cancelScheduledTasks() {
        ScheduledFutureTask[] scheduledFutureTaskArray;
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(priorityQueue)) {
            return;
        }
        for (ScheduledFutureTask scheduledFutureTask : scheduledFutureTaskArray = priorityQueue.toArray(new ScheduledFutureTask[0])) {
            scheduledFutureTask.cancelWithoutRemove(false);
        }
        priorityQueue.clearIgnoringIndexes();
    }

    protected final Runnable pollScheduledTask() {
        return this.pollScheduledTask(this.getCurrentTimeNanos());
    }

    protected final Runnable pollScheduledTask(long l) {
        assert (this.inEventLoop());
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null || scheduledFutureTask.deadlineNanos() - l > 0L) {
            return null;
        }
        this.scheduledTaskQueue.remove();
        scheduledFutureTask.setConsumed();
        return scheduledFutureTask;
    }

    protected final long nextScheduledTaskNano() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        return scheduledFutureTask != null ? scheduledFutureTask.delayNanos() : -1L;
    }

    protected final long nextScheduledTaskDeadlineNanos() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        return scheduledFutureTask != null ? scheduledFutureTask.deadlineNanos() : -1L;
    }

    final ScheduledFutureTask<?> peekScheduledTask() {
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        return priorityQueue != null ? (ScheduledFutureTask)priorityQueue.peek() : null;
    }

    protected final boolean hasScheduledTasks() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        return scheduledFutureTask != null && scheduledFutureTask.deadlineNanos() <= this.getCurrentTimeNanos();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            l = 0L;
        }
        this.validateScheduled0(l, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(callable, "callable");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            l = 0L;
        }
        this.validateScheduled0(l, timeUnit);
        return this.schedule(new ScheduledFutureTask<V>(this, callable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l));
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", l2));
        }
        this.validateScheduled0(l, timeUnit);
        this.validateScheduled0(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l)), timeUnit.toNanos(l2)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l));
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", l2));
        }
        this.validateScheduled0(l, timeUnit);
        this.validateScheduled0(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l)), -timeUnit.toNanos(l2)));
    }

    private void validateScheduled0(long l, TimeUnit timeUnit) {
        this.validateScheduled(l, timeUnit);
    }

    @Deprecated
    protected void validateScheduled(long l, TimeUnit timeUnit) {
    }

    final void scheduleFromEventLoop(ScheduledFutureTask<?> scheduledFutureTask) {
        this.scheduledTaskQueue().add(scheduledFutureTask.setId(++this.nextTaskId));
    }

    private <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduleFromEventLoop(scheduledFutureTask);
        } else {
            long l = scheduledFutureTask.deadlineNanos();
            if (this.beforeScheduledTaskSubmitted(l)) {
                this.execute(scheduledFutureTask);
            } else {
                this.lazyExecute(scheduledFutureTask);
                if (this.afterScheduledTaskSubmitted(l)) {
                    this.execute(WAKEUP_TASK);
                }
            }
        }
        return scheduledFutureTask;
    }

    final void removeScheduled(ScheduledFutureTask<?> scheduledFutureTask) {
        assert (scheduledFutureTask.isCancelled());
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().removeTyped(scheduledFutureTask);
        } else {
            this.lazyExecute(scheduledFutureTask);
        }
    }

    protected boolean beforeScheduledTaskSubmitted(long l) {
        return true;
    }

    protected boolean afterScheduledTaskSubmitted(long l) {
        return true;
    }
}

