/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.IntegerHolder;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.TypeParameterMatcher;
import io.netty.util.internal.UnpaddedInternalThreadLocalMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class InternalThreadLocalMap
extends UnpaddedInternalThreadLocalMap {
    private static final ThreadLocal<InternalThreadLocalMap> slowThreadLocalMap = new ThreadLocal();
    private static final AtomicInteger nextIndex = new AtomicInteger();
    public static final int VARIABLES_TO_REMOVE_INDEX = InternalThreadLocalMap.nextVariableIndex();
    private static final int DEFAULT_ARRAY_LIST_INITIAL_CAPACITY = 8;
    private static final int ARRAY_LIST_CAPACITY_EXPAND_THRESHOLD = 0x40000000;
    private static final int ARRAY_LIST_CAPACITY_MAX_SIZE = 0x7FFFFFF7;
    private static final int HANDLER_SHARABLE_CACHE_INITIAL_CAPACITY = 4;
    private static final int INDEXED_VARIABLE_TABLE_INITIAL_SIZE = 32;
    private static final int STRING_BUILDER_INITIAL_SIZE;
    private static final int STRING_BUILDER_MAX_SIZE;
    private static final InternalLogger logger;
    public static final Object UNSET;
    private Object[] indexedVariables = InternalThreadLocalMap.newIndexedVariableTable();
    private int futureListenerStackDepth;
    private int localChannelReaderStackDepth;
    private Map<Class<?>, Boolean> handlerSharableCache;
    private IntegerHolder counterHashCode;
    private ThreadLocalRandom random;
    private Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache;
    private Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache;
    private StringBuilder stringBuilder;
    private Map<Charset, CharsetEncoder> charsetEncoderCache;
    private Map<Charset, CharsetDecoder> charsetDecoderCache;
    private ArrayList<Object> arrayList;
    private BitSet cleanerFlags;
    public long rp1;
    public long rp2;
    public long rp3;
    public long rp4;
    public long rp5;
    public long rp6;
    public long rp7;
    public long rp8;

    public static InternalThreadLocalMap getIfSet() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)thread).threadLocalMap();
        }
        return slowThreadLocalMap.get();
    }

    public static InternalThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return InternalThreadLocalMap.fastGet((FastThreadLocalThread)thread);
        }
        return InternalThreadLocalMap.slowGet();
    }

    private static InternalThreadLocalMap fastGet(FastThreadLocalThread fastThreadLocalThread) {
        InternalThreadLocalMap internalThreadLocalMap = fastThreadLocalThread.threadLocalMap();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            fastThreadLocalThread.setThreadLocalMap(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    private static InternalThreadLocalMap slowGet() {
        InternalThreadLocalMap internalThreadLocalMap = slowThreadLocalMap.get();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            slowThreadLocalMap.set(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    public static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            ((FastThreadLocalThread)thread).setThreadLocalMap(null);
        } else {
            slowThreadLocalMap.remove();
        }
    }

    public static void destroy() {
        slowThreadLocalMap.remove();
    }

    public static int nextVariableIndex() {
        int n = nextIndex.getAndIncrement();
        if (n >= 0x7FFFFFF7 || n < 0) {
            nextIndex.set(0x7FFFFFF7);
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return n;
    }

    public static int lastVariableIndex() {
        return nextIndex.get() - 1;
    }

    private InternalThreadLocalMap() {
    }

    private static Object[] newIndexedVariableTable() {
        Object[] objectArray = new Object[32];
        Arrays.fill(objectArray, UNSET);
        return objectArray;
    }

    public int size() {
        Object object;
        int n = 0;
        if (this.futureListenerStackDepth != 0) {
            ++n;
        }
        if (this.localChannelReaderStackDepth != 0) {
            ++n;
        }
        if (this.handlerSharableCache != null) {
            ++n;
        }
        if (this.counterHashCode != null) {
            ++n;
        }
        if (this.random != null) {
            ++n;
        }
        if (this.typeParameterMatcherGetCache != null) {
            ++n;
        }
        if (this.typeParameterMatcherFindCache != null) {
            ++n;
        }
        if (this.stringBuilder != null) {
            ++n;
        }
        if (this.charsetEncoderCache != null) {
            ++n;
        }
        if (this.charsetDecoderCache != null) {
            ++n;
        }
        if (this.arrayList != null) {
            ++n;
        }
        if ((object = this.indexedVariable(VARIABLES_TO_REMOVE_INDEX)) != null && object != UNSET) {
            Set set = (Set)object;
            n += set.size();
        }
        return n;
    }

    public StringBuilder stringBuilder() {
        StringBuilder stringBuilder = this.stringBuilder;
        if (stringBuilder == null) {
            this.stringBuilder = new StringBuilder(STRING_BUILDER_INITIAL_SIZE);
            return this.stringBuilder;
        }
        if (stringBuilder.capacity() > STRING_BUILDER_MAX_SIZE) {
            stringBuilder.setLength(STRING_BUILDER_INITIAL_SIZE);
            stringBuilder.trimToSize();
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    public Map<Charset, CharsetEncoder> charsetEncoderCache() {
        Map<Charset, CharsetEncoder> map = this.charsetEncoderCache;
        if (map == null) {
            this.charsetEncoderCache = map = new IdentityHashMap<Charset, CharsetEncoder>();
        }
        return map;
    }

    public Map<Charset, CharsetDecoder> charsetDecoderCache() {
        Map<Charset, CharsetDecoder> map = this.charsetDecoderCache;
        if (map == null) {
            this.charsetDecoderCache = map = new IdentityHashMap<Charset, CharsetDecoder>();
        }
        return map;
    }

    public <E> ArrayList<E> arrayList() {
        return this.arrayList(8);
    }

    public <E> ArrayList<E> arrayList(int n) {
        ArrayList<Object> arrayList = this.arrayList;
        if (arrayList == null) {
            this.arrayList = new ArrayList(n);
            return this.arrayList;
        }
        arrayList.clear();
        arrayList.ensureCapacity(n);
        return arrayList;
    }

    public int futureListenerStackDepth() {
        return this.futureListenerStackDepth;
    }

    public void setFutureListenerStackDepth(int n) {
        this.futureListenerStackDepth = n;
    }

    public ThreadLocalRandom random() {
        ThreadLocalRandom threadLocalRandom = this.random;
        if (threadLocalRandom == null) {
            this.random = threadLocalRandom = new ThreadLocalRandom();
        }
        return threadLocalRandom;
    }

    public Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache() {
        Map<Class<?>, TypeParameterMatcher> map = this.typeParameterMatcherGetCache;
        if (map == null) {
            this.typeParameterMatcherGetCache = map = new IdentityHashMap();
        }
        return map;
    }

    public Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache() {
        Map<Class<?>, Map<String, TypeParameterMatcher>> map = this.typeParameterMatcherFindCache;
        if (map == null) {
            this.typeParameterMatcherFindCache = map = new IdentityHashMap();
        }
        return map;
    }

    @Deprecated
    public IntegerHolder counterHashCode() {
        return this.counterHashCode;
    }

    @Deprecated
    public void setCounterHashCode(IntegerHolder integerHolder) {
        this.counterHashCode = integerHolder;
    }

    public Map<Class<?>, Boolean> handlerSharableCache() {
        Map<Class<?>, Boolean> map = this.handlerSharableCache;
        if (map == null) {
            this.handlerSharableCache = map = new WeakHashMap(4);
        }
        return map;
    }

    public int localChannelReaderStackDepth() {
        return this.localChannelReaderStackDepth;
    }

    public void setLocalChannelReaderStackDepth(int n) {
        this.localChannelReaderStackDepth = n;
    }

    public Object indexedVariable(int n) {
        Object[] objectArray = this.indexedVariables;
        return n < objectArray.length ? objectArray[n] : UNSET;
    }

    public boolean setIndexedVariable(int n, Object object) {
        Object[] objectArray = this.indexedVariables;
        if (n < objectArray.length) {
            Object object2 = objectArray[n];
            objectArray[n] = object;
            return object2 == UNSET;
        }
        this.expandIndexedVariableTableAndSet(n, object);
        return true;
    }

    private void expandIndexedVariableTableAndSet(int n, Object object) {
        int n2;
        Object[] objectArray = this.indexedVariables;
        int n3 = objectArray.length;
        if (n < 0x40000000) {
            n2 = n;
            n2 |= n2 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
            n2 |= n2 >>> 16;
            ++n2;
        } else {
            n2 = 0x7FFFFFF7;
        }
        Object[] objectArray2 = Arrays.copyOf(objectArray, n2);
        Arrays.fill(objectArray2, n3, objectArray2.length, UNSET);
        objectArray2[n] = object;
        this.indexedVariables = objectArray2;
    }

    public Object removeIndexedVariable(int n) {
        Object[] objectArray = this.indexedVariables;
        if (n < objectArray.length) {
            Object object = objectArray[n];
            objectArray[n] = UNSET;
            return object;
        }
        return UNSET;
    }

    public boolean isIndexedVariableSet(int n) {
        Object[] objectArray = this.indexedVariables;
        return n < objectArray.length && objectArray[n] != UNSET;
    }

    public boolean isCleanerFlagSet(int n) {
        return this.cleanerFlags != null && this.cleanerFlags.get(n);
    }

    public void setCleanerFlag(int n) {
        if (this.cleanerFlags == null) {
            this.cleanerFlags = new BitSet();
        }
        this.cleanerFlags.set(n);
    }

    static {
        UNSET = new Object();
        STRING_BUILDER_INITIAL_SIZE = SystemPropertyUtil.getInt("io.netty.threadLocalMap.stringBuilder.initialSize", 1024);
        STRING_BUILDER_MAX_SIZE = SystemPropertyUtil.getInt("io.netty.threadLocalMap.stringBuilder.maxSize", 4096);
        logger = InternalLoggerFactory.getInstance(InternalThreadLocalMap.class);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.initialSize: {}", (Object)STRING_BUILDER_INITIAL_SIZE);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.maxSize: {}", (Object)STRING_BUILDER_MAX_SIZE);
    }
}

