/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final ObjectPool<RecyclableArrayList> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<RecyclableArrayList>(){

        @Override
        public RecyclableArrayList newObject(ObjectPool.Handle<RecyclableArrayList> handle) {
            return new RecyclableArrayList(handle);
        }
    });
    private boolean insertSinceRecycled;
    private final ObjectPool.Handle<RecyclableArrayList> handle;

    public static RecyclableArrayList newInstance() {
        return RecyclableArrayList.newInstance(8);
    }

    public static RecyclableArrayList newInstance(int n) {
        RecyclableArrayList recyclableArrayList = RECYCLER.get();
        recyclableArrayList.ensureCapacity(n);
        return recyclableArrayList;
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle) {
        this(handle, 8);
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle, int n) {
        super(n);
        this.handle = handle;
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(n, collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> collection) {
        if (collection instanceof RandomAccess && collection instanceof List) {
            List list = (List)collection;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (list.get(i) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        } else {
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        }
    }

    @Override
    public boolean add(Object object) {
        if (super.add(ObjectUtil.checkNotNull(object, "element"))) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public void add(int n, Object object) {
        super.add(n, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
    }

    @Override
    public Object set(int n, Object object) {
        Object object2 = super.set(n, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
        return object2;
    }

    public boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    public boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
        return true;
    }
}

