/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeLongArrayAccess;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpmcArrayQueue<E>
extends MpmcArrayQueueL3Pad<E> {
    public static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.mpmc.max.lookahead.step", 4096);
    private final int lookAheadStep = Math.max(2, Math.min(this.capacity() / 4, MAX_LOOK_AHEAD_STEP));

    public MpmcArrayQueue(int n) {
        super(RangeUtil.checkGreaterThanOrEqual(n, 2, "capacity"));
    }

    @Override
    public boolean offer(E e) {
        long l;
        long l2;
        long l3;
        if (null == e) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long[] lArray = this.sequenceBuffer;
        long l6 = Long.MIN_VALUE;
        do {
            if ((l3 = UnsafeLongArrayAccess.lvLongElement(lArray, l = UnsafeLongArrayAccess.calcCircularLongElementOffset(l2 = this.lvProducerIndex(), l4))) >= l2) continue;
            if (l2 - l5 >= l6 && l2 - l5 >= (l6 = this.lvConsumerIndex())) {
                return false;
            }
            l3 = l2 + 1L;
        } while (l3 > l2 || !this.casProducerIndex(l2, l2 + 1L));
        UnsafeRefArrayAccess.spRefElement(this.buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l4), e);
        UnsafeLongArrayAccess.soLongElement(lArray, l, l2 + 1L);
        return true;
    }

    @Override
    public E poll() {
        long l;
        long l2;
        long l3;
        long l4;
        long[] lArray = this.sequenceBuffer;
        long l5 = this.mask;
        long l6 = -1L;
        do {
            if ((l4 = UnsafeLongArrayAccess.lvLongElement(lArray, l = UnsafeLongArrayAccess.calcCircularLongElementOffset(l2 = this.lvConsumerIndex(), l5))) >= (l3 = l2 + 1L)) continue;
            if (l2 >= l6 && l2 == (l6 = this.lvProducerIndex())) {
                return null;
            }
            l4 = l3 + 1L;
        } while (l4 > l3 || !this.casConsumerIndex(l2, l2 + 1L));
        long l7 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l5);
        Object object = UnsafeRefArrayAccess.lpRefElement(this.buffer, l7);
        UnsafeRefArrayAccess.spRefElement(this.buffer, l7, null);
        UnsafeLongArrayAccess.soLongElement(lArray, l, l2 + l5 + 1L);
        return (E)object;
    }

    @Override
    public E peek() {
        Object object;
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        long l2 = -1L;
        while (true) {
            long l3;
            long l4;
            long l5;
            long l6;
            if ((l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l5 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l4 = this.lvConsumerIndex(), l))) < (l3 = l4 + 1L)) {
                if (l4 < l2 || l4 != (l2 = this.lvProducerIndex())) continue;
                return null;
            }
            if (l6 != l3) continue;
            long l7 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l4, l);
            object = UnsafeRefArrayAccess.lvRefElement(this.buffer, l7);
            if (this.lvConsumerIndex() == l4) break;
        }
        return (E)object;
    }

    @Override
    public boolean relaxedOffer(E e) {
        long l;
        long l2;
        long l3;
        if (null == e) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long[] lArray = this.sequenceBuffer;
        do {
            if ((l3 = UnsafeLongArrayAccess.lvLongElement(lArray, l = UnsafeLongArrayAccess.calcCircularLongElementOffset(l2 = this.lvProducerIndex(), l4))) >= l2) continue;
            return false;
        } while (l3 > l2 || !this.casProducerIndex(l2, l2 + 1L));
        UnsafeRefArrayAccess.spRefElement(this.buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l4), e);
        UnsafeLongArrayAccess.soLongElement(lArray, l, l2 + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        long l;
        long l2;
        long l3;
        long l4;
        long[] lArray = this.sequenceBuffer;
        long l5 = this.mask;
        do {
            if ((l4 = UnsafeLongArrayAccess.lvLongElement(lArray, l = UnsafeLongArrayAccess.calcCircularLongElementOffset(l2 = this.lvConsumerIndex(), l5))) >= (l3 = l2 + 1L)) continue;
            return null;
        } while (l4 > l3 || !this.casConsumerIndex(l2, l2 + 1L));
        long l6 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l5);
        Object object = UnsafeRefArrayAccess.lpRefElement(this.buffer, l6);
        UnsafeRefArrayAccess.spRefElement(this.buffer, l6, null);
        UnsafeLongArrayAccess.soLongElement(lArray, l, l2 + l5 + 1L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        Object object;
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        while (true) {
            long l2;
            long l3;
            long l4;
            long l5;
            if ((l5 = UnsafeLongArrayAccess.lvLongElement(lArray, l4 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l3 = this.lvConsumerIndex(), l))) < (l2 = l3 + 1L)) {
                return null;
            }
            if (l5 != l2) continue;
            long l6 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l);
            object = UnsafeRefArrayAccess.lvRefElement(this.buffer, l6);
            if (this.lvConsumerIndex() == l3) break;
        }
        return (E)object;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        int n2;
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        Object[] objectArray = this.buffer;
        int n3 = Math.min(this.lookAheadStep, n);
        for (int i = 0; i < n; i += n2) {
            long l2;
            int n4 = n - i;
            n2 = Math.min(n4, n3);
            long l3 = this.lvConsumerIndex();
            long l4 = l3 + (long)n2 - 1L;
            long l5 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l4, l);
            long l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l5);
            if (l6 == (l2 = l4 + 1L) && this.casConsumerIndex(l3, l2)) {
                for (int j = 0; j < n2; ++j) {
                    long l7 = l3 + (long)j;
                    long l8 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l7, l);
                    long l9 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l7, l);
                    long l10 = l7 + 1L;
                    while (UnsafeLongArrayAccess.lvLongElement(lArray, l8) != l10) {
                    }
                    Object object = UnsafeRefArrayAccess.lpRefElement(objectArray, l9);
                    UnsafeRefArrayAccess.spRefElement(objectArray, l9, null);
                    UnsafeLongArrayAccess.soLongElement(lArray, l8, l7 + l + 1L);
                    consumer.accept(object);
                }
                continue;
            }
            if (l6 < l2 && this.notAvailable(l3, l, lArray, l3 + 1L)) {
                return i;
            }
            return i + this.drainOneByOne(consumer, n4);
        }
        return n;
    }

    private int drainOneByOne(MessagePassingQueue.Consumer<E> consumer, int n) {
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        Object[] objectArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3;
            long l4;
            long l5;
            do {
                if ((l5 = UnsafeLongArrayAccess.lvLongElement(lArray, l2 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l3 = this.lvConsumerIndex(), l))) >= (l4 = l3 + 1L)) continue;
                return i;
            } while (l5 > l4 || !this.casConsumerIndex(l3, l3 + 1L));
            long l6 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l);
            Object object = UnsafeRefArrayAccess.lpRefElement(objectArray, l6);
            UnsafeRefArrayAccess.spRefElement(objectArray, l6, null);
            UnsafeLongArrayAccess.soLongElement(lArray, l2, l3 + l + 1L);
            consumer.accept(object);
        }
        return n;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        int n2;
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        Object[] objectArray = this.buffer;
        int n3 = Math.min(this.lookAheadStep, n);
        for (int i = 0; i < n; i += n2) {
            long l2;
            int n4 = n - i;
            n2 = Math.min(n4, n3);
            long l3 = this.lvProducerIndex();
            long l4 = l3 + (long)n2 - 1L;
            long l5 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l4, l);
            long l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l5);
            if (l6 == (l2 = l4) && this.casProducerIndex(l3, l2 + 1L)) {
                for (int j = 0; j < n2; ++j) {
                    long l7 = l3 + (long)j;
                    long l8 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l7, l);
                    long l9 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l7, l);
                    while (UnsafeLongArrayAccess.lvLongElement(lArray, l8) != l7) {
                    }
                    UnsafeRefArrayAccess.soRefElement(objectArray, l9, supplier.get());
                    UnsafeLongArrayAccess.soLongElement(lArray, l8, l7 + 1L);
                }
                continue;
            }
            if (l6 < l2 && this.notAvailable(l3, l, lArray, l3)) {
                return i;
            }
            return i + this.fillOneByOne(supplier, n4);
        }
        return n;
    }

    private boolean notAvailable(long l, long l2, long[] lArray, long l3) {
        long l4 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l, l2);
        long l5 = UnsafeLongArrayAccess.lvLongElement(lArray, l4);
        return l5 < l3;
    }

    private int fillOneByOne(MessagePassingQueue.Supplier<E> supplier, int n) {
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        Object[] objectArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3;
            long l4;
            do {
                if ((l4 = UnsafeLongArrayAccess.lvLongElement(lArray, l2 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l3 = this.lvProducerIndex(), l))) >= l3) continue;
                return i;
            } while (l4 > l3 || !this.casProducerIndex(l3, l3 + 1L));
            UnsafeRefArrayAccess.soRefElement(objectArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l), supplier.get());
            UnsafeLongArrayAccess.soLongElement(lArray, l2, l3 + 1L);
        }
        return n;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return MessagePassingQueueUtil.drain(this, consumer);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillBounded(this, supplier);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }
}

