/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueueL3Pad;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscAtomicArrayQueue<E>
extends MpscAtomicArrayQueueL3Pad<E> {
    public MpscAtomicArrayQueue(int n) {
        super(n);
    }

    public boolean offerIfBelowThreshold(E e, int n) {
        long l;
        if (null == e) {
            throw new NullPointerException();
        }
        int n2 = this.mask;
        long l2 = n2 + 1;
        long l3 = this.lvProducerLimit();
        do {
            long l4;
            long l5;
            if ((l5 = l2 - (l4 = l3 - (l = this.lvProducerIndex()))) < (long)n) continue;
            long l6 = this.lvConsumerIndex();
            l5 = l - l6;
            if (l5 >= (long)n) {
                return false;
            }
            l3 = l6 + l2;
            this.soProducerLimit(l3);
        } while (!this.casProducerIndex(l, l + 1L));
        int n3 = AtomicQueueUtil.calcCircularRefElementOffset(l, n2);
        AtomicQueueUtil.soRefElement(this.buffer, n3, e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        long l;
        if (null == e) {
            throw new NullPointerException();
        }
        int n = this.mask;
        long l2 = this.lvProducerLimit();
        do {
            if ((l = this.lvProducerIndex()) < l2) continue;
            long l3 = this.lvConsumerIndex();
            l2 = l3 + (long)n + 1L;
            if (l >= l2) {
                return false;
            }
            this.soProducerLimit(l2);
        } while (!this.casProducerIndex(l, l + 1L));
        int n2 = AtomicQueueUtil.calcCircularRefElementOffset(l, n);
        AtomicQueueUtil.soRefElement(this.buffer, n2, e);
        return true;
    }

    public final int failFastOffer(E e) {
        long l;
        if (null == e) {
            throw new NullPointerException();
        }
        int n = this.mask;
        long l2 = n + 1;
        long l3 = this.lvProducerIndex();
        if (l3 >= (l = this.lvProducerLimit())) {
            long l4 = this.lvConsumerIndex();
            l = l4 + l2;
            if (l3 >= l) {
                return 1;
            }
            this.soProducerLimit(l);
        }
        if (!this.casProducerIndex(l3, l3 + 1L)) {
            return -1;
        }
        int n2 = AtomicQueueUtil.calcCircularRefElementOffset(l3, n);
        AtomicQueueUtil.soRefElement(this.buffer, n2, e);
        return 0;
    }

    @Override
    public E poll() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        long l = this.lpConsumerIndex();
        int n = AtomicQueueUtil.calcCircularRefElementOffset(l, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (null == e) {
            if (l != this.lvProducerIndex()) {
                while ((e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n)) == null) {
                }
            } else {
                return null;
            }
        }
        AtomicQueueUtil.spRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l + 1L);
        return e;
    }

    @Override
    public E peek() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        long l = this.lpConsumerIndex();
        int n = AtomicQueueUtil.calcCircularRefElementOffset(l, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (null == e) {
            if (l != this.lvProducerIndex()) {
                while ((e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n)) == null) {
                }
            } else {
                return null;
            }
        }
        return e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        long l = this.lpConsumerIndex();
        int n = AtomicQueueUtil.calcCircularRefElementOffset(l, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (null == e) {
            return null;
        }
        AtomicQueueUtil.spRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l + 1L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n = this.mask;
        long l = this.lpConsumerIndex();
        return AtomicQueueUtil.lvRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l, n));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n2 = this.mask;
        long l = this.lpConsumerIndex();
        for (int i = 0; i < n; ++i) {
            long l2 = l + (long)i;
            int n3 = AtomicQueueUtil.calcCircularRefElementOffset(l2, n2);
            Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n3);
            if (null == e) {
                return i;
            }
            AtomicQueueUtil.spRefElement(atomicReferenceArray, n3, null);
            this.soConsumerIndex(l2 + 1L);
            consumer.accept(e);
        }
        return n;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        long l;
        int n2;
        long l2;
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        int n3 = this.mask;
        long l3 = n3 + 1;
        long l4 = this.lvProducerLimit();
        do {
            if ((l = l4 - (l2 = this.lvProducerIndex())) > 0L) continue;
            long l5 = this.lvConsumerIndex();
            l4 = l5 + l3;
            l = l4 - l2;
            if (l <= 0L) {
                return 0;
            }
            this.soProducerLimit(l4);
        } while (!this.casProducerIndex(l2, l2 + (long)(n2 = Math.min((int)l, n))));
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        for (int i = 0; i < n2; ++i) {
            int n4 = AtomicQueueUtil.calcCircularRefElementOffset(l2 + (long)i, n3);
            AtomicQueueUtil.soRefElement(atomicReferenceArray, n4, supplier.get());
        }
        return n2;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillBounded(this, supplier);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }

    @Deprecated
    public int weakOffer(E e) {
        return this.failFastOffer(e);
    }
}

