/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangeUnits;
import io.ktor.http.RangesKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\nJ#\u0010\u000e\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\"\u0004\b\u0000\u0010\u001c*\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010\u001bJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003\u00a2\u0006\u0004\b \u0010!J*\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\"\u0010#J\u001a\u0010%\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010\u001bR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010+\u001a\u0004\b,\u0010!\u00a8\u0006-"}, d2={"Lio/ktor/http/RangesSpecifier;", "", "", "unit", "", "Lio/ktor/http/ContentRange;", "ranges", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "Lio/ktor/http/RangeUnits;", "(Lio/ktor/http/RangeUnits;Ljava/util/List;)V", "Lkotlin/Function1;", "", "rangeUnitPredicate", "isValid", "(Lkotlin/jvm/functions/Function1;)Z", "", "length", "", "maxRangeCount", "Lkotlin/ranges/LongRange;", "merge", "(JI)Ljava/util/List;", "(J)Ljava/util/List;", "mergeToSingle", "(J)Lkotlin/ranges/LongRange;", "toString", "()Ljava/lang/String;", "T", "toList", "(Ljava/lang/Object;)Ljava/util/List;", "component1", "component2", "()Ljava/util/List;", "copy", "(Ljava/lang/String;Ljava/util/List;)Lio/ktor/http/RangesSpecifier;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "getUnit", "Ljava/util/List;", "getRanges", "ktor-http"})
public final class RangesSpecifier {
    private final String unit;
    private final List<ContentRange> ranges;

    public RangesSpecifier(String string, List<? extends ContentRange> list) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.unit = string;
        this.ranges = list;
        if (!(!((Collection)this.ranges).isEmpty())) {
            boolean bl = false;
            String string2 = "It should be at least one range";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ RangesSpecifier(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = RangeUnits.Bytes.getUnitToken();
        }
        this(string, (List<? extends ContentRange>)list);
    }

    public final String getUnit() {
        return this.unit;
    }

    public final List<ContentRange> getRanges() {
        return this.ranges;
    }

    public RangesSpecifier(RangeUnits rangeUnits, List<? extends ContentRange> list) {
        Intrinsics.checkNotNullParameter((Object)((Object)rangeUnits), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this(rangeUnits.getUnitToken(), list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid(Function1<? super String, Boolean> function1) {
        boolean bl;
        Intrinsics.checkNotNullParameter(function1, (String)"");
        if ((Boolean)function1.invoke((Object)this.unit) == false) return false;
        Iterable iterable = this.ranges;
        boolean bl2 = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object t = iterator.next();
            ContentRange contentRange = (ContentRange)t;
            boolean bl3 = false;
            ContentRange contentRange2 = contentRange;
            if (contentRange2 instanceof ContentRange.Bounded) {
                if (((ContentRange.Bounded)contentRange).getFrom() < 0L) return false;
                if (((ContentRange.Bounded)contentRange).getTo() < ((ContentRange.Bounded)contentRange).getFrom()) {
                    return false;
                }
                bl = false;
                continue;
            }
            if (contentRange2 instanceof ContentRange.TailFrom) {
                if (((ContentRange.TailFrom)contentRange).getFrom() < 0L) {
                    return false;
                }
                bl = false;
                continue;
            }
            if (!(contentRange2 instanceof ContentRange.Suffix)) throw new NoWhenBranchMatchedException();
            if (((ContentRange.Suffix)contentRange).getLastCount() < 0L) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public static /* synthetic */ boolean isValid$default(RangesSpecifier rangesSpecifier, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = RangesSpecifier::isValid$lambda$1;
        }
        return rangesSpecifier.isValid((Function1<? super String, Boolean>)function1);
    }

    public final List<LongRange> merge(long l, int n) {
        if (this.ranges.size() > n) {
            return this.toList(this.mergeToSingle(l));
        }
        return this.merge(l);
    }

    public static /* synthetic */ List merge$default(RangesSpecifier rangesSpecifier, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        return rangesSpecifier.merge(l, n);
    }

    public final List<LongRange> merge(long l) {
        return RangesKt.mergeRangesKeepOrder(RangesKt.toLongRanges(this.ranges, l));
    }

    public final LongRange mergeToSingle(long l) {
        Object v1;
        boolean bl;
        Object object;
        Object v0;
        List<LongRange> list = RangesKt.toLongRanges(this.ranges, l);
        if (list.isEmpty()) {
            return null;
        }
        Iterable iterable = list;
        boolean bl2 = false;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object object2 = iterator.next();
            if (!iterator.hasNext()) {
                v0 = object2;
            } else {
                LongRange longRange = (LongRange)object2;
                boolean bl3 = false;
                long l2 = longRange.getFirst();
                do {
                    object = iterator.next();
                    LongRange longRange2 = (LongRange)object;
                    bl = false;
                    long l3 = longRange2.getFirst();
                    if (l2 <= l3) continue;
                    object2 = object;
                    l2 = l3;
                } while (iterator.hasNext());
                v0 = object2;
            }
        }
        Intrinsics.checkNotNull(v0);
        long l4 = ((LongRange)v0).getFirst();
        iterator = list;
        boolean bl4 = false;
        Iterator iterator2 = iterator.iterator();
        if (!iterator2.hasNext()) {
            v1 = null;
        } else {
            object = iterator2.next();
            if (!iterator2.hasNext()) {
                v1 = object;
            } else {
                LongRange longRange = (LongRange)object;
                bl = false;
                long l5 = longRange.getLast();
                do {
                    Object t = iterator2.next();
                    LongRange longRange3 = (LongRange)t;
                    boolean bl5 = false;
                    long l6 = longRange3.getLast();
                    if (l5 >= l6) continue;
                    object = t;
                    l5 = l6;
                } while (iterator2.hasNext());
                v1 = object;
            }
        }
        Intrinsics.checkNotNull(v1);
        long l7 = kotlin.ranges.RangesKt.coerceAtMost((long)((LongRange)v1).getLast(), (long)(l - 1L));
        return new LongRange(l4, l7);
    }

    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.ranges, (CharSequence)",", (CharSequence)(this.unit + '='), null, (int)0, null, null, (int)60, null);
    }

    private final <T> List<T> toList(T t) {
        T t2 = t;
        return t2 == null ? CollectionsKt.emptyList() : CollectionsKt.listOf(t2);
    }

    public final String component1() {
        return this.unit;
    }

    public final List<ContentRange> component2() {
        return this.ranges;
    }

    public final RangesSpecifier copy(String string, List<? extends ContentRange> list) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        return new RangesSpecifier(string, list);
    }

    public static /* synthetic */ RangesSpecifier copy$default(RangesSpecifier rangesSpecifier, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = rangesSpecifier.unit;
        }
        if ((n & 2) != 0) {
            list = rangesSpecifier.ranges;
        }
        return rangesSpecifier.copy(string, list);
    }

    public int hashCode() {
        int n = this.unit.hashCode();
        n = n * 31 + ((Object)this.ranges).hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RangesSpecifier)) {
            return false;
        }
        RangesSpecifier rangesSpecifier = (RangesSpecifier)object;
        if (!Intrinsics.areEqual((Object)this.unit, (Object)rangesSpecifier.unit)) {
            return false;
        }
        return Intrinsics.areEqual(this.ranges, rangesSpecifier.ranges);
    }

    private static final boolean isValid$lambda$1(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return Intrinsics.areEqual((Object)string, (Object)RangeUnits.Bytes.getUnitToken());
    }
}

