/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.util.CharsetKt;
import io.ktor.util.TextKt;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 \u001a2\u00060\u0001j\u0002`\u0002:\u0001\u001aB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ$\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001b"}, d2={"Lio/ktor/http/URLProtocol;", "Ljava/io/Serializable;", "Lio/ktor/utils/io/JvmSerializable;", "", "name", "", "defaultPort", "<init>", "(Ljava/lang/String;I)V", "component1", "()Ljava/lang/String;", "component2", "()I", "copy", "(Ljava/lang/String;I)Lio/ktor/http/URLProtocol;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "I", "getDefaultPort", "Companion", "ktor-http"})
public final class URLProtocol
implements Serializable {
    public static final Companion Companion = new Companion(null);
    private final String name;
    private final int defaultPort;
    private static final URLProtocol HTTP = new URLProtocol("http", 80);
    private static final URLProtocol HTTPS = new URLProtocol("https", 443);
    private static final URLProtocol WS = new URLProtocol("ws", 80);
    private static final URLProtocol WSS = new URLProtocol("wss", 443);
    private static final URLProtocol SOCKS = new URLProtocol("socks", 1080);
    private static final Map<String, URLProtocol> byName;

    public URLProtocol(String string, int n) {
        boolean bl;
        boolean bl2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            this.name = string;
            this.defaultPort = n;
            CharSequence charSequence = this.name;
            bl2 = false;
            for (int i = 0; i < charSequence.length(); ++i) {
                char c;
                char c2 = c = charSequence.charAt(i);
                boolean bl3 = false;
                if (CharsetKt.isLowerCase((char)c2)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            bl2 = false;
            String string2 = "All characters should be lower case";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final String getName() {
        return this.name;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.defaultPort;
    }

    public final URLProtocol copy(String string, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return new URLProtocol(string, n);
    }

    public static /* synthetic */ URLProtocol copy$default(URLProtocol uRLProtocol, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = uRLProtocol.name;
        }
        if ((n2 & 2) != 0) {
            n = uRLProtocol.defaultPort;
        }
        return uRLProtocol.copy(string, n);
    }

    public String toString() {
        return "URLProtocol(name=" + this.name + ", defaultPort=" + this.defaultPort + ')';
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = n * 31 + Integer.hashCode(this.defaultPort);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URLProtocol)) {
            return false;
        }
        URLProtocol uRLProtocol = (URLProtocol)object;
        if (!Intrinsics.areEqual((Object)this.name, (Object)uRLProtocol.name)) {
            return false;
        }
        return this.defaultPort == uRLProtocol.defaultPort;
    }

    static {
        Object object = new URLProtocol[]{HTTP, HTTPS, WS, WSS, SOCKS};
        object = CollectionsKt.listOf((Object[])object);
        boolean bl = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10)), (int)16);
        Object object2 = object;
        Map map = new LinkedHashMap(n);
        boolean bl2 = false;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            URLProtocol uRLProtocol = (URLProtocol)t;
            Map map2 = map;
            boolean bl3 = false;
            map2.put(uRLProtocol.name, t);
        }
        byName = map;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\fR#\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lio/ktor/http/URLProtocol$Companion;", "", "<init>", "()V", "", "name", "Lio/ktor/http/URLProtocol;", "createOrDefault", "(Ljava/lang/String;)Lio/ktor/http/URLProtocol;", "HTTP", "Lio/ktor/http/URLProtocol;", "getHTTP", "()Lio/ktor/http/URLProtocol;", "HTTPS", "getHTTPS", "WS", "getWS", "WSS", "getWSS", "SOCKS", "getSOCKS", "", "byName", "Ljava/util/Map;", "getByName", "()Ljava/util/Map;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public final URLProtocol getHTTP() {
            return HTTP;
        }

        public final URLProtocol getHTTPS() {
            return HTTPS;
        }

        public final URLProtocol getWS() {
            return WS;
        }

        public final URLProtocol getWSS() {
            return WSS;
        }

        public final URLProtocol getSOCKS() {
            return SOCKS;
        }

        public final Map<String, URLProtocol> getByName() {
            return byName;
        }

        public final URLProtocol createOrDefault(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            String string2 = TextKt.toLowerCasePreservingASCIIRules((String)string);
            boolean bl = false;
            URLProtocol uRLProtocol = Companion.getByName().get(string2);
            if (uRLProtocol == null) {
                uRLProtocol = new URLProtocol(string2, 0);
            }
            return uRLProtocol;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

