/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.Url;
import java.net.URI;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007\u001a\u0011\u0010\t\u001a\u00020\u0001*\u00020\b\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/ktor/http/URLBuilder;", "Ljava/net/URI;", "uri", "takeFrom", "(Lio/ktor/http/URLBuilder;Ljava/net/URI;)Lio/ktor/http/URLBuilder;", "Ljava/net/URL;", "url", "(Lio/ktor/http/URLBuilder;Ljava/net/URL;)Lio/ktor/http/URLBuilder;", "Lio/ktor/http/Url;", "toURI", "(Lio/ktor/http/Url;)Ljava/net/URI;", "Url", "(Ljava/net/URI;)Lio/ktor/http/Url;", "ktor-http"})
public final class URLUtilsJvmKt {
    public static final URLBuilder takeFrom(URLBuilder uRLBuilder, URI uRI) {
        block11: {
            Object object;
            boolean bl;
            String string;
            Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
            Intrinsics.checkNotNullParameter((Object)uRI, (String)"");
            String string2 = uRI.getScheme();
            if (string2 != null) {
                string = string2;
                bl = false;
                uRLBuilder.setProtocol(URLProtocol.Companion.createOrDefault(string));
                uRLBuilder.setPort(uRLBuilder.getProtocol().getDefaultPort());
            }
            if (uRI.getPort() > 0) {
                uRLBuilder.setPort(uRI.getPort());
            } else {
                object = uRI.getScheme();
                if (Intrinsics.areEqual((Object)object, (Object)"http")) {
                    uRLBuilder.setPort(80);
                } else if (Intrinsics.areEqual((Object)object, (Object)"https")) {
                    uRLBuilder.setPort(443);
                }
            }
            if (uRI.getRawUserInfo() != null) {
                String string3 = uRI.getRawUserInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                if (((CharSequence)string3).length() > 0) {
                    String string4 = uRI.getRawUserInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                    String[] stringArray = new String[]{":"};
                    object = StringsKt.split$default((CharSequence)string4, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    uRLBuilder.setEncodedUser((String)CollectionsKt.first((List)object));
                    uRLBuilder.setEncodedPassword((String)CollectionsKt.getOrNull((List)object, (int)1));
                }
            }
            String string5 = uRI.getHost();
            if (string5 != null) {
                string = string5;
                bl = false;
                uRLBuilder.setHost(string);
            }
            URLBuilderKt.setEncodedPath(uRLBuilder, uRI.getRawPath());
            String string6 = uRI.getRawQuery();
            if (string6 != null) {
                ParametersBuilder parametersBuilder;
                string = string6;
                bl = false;
                ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
                URLBuilder uRLBuilder2 = uRLBuilder;
                boolean bl2 = false;
                parametersBuilder2.appendAll(QueryKt.parseQueryString$default(string, 0, 0, false, 6, null));
                uRLBuilder2.setEncodedParameters(parametersBuilder);
            }
            String string7 = uRI.getQuery();
            boolean bl3 = string7 != null ? ((CharSequence)string7).length() == 0 : false;
            if (bl3) {
                uRLBuilder.setTrailingQuery(true);
            }
            String string8 = uRI.getRawFragment();
            if (string8 == null) break block11;
            string = string8;
            bl = false;
            uRLBuilder.setEncodedFragment(string);
        }
        return uRLBuilder;
    }

    public static final URLBuilder takeFrom(URLBuilder uRLBuilder, URL uRL) {
        URLBuilder uRLBuilder2;
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
        String string = uRL.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        if (StringsKt.contains$default((CharSequence)string, (char)'_', (boolean)false, (int)2, null)) {
            String string2 = uRL.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            uRLBuilder2 = URLParserKt.takeFrom(uRLBuilder, string2);
        } else {
            URI uRI = uRL.toURI();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"");
            uRLBuilder2 = URLUtilsJvmKt.takeFrom(uRLBuilder, uRI);
        }
        return uRLBuilder2;
    }

    public static final URI toURI(Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        return new URI(url.toString());
    }

    public static final Url Url(URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"");
        return URLUtilsJvmKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), uRI).build();
    }
}

