/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.Parameters;
import io.ktor.http.URLProtocol;
import io.ktor.http.UrlJvmSerializer;
import io.ktor.http.UrlSerializer;
import io.ktor.utils.io.JvmSerializable_jvmKt;
import io.ktor.utils.io.JvmSerializer;
import java.io.Serializable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;

@kotlinx.serialization.Serializable(with=UrlSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b:\b\u0007\u0018\u0000 P2\u00060\u0001j\u0002`\u0002:\u0001PBe\b\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b \u0010\u0016R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010\u001cR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001f\u001a\u0004\b&\u0010\u0016R\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001f\u001a\u0004\b'\u0010\u0016R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001f\u001a\u0004\b(\u0010\u0016R\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010\u0012\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u001fR&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\n\u0010,\u0012\u0004\b/\u00100\u001a\u0004\b-\u0010.R\u001d\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006\u00a2\u0006\f\n\u0004\b1\u0010,\u001a\u0004\b2\u0010.R!\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u0010.R\u0019\u00107\u001a\u0004\u0018\u00010\u00038\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00108\u001a\u0004\b;\u0010:R\u0011\u0010=\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001cR\u001b\u0010@\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u00104\u001a\u0004\b?\u0010\u0016R\u001b\u0010C\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u00104\u001a\u0004\bB\u0010\u0016R\u001b\u0010F\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u00104\u001a\u0004\bE\u0010\u0016R\u001d\u0010I\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u00104\u001a\u0004\bH\u0010\u0016R\u001d\u0010L\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u00104\u001a\u0004\bK\u0010\u0016R\u001b\u0010O\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u00104\u001a\u0004\bN\u0010\u0016\u00a8\u0006Q"}, d2={"Lio/ktor/http/Url;", "Ljava/io/Serializable;", "Lio/ktor/utils/io/JvmSerializable;", "Lio/ktor/http/URLProtocol;", "protocol", "", "host", "", "specifiedPort", "", "pathSegments", "Lio/ktor/http/Parameters;", "parameters", "fragment", "user", "password", "", "trailingQuery", "urlString", "<init>", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/util/List;Lio/ktor/http/Parameters;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "toString", "()Ljava/lang/String;", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "writeReplace", "()Ljava/lang/Object;", "Ljava/lang/String;", "getHost", "I", "getSpecifiedPort", "Lio/ktor/http/Parameters;", "getParameters", "()Lio/ktor/http/Parameters;", "getFragment", "getUser", "getPassword", "Z", "getTrailingQuery", "()Z", "Ljava/util/List;", "getPathSegments", "()Ljava/util/List;", "getPathSegments$annotations", "()V", "rawSegments", "getRawSegments", "segments$delegate", "Lkotlin/Lazy;", "getSegments", "segments", "protocolOrNull", "Lio/ktor/http/URLProtocol;", "getProtocolOrNull", "()Lio/ktor/http/URLProtocol;", "getProtocol", "getPort", "port", "encodedPath$delegate", "getEncodedPath", "encodedPath", "encodedQuery$delegate", "getEncodedQuery", "encodedQuery", "encodedPathAndQuery$delegate", "getEncodedPathAndQuery", "encodedPathAndQuery", "encodedUser$delegate", "getEncodedUser", "encodedUser", "encodedPassword$delegate", "getEncodedPassword", "encodedPassword", "encodedFragment$delegate", "getEncodedFragment", "encodedFragment", "Companion", "ktor-http"})
public final class Url
implements Serializable {
    public static final Companion Companion = new Companion(null);
    private final String host;
    private final int specifiedPort;
    private final Parameters parameters;
    private final String fragment;
    private final String user;
    private final String password;
    private final boolean trailingQuery;
    private final String urlString;
    private final List<String> pathSegments;
    private final List<String> rawSegments;
    private final Lazy segments$delegate;
    private final URLProtocol protocolOrNull;
    private final URLProtocol protocol;
    private final Lazy encodedPath$delegate;
    private final Lazy encodedQuery$delegate;
    private final Lazy encodedPathAndQuery$delegate;
    private final Lazy encodedUser$delegate;
    private final Lazy encodedPassword$delegate;
    private final Lazy encodedFragment$delegate;

    public Url(URLProtocol uRLProtocol, String string, int n, List<String> list, Parameters parameters, String string2, String string3, String string4, boolean bl, String string5) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"");
        this.host = string;
        this.specifiedPort = n;
        this.parameters = parameters;
        this.fragment = string2;
        this.user = string3;
        this.password = string4;
        this.trailingQuery = bl;
        this.urlString = string5;
        int n2 = this.specifiedPort;
        if (!(0 <= n2 ? n2 < 65536 : false)) {
            boolean bl2 = false;
            String string6 = "Port must be between 0 and 65535, or 0 if not set. Provided: " + this.specifiedPort;
            throw new IllegalArgumentException(string6.toString());
        }
        this.pathSegments = list;
        this.rawSegments = list;
        this.segments$delegate = LazyKt.lazy(() -> Url.segments_delegate$lambda$1(list));
        this.protocolOrNull = uRLProtocol;
        URLProtocol uRLProtocol2 = this.protocolOrNull;
        if (uRLProtocol2 == null) {
            uRLProtocol2 = URLProtocol.Companion.getHTTP();
        }
        this.protocol = uRLProtocol2;
        this.encodedPath$delegate = LazyKt.lazy(() -> Url.encodedPath_delegate$lambda$3(list, this));
        this.encodedQuery$delegate = LazyKt.lazy(() -> Url.encodedQuery_delegate$lambda$4(this));
        this.encodedPathAndQuery$delegate = LazyKt.lazy(() -> Url.encodedPathAndQuery_delegate$lambda$5(this));
        this.encodedUser$delegate = LazyKt.lazy(() -> Url.encodedUser_delegate$lambda$6(this));
        this.encodedPassword$delegate = LazyKt.lazy(() -> Url.encodedPassword_delegate$lambda$7(this));
        this.encodedFragment$delegate = LazyKt.lazy(() -> Url.encodedFragment_delegate$lambda$8(this));
    }

    public final String getHost() {
        return this.host;
    }

    public final int getSpecifiedPort() {
        return this.specifiedPort;
    }

    public final Parameters getParameters() {
        return this.parameters;
    }

    public final String getFragment() {
        return this.fragment;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getPassword() {
        return this.password;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    public final List<String> getPathSegments() {
        return this.pathSegments;
    }

    @Deprecated(message="\n        `pathSegments` is deprecated.\n\n        This property will contain an empty path segment at the beginning for URLs with a hostname,\n        and an empty path segment at the end for the URLs with a trailing slash. If you need to keep this behaviour please\n        use [rawSegments]. If you only need to access the meaningful parts of the path, consider using [segments] instead.\n             \n        Please decide if you need [rawSegments] or [segments] explicitly.\n        ", replaceWith=@ReplaceWith(expression="rawSegments", imports={}))
    public static /* synthetic */ void getPathSegments$annotations() {
    }

    public final List<String> getRawSegments() {
        return this.rawSegments;
    }

    public final List<String> getSegments() {
        Lazy lazy = this.segments$delegate;
        return (List)lazy.getValue();
    }

    public final URLProtocol getProtocolOrNull() {
        return this.protocolOrNull;
    }

    public final URLProtocol getProtocol() {
        return this.protocol;
    }

    public final int getPort() {
        Integer n = this.specifiedPort;
        int n2 = ((Number)n).intValue();
        boolean bl = false;
        Integer n3 = !(n2 == 0) ? n : null;
        return n3 != null ? n3.intValue() : this.protocol.getDefaultPort();
    }

    public final String getEncodedPath() {
        Lazy lazy = this.encodedPath$delegate;
        return (String)lazy.getValue();
    }

    public final String getEncodedQuery() {
        Lazy lazy = this.encodedQuery$delegate;
        return (String)lazy.getValue();
    }

    public final String getEncodedPathAndQuery() {
        Lazy lazy = this.encodedPathAndQuery$delegate;
        return (String)lazy.getValue();
    }

    public final String getEncodedUser() {
        Lazy lazy = this.encodedUser$delegate;
        return (String)lazy.getValue();
    }

    public final String getEncodedPassword() {
        Lazy lazy = this.encodedPassword$delegate;
        return (String)lazy.getValue();
    }

    public final String getEncodedFragment() {
        Lazy lazy = this.encodedFragment$delegate;
        return (String)lazy.getValue();
    }

    public String toString() {
        return this.urlString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Url cfr_ignored_0 = (Url)object;
        return Intrinsics.areEqual((Object)this.urlString, (Object)((Url)object).urlString);
    }

    public int hashCode() {
        return this.urlString.hashCode();
    }

    private final Object writeReplace() {
        return JvmSerializable_jvmKt.JvmSerializerReplacement((JvmSerializer)UrlJvmSerializer.INSTANCE, (Object)this);
    }

    private static final List segments_delegate$lambda$1(List list) {
        if (list.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int n = ((CharSequence)CollectionsKt.first((List)list)).length() == 0 && list.size() > 1 ? 1 : 0;
        int n2 = ((CharSequence)CollectionsKt.last((List)list)).length() == 0 ? CollectionsKt.getLastIndex((List)list) : CollectionsKt.getLastIndex((List)list) + 1;
        return list.subList(n, n2);
    }

    private static final String encodedPath_delegate$lambda$3(List list, Url url) {
        if (list.isEmpty()) {
            return "";
        }
        int n = StringsKt.indexOf$default((CharSequence)url.urlString, (char)'/', (int)(url.protocol.getName().length() + 3), (boolean)false, (int)4, null);
        if (n == -1) {
            return "";
        }
        char[] cArray = new char[]{'?', '#'};
        int n2 = StringsKt.indexOfAny$default((CharSequence)url.urlString, (char[])cArray, (int)n, (boolean)false, (int)4, null);
        if (n2 == -1) {
            String string = url.urlString.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return string;
        }
        String string = url.urlString.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final String encodedQuery_delegate$lambda$4(Url url) {
        int n = StringsKt.indexOf$default((CharSequence)url.urlString, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
        if (n == 0) {
            return "";
        }
        int n2 = StringsKt.indexOf$default((CharSequence)url.urlString, (char)'#', (int)n, (boolean)false, (int)4, null);
        if (n2 == -1) {
            String string = url.urlString.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return string;
        }
        String string = url.urlString.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final String encodedPathAndQuery_delegate$lambda$5(Url url) {
        int n = StringsKt.indexOf$default((CharSequence)url.urlString, (char)'/', (int)(url.protocol.getName().length() + 3), (boolean)false, (int)4, null);
        if (n == -1) {
            return "";
        }
        int n2 = StringsKt.indexOf$default((CharSequence)url.urlString, (char)'#', (int)n, (boolean)false, (int)4, null);
        if (n2 == -1) {
            String string = url.urlString.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return string;
        }
        String string = url.urlString.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final String encodedUser_delegate$lambda$6(Url url) {
        if (url.user == null) {
            return null;
        }
        if (((CharSequence)url.user).length() == 0) {
            return "";
        }
        int n = url.protocol.getName().length() + 3;
        char[] cArray = new char[]{':', '@'};
        int n2 = StringsKt.indexOfAny$default((CharSequence)url.urlString, (char[])cArray, (int)n, (boolean)false, (int)4, null);
        String string = url.urlString.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final String encodedPassword_delegate$lambda$7(Url url) {
        if (url.password == null) {
            return null;
        }
        if (((CharSequence)url.password).length() == 0) {
            return "";
        }
        int n = StringsKt.indexOf$default((CharSequence)url.urlString, (char)':', (int)(url.protocol.getName().length() + 3), (boolean)false, (int)4, null) + 1;
        int n2 = StringsKt.indexOf$default((CharSequence)url.urlString, (char)'@', (int)0, (boolean)false, (int)6, null);
        String string = url.urlString.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final String encodedFragment_delegate$lambda$8(Url url) {
        int n = StringsKt.indexOf$default((CharSequence)url.urlString, (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
        if (n == 0) {
            return "";
        }
        String string = url.urlString.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/ktor/http/Url$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lio/ktor/http/Url;", "serializer", "()Lkotlinx/serialization/KSerializer;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public final KSerializer<Url> serializer() {
            return UrlSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

