/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import org.e.a.b;
import org.e.a.e;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Mechanisms;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.core.ScramSha1PlusMechanism;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.util.StringUtils;

public final class SASLAuthentication {
    private static final Logger LOGGER = Logger.getLogger(SASLAuthentication.class.getName());
    private static final List<SASLMechanism> REGISTERED_MECHANISMS = new ArrayList<SASLMechanism>();
    private static final Set<String> BLACKLISTED_MECHANISMS = new HashSet<String>();
    private final AbstractXMPPConnection connection;
    private final ConnectionConfiguration configuration;
    private SASLMechanism currentMechanism = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSASLMechanism(SASLMechanism sASLMechanism) {
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            REGISTERED_MECHANISMS.add(sASLMechanism);
            Collections.sort(REGISTERED_MECHANISMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getRegisterdSASLMechanisms() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            for (SASLMechanism sASLMechanism : REGISTERED_MECHANISMS) {
                linkedHashMap.put(sASLMechanism.getClass().getName(), sASLMechanism.toString());
            }
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSaslMechanismRegistered(String string) {
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            for (SASLMechanism sASLMechanism : REGISTERED_MECHANISMS) {
                if (!sASLMechanism.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterSASLMechanism(String string) {
        List<SASLMechanism> list = REGISTERED_MECHANISMS;
        synchronized (list) {
            Iterator<SASLMechanism> iterator = REGISTERED_MECHANISMS.iterator();
            while (iterator.hasNext()) {
                SASLMechanism sASLMechanism = iterator.next();
                if (!sASLMechanism.getClass().getName().equals(string)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean blacklistSASLMechanism(String string) {
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            return BLACKLISTED_MECHANISMS.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unBlacklistSASLMechanism(String string) {
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            return BLACKLISTED_MECHANISMS.remove(string);
        }
    }

    public static Set<String> getBlacklistedSASLMechanisms() {
        return Collections.unmodifiableSet(BLACKLISTED_MECHANISMS);
    }

    SASLAuthentication(AbstractXMPPConnection abstractXMPPConnection, ConnectionConfiguration connectionConfiguration) {
        this.configuration = connectionConfiguration;
        this.connection = abstractXMPPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SASLMechanism authenticate(String string, String string2, e e2, SSLSession sSLSession) {
        SASLMechanism sASLMechanism = this.selectMechanism(e2, string2);
        CallbackHandler callbackHandler = this.configuration.getCallbackHandler();
        String string3 = this.connection.getHost();
        b b2 = this.connection.getXMPPServiceDomain();
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            long l;
            this.currentMechanism = sASLMechanism;
            if (callbackHandler != null) {
                this.currentMechanism.authenticate(string3, b2, callbackHandler, e2, sSLSession);
            } else {
                this.currentMechanism.authenticate(string, string3, b2, string2, e2, sSLSession);
            }
            long l2 = System.currentTimeMillis() + this.connection.getReplyTimeout();
            while (!sASLMechanism.isFinished() && (l = System.currentTimeMillis()) < l2) {
                this.wait(l2 - l);
            }
        }
        sASLMechanism.throwExceptionIfRequired();
        return sASLMechanism;
    }

    void challengeReceived(SaslNonza.Challenge challenge) {
        this.challengeReceived(challenge.getData(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void challengeReceived(String string, boolean bl) {
        SASLMechanism sASLMechanism;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            sASLMechanism = this.currentMechanism;
        }
        sASLMechanism.challengeReceived(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticated(SaslNonza.Success success) {
        if (success.getData() != null) {
            this.challengeReceived(success.getData(), true);
        }
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.currentMechanism.afterFinalSaslChallenge();
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticationFailed(SaslNonza.SASLFailure sASLFailure) {
        SASLErrorException sASLErrorException;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            sASLErrorException = new SASLErrorException(this.currentMechanism.getName(), sASLFailure);
        }
        this.authenticationFailed(sASLErrorException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticationFailed(Exception exception) {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.currentMechanism.setException(exception);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticationSuccessful() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            if (this.currentMechanism == null) {
                return false;
            }
            return this.currentMechanism.isAuthenticationSuccessful();
        }
    }

    String getNameOfLastUsedSaslMechansism() {
        SASLMechanism sASLMechanism = this.currentMechanism;
        if (sASLMechanism == null) {
            return null;
        }
        return sASLMechanism.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SASLMechanism selectMechanism(e e2, String string) {
        Object object;
        boolean bl = StringUtils.isNotEmpty((CharSequence)string);
        Iterator<SASLMechanism> iterator = REGISTERED_MECHANISMS.iterator();
        List<String> list = this.getServerMechanisms();
        if (list.isEmpty()) {
            LOGGER.warning("Server did not report any SASL mechanisms");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string2 = ((SASLMechanism)object).getName();
            if (!list.contains(string2)) continue;
            Set<String> set = BLACKLISTED_MECHANISMS;
            synchronized (set) {
                if (BLACKLISTED_MECHANISMS.contains(string2)) {
                    continue;
                }
            }
            if (!this.configuration.isEnabledSaslMechanism(string2)) continue;
            if (e2 != null && !((SASLMechanism)object).authzidSupported()) {
                arrayList.add("Skipping " + object + " because authzid is required by not supported by this SASL mechanism");
                continue;
            }
            if (((SASLMechanism)object).requiresPassword() && !bl) {
                arrayList.add("Skipping " + object + " because a password is required for it, but none was provided to the connection configuration");
                continue;
            }
            return ((SASLMechanism)object).instanceForAuthentication(this.connection, this.configuration);
        }
        object = BLACKLISTED_MECHANISMS;
        synchronized (object) {
            throw new SmackException.SmackSaslException("No supported and enabled SASL Mechanism provided by server. Server announced mechanisms: " + list + ". Registered SASL mechanisms with Smack: " + REGISTERED_MECHANISMS + ". Enabled SASL mechanisms for this connection: " + this.configuration.getEnabledSaslMechanisms() + ". Blacklisted SASL mechanisms: " + BLACKLISTED_MECHANISMS + ". Skip reasons: " + arrayList);
        }
    }

    private List<String> getServerMechanisms() {
        Mechanisms mechanisms = this.connection.getFeature(Mechanisms.class);
        if (mechanisms == null) {
            return Collections.emptyList();
        }
        return mechanisms.getMechanisms();
    }

    static {
        SASLAuthentication.blacklistSASLMechanism(ScramSha1PlusMechanism.NAME);
    }
}

