/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.ReflectionDebuggerFactory;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallbackWithHint;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.util.Objects;

public final class SmackConfiguration {
    public static final String SMACK_URL_STRING = "https://igniterealtime.org/projects/smack";
    public static final URL SMACK_URL;
    private static int defaultPacketReplyTimeout;
    private static int packetCollectorSize;
    private static List<String> defaultMechs;
    static Set<String> disabledSmackClasses;
    static final List<XMPPInputOutputStream> compressionHandlers;
    static boolean smackInitialized;
    public static boolean DEBUG;
    private static SmackDebuggerFactory DEFAULT_DEBUGGER_FACTORY;
    private static ParsingExceptionCallback defaultCallback;
    private static HostnameVerifier defaultHostnameVerififer;
    private static UnknownIqRequestReplyMode unknownIqRequestReplyMode;
    private static final int defaultConcurrencyLevelLimit;
    private static final Set<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>> KNOWN_MODULES;
    public static boolean TRUELY_ASYNC_SENDS;

    @Deprecated
    public static String getVersion() {
        return SmackInitialization.SMACK_VERSION;
    }

    public static int getDefaultReplyTimeout() {
        if (defaultPacketReplyTimeout <= 0) {
            defaultPacketReplyTimeout = 5000;
        }
        return defaultPacketReplyTimeout;
    }

    public static void setDefaultReplyTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        defaultPacketReplyTimeout = n;
    }

    public static void setDefaultSmackDebuggerFactory(SmackDebuggerFactory smackDebuggerFactory) {
        DEFAULT_DEBUGGER_FACTORY = Objects.requireNonNull(smackDebuggerFactory, "Debugger factory must not be null");
    }

    public static SmackDebuggerFactory getDefaultSmackDebuggerFactory() {
        return DEFAULT_DEBUGGER_FACTORY;
    }

    public static int getStanzaCollectorSize() {
        return packetCollectorSize;
    }

    public static void setStanzaCollectorSize(int n) {
        packetCollectorSize = n;
    }

    public static void addSaslMech(String string) {
        if (!defaultMechs.contains(string)) {
            defaultMechs.add(string);
        }
    }

    public static void addSaslMechs(Collection<String> collection) {
        for (String string : collection) {
            SmackConfiguration.addSaslMech(string);
        }
    }

    public static void removeSaslMech(String string) {
        defaultMechs.remove(string);
    }

    public static void removeSaslMechs(Collection<String> collection) {
        defaultMechs.removeAll(collection);
    }

    public static List<String> getSaslMechs() {
        return Collections.unmodifiableList(defaultMechs);
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback parsingExceptionCallback) {
        defaultCallback = parsingExceptionCallback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        return defaultCallback;
    }

    public static void addCompressionHandler(XMPPInputOutputStream xMPPInputOutputStream) {
        compressionHandlers.add(xMPPInputOutputStream);
    }

    public static List<XMPPInputOutputStream> getCompressionHandlers() {
        ArrayList<XMPPInputOutputStream> arrayList = new ArrayList<XMPPInputOutputStream>(compressionHandlers.size());
        for (XMPPInputOutputStream xMPPInputOutputStream : compressionHandlers) {
            if (!xMPPInputOutputStream.isSupported()) continue;
            arrayList.add(xMPPInputOutputStream);
        }
        return arrayList;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        defaultHostnameVerififer = hostnameVerifier;
    }

    public static void addDisabledSmackClass(Class<?> clazz) {
        SmackConfiguration.addDisabledSmackClass(clazz.getName());
    }

    public static void addDisabledSmackClass(String string) {
        disabledSmackClasses.add(string);
    }

    public static void addDisabledSmackClasses(String ... stringArray) {
        for (String string : stringArray) {
            SmackConfiguration.addDisabledSmackClass(string);
        }
    }

    public static boolean isDisabledSmackClass(String string) {
        for (String string2 : disabledSmackClasses) {
            if (string2.equals(string)) {
                return true;
            }
            int n = string2.lastIndexOf(46);
            if (string2.length() <= n || Character.isUpperCase(string2.charAt(n + 1)) || !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSmackInitialized() {
        return smackInitialized;
    }

    static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerififer;
    }

    public static UnknownIqRequestReplyMode getUnknownIqRequestReplyMode() {
        return unknownIqRequestReplyMode;
    }

    public static void setUnknownIqRequestReplyMode(UnknownIqRequestReplyMode unknownIqRequestReplyMode) {
        SmackConfiguration.unknownIqRequestReplyMode = Objects.requireNonNull(unknownIqRequestReplyMode, "Must set mode");
    }

    public static int getDefaultConcurrencyLevelLimit() {
        return defaultConcurrencyLevelLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addModule(Class<? extends ModularXmppClientToServerConnectionModuleDescriptor> clazz) {
        Set<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>> set = KNOWN_MODULES;
        synchronized (set) {
            return KNOWN_MODULES.add(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAllKnownModulesTo(ModularXmppClientToServerConnectionConfiguration.Builder builder) {
        Set<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>> set = KNOWN_MODULES;
        synchronized (set) {
            for (Class<? extends ModularXmppClientToServerConnectionModuleDescriptor> clazz : KNOWN_MODULES) {
                builder.addModule(clazz);
            }
        }
    }

    static {
        try {
            SMACK_URL = new URL(SMACK_URL_STRING);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
        defaultPacketReplyTimeout = 5000;
        packetCollectorSize = 5000;
        defaultMechs = new ArrayList<String>();
        disabledSmackClasses = new HashSet<String>();
        compressionHandlers = new ArrayList<XMPPInputOutputStream>(2);
        smackInitialized = false;
        DEBUG = false;
        DEFAULT_DEBUGGER_FACTORY = ReflectionDebuggerFactory.INSTANCE;
        defaultCallback = new ExceptionThrowingCallbackWithHint();
        unknownIqRequestReplyMode = UnknownIqRequestReplyMode.replyFeatureNotImplemented;
        int n = Runtime.getRuntime().availableProcessors();
        defaultConcurrencyLevelLimit = n < 8 ? 8 : (int)((double)n * 1.1);
        KNOWN_MODULES = new HashSet<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>>();
        TRUELY_ASYNC_SENDS = false;
    }

    public static enum UnknownIqRequestReplyMode {
        doNotReply,
        replyFeatureNotImplemented,
        replyServiceUnavailable;

    }
}

