/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.c2s.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.e.a.b.d;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.fsm.LoginContext;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateDescriptorGraph;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Objects;

public final class WalkStateGraphContext {
    private final Class<? extends StateDescriptor> initialStateClass;
    private final Class<? extends StateDescriptor> finalStateClass;
    private final Class<? extends StateDescriptor> mandatoryIntermediateState;
    private final LoginContext loginContext;
    private final List<State> walkedStateGraphPath = new ArrayList<State>();
    final Map<State, StateTransitionResult> failedStates = new LinkedHashMap<State, StateTransitionResult>();
    boolean mandatoryIntermediateStateHandled;

    WalkStateGraphContext(Builder builder) {
        this.initialStateClass = builder.initialStateClass;
        this.finalStateClass = builder.finalStateClass;
        this.mandatoryIntermediateState = builder.mandatoryIntermediateState;
        this.loginContext = builder.loginContext;
    }

    public void recordWalkTo(State state) {
        this.walkedStateGraphPath.add(state);
    }

    public boolean isWalksFinalState(StateDescriptor stateDescriptor) {
        return stateDescriptor.getClass() == this.finalStateClass;
    }

    public boolean isFinalStateAuthenticatedAndResourceBound() {
        return this.finalStateClass == ModularXmppClientToServerConnection.AuthenticatedAndResourceBoundStateDescriptor.class;
    }

    public StateDescriptorGraph.GraphVertex<State> maybeReturnMandatoryImmediateState(List<StateDescriptorGraph.GraphVertex<State>> list) {
        for (StateDescriptorGraph.GraphVertex<State> graphVertex : list) {
            if (graphVertex.getElement().getStateDescriptor().getClass() != this.mandatoryIntermediateState) continue;
            this.mandatoryIntermediateStateHandled = true;
            return graphVertex;
        }
        return null;
    }

    public List<State> getWalk() {
        return CollectionUtil.newListWith(this.walkedStateGraphPath);
    }

    public int getWalkLength() {
        return this.walkedStateGraphPath.size();
    }

    public void appendWalkTo(List<State> list) {
        list.addAll(this.walkedStateGraphPath);
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public boolean stateAlreadyVisited(State state) {
        return this.walkedStateGraphPath.contains(state);
    }

    public void recordFailedState(State state, StateTransitionResult stateTransitionResult) {
        this.failedStates.put(state, stateTransitionResult);
    }

    public Map<State, StateTransitionResult> getFailedStates() {
        return new HashMap<State, StateTransitionResult>(this.failedStates);
    }

    public boolean wouldCauseCycle(StateDescriptorGraph.GraphVertex<State> graphVertex) {
        HashSet<Class<? extends StateDescriptor>> hashSet = new HashSet<Class<? extends StateDescriptor>>();
        return this.wouldCycleRecursive(graphVertex, hashSet);
    }

    private boolean wouldCycleRecursive(StateDescriptorGraph.GraphVertex<State> graphVertex, Set<Class<? extends StateDescriptor>> set) {
        Class<?> clazz = graphVertex.getElement().getStateDescriptor().getClass();
        if (clazz == this.initialStateClass) {
            return true;
        }
        if (this.finalStateClass == clazz || set.contains(clazz)) {
            return false;
        }
        set.add(clazz);
        for (StateDescriptorGraph.GraphVertex<State> graphVertex2 : graphVertex.getOutgoingEdges()) {
            boolean bl = this.wouldCycleRecursive(graphVertex2, set);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static Builder builder(Class<? extends StateDescriptor> clazz, Class<? extends StateDescriptor> clazz2) {
        return new Builder(clazz, clazz2);
    }

    public static final class Builder {
        private final Class<? extends StateDescriptor> initialStateClass;
        private final Class<? extends StateDescriptor> finalStateClass;
        private Class<? extends StateDescriptor> mandatoryIntermediateState;
        private LoginContext loginContext;

        private Builder(Class<? extends StateDescriptor> clazz, Class<? extends StateDescriptor> clazz2) {
            this.initialStateClass = Objects.requireNonNull(clazz);
            this.finalStateClass = Objects.requireNonNull(clazz2);
        }

        public Builder withMandatoryIntermediateState(Class<? extends StateDescriptor> clazz) {
            this.mandatoryIntermediateState = clazz;
            return this;
        }

        public Builder withLoginContext(String string, String string2, d d2) {
            LoginContext loginContext = new LoginContext(string, string2, d2);
            return this.withLoginContext(loginContext);
        }

        public Builder withLoginContext(LoginContext loginContext) {
            this.loginContext = loginContext;
            return this;
        }

        public WalkStateGraphContext build() {
            return new WalkStateGraphContext(this);
        }
    }
}

