/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.ExceptionUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class AbstractError {
    protected final String textNamespace;
    protected final Map<String, String> descriptiveTexts;
    protected final List<ExtensionElement> extensions;

    protected AbstractError(Map<String, String> map) {
        this(map, null);
    }

    protected AbstractError(Map<String, String> map, List<ExtensionElement> list) {
        this(map, null, list);
    }

    protected AbstractError(Map<String, String> map, String string, List<ExtensionElement> list) {
        this.descriptiveTexts = map != null ? map : Collections.emptyMap();
        this.textNamespace = string;
        this.extensions = list != null ? list : Collections.emptyList();
    }

    public String getDescriptiveText() {
        String[] stringArray;
        if (this.descriptiveTexts.isEmpty()) {
            return null;
        }
        Locale locale = Locale.getDefault();
        for (String string : stringArray = new String[]{locale.getLanguage() + "-" + locale.getCountry() + "-" + locale.getVariant(), locale.getLanguage() + "-" + locale.getCountry(), locale.getLanguage(), "en", ""}) {
            String string2 = this.getDescriptiveText(string);
            if (string2 == null) continue;
            return string2;
        }
        return this.descriptiveTexts.values().iterator().next();
    }

    public String getDescriptiveText(String string) {
        Objects.requireNonNull(string, "xmllang must not be null");
        return this.descriptiveTexts.get(string);
    }

    public <PE extends ExtensionElement> PE getExtension(String string, String string2) {
        return PacketUtil.extensionElementFrom(this.extensions, string, string2);
    }

    protected void addDescriptiveTextsAndExtensions(XmlStringBuilder xmlStringBuilder) {
        for (Map.Entry<String, String> entry : this.descriptiveTexts.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            xmlStringBuilder.halfOpenElement("text").xmlnsAttribute(this.textNamespace).optXmlLangAttribute(string).rightAngleBracket();
            xmlStringBuilder.escape(string2);
            xmlStringBuilder.closeElement("text");
        }
        xmlStringBuilder.append(this.extensions);
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected String textNamespace;
        protected Map<String, String> descriptiveTexts;
        protected List<ExtensionElement> extensions;

        public B setDescriptiveTexts(Map<String, String> map) {
            if (map == null) {
                this.descriptiveTexts = null;
                return this.getThis();
            }
            for (String string : map.keySet()) {
                if (string != null) continue;
                throw new IllegalArgumentException("descriptiveTexts cannot contain null key");
            }
            if (this.descriptiveTexts == null) {
                this.descriptiveTexts = map;
            } else {
                this.descriptiveTexts.putAll(map);
            }
            return this.getThis();
        }

        public B setDescriptiveEnText(String string) {
            if (this.descriptiveTexts == null) {
                this.descriptiveTexts = new HashMap<String, String>();
            }
            this.descriptiveTexts.put("en", string);
            return this.getThis();
        }

        public B setDescriptiveEnText(String string, Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(512);
            stringBuilder.append(string).append('\n');
            String string2 = ExceptionUtil.getStackTrace(exception);
            stringBuilder.append(string2);
            return this.setDescriptiveEnText(stringBuilder.toString());
        }

        public B setTextNamespace(String string) {
            this.textNamespace = string;
            return this.getThis();
        }

        public B setExtensions(List<ExtensionElement> list) {
            if (this.extensions == null) {
                this.extensions = list;
            } else {
                this.extensions.addAll(list);
            }
            return this.getThis();
        }

        public B addExtension(ExtensionElement extensionElement) {
            if (this.extensions == null) {
                this.extensions = new ArrayList<ExtensionElement>();
            }
            this.extensions.add(extensionElement);
            return this.getThis();
        }

        protected abstract B getThis();
    }
}

