/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.e.a.a.d;
import org.e.a.i;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageOrPresence;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class Message
extends MessageOrPresence<MessageBuilder>
implements MessageView {
    public static final String ELEMENT = "message";
    public static final String BODY = "body";
    private Type type;

    @Deprecated
    public Message() {
    }

    @Deprecated
    public Message(i i2) {
        this.setTo(i2);
    }

    @Deprecated
    public Message(i i2, Type type) {
        this(i2);
        this.setType(type);
    }

    @Deprecated
    public Message(i i2, String string) {
        this(i2);
        this.setBody(string);
    }

    @Deprecated
    public Message(String string, String string2) {
        this(d.a((String)string), string2);
    }

    @Deprecated
    public Message(i i2, ExtensionElement extensionElement) {
        this(i2);
        this.addExtension(extensionElement);
    }

    Message(MessageBuilder messageBuilder) {
        super(messageBuilder);
        this.type = messageBuilder.type;
    }

    public Message(Message message) {
        super(message);
        this.type = message.type;
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            return Type.normal;
        }
        return this.type;
    }

    @Deprecated
    public void setType(Type type) {
        this.type = type;
    }

    @Deprecated
    public void setSubject(String string) {
        if (string == null) {
            this.removeSubject("");
            return;
        }
        this.addSubject(null, string);
    }

    @Deprecated
    public Subject addSubject(String string, String string2) {
        string = Stanza.determineLanguage(this, string);
        List<Subject> list = this.getExtensions(Subject.class);
        for (Subject subject : list) {
            if (!string.equals(subject.getLanguage())) continue;
            throw new IllegalArgumentException("Subject with the language " + string + " already exists");
        }
        Subject subject = new Subject(string, string2);
        this.addExtension(subject);
        return subject;
    }

    @Deprecated
    public boolean removeSubject(String string) {
        string = Stanza.determineLanguage(this, string);
        for (Subject subject : this.getExtensions(Subject.class)) {
            if (!string.equals(subject.language)) continue;
            return this.removeSubject(subject);
        }
        return false;
    }

    @Deprecated
    public boolean removeSubject(Subject subject) {
        return this.removeExtension(subject) != null;
    }

    @Deprecated
    public void setBody(CharSequence charSequence) {
        String string = charSequence != null ? charSequence.toString() : null;
        this.setBody(string);
    }

    @Deprecated
    public void setBody(String string) {
        if (string == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, string);
    }

    @Deprecated
    public Body addBody(String string, String string2) {
        string = Stanza.determineLanguage(this, string);
        this.removeBody(string);
        Body body = new Body(string, string2);
        this.addExtension(body);
        return body;
    }

    @Deprecated
    public boolean removeBody(String string) {
        string = Stanza.determineLanguage(this, string);
        for (Body body : this.getBodies()) {
            String string2 = body.getLanguage();
            if (!Objects.equals(string2, string)) continue;
            this.removeExtension(body);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeBody(Body body) {
        ExtensionElement extensionElement = this.removeExtension(body);
        return extensionElement != null;
    }

    @Deprecated
    public void setThread(String string) {
        this.addExtension(new Thread(string));
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public MessageBuilder asBuilder() {
        return StanzaBuilder.buildMessageFrom(this, this.getStanzaId());
    }

    @Override
    public MessageBuilder asBuilder(String string) {
        return StanzaBuilder.buildMessageFrom(this, string);
    }

    @Override
    public MessageBuilder asBuilder(XMPPConnection xMPPConnection) {
        return xMPPConnection.getStanzaFactory().buildMessageStanzaFrom(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Message Stanza [");
        this.logCommonAttributes(stringBuilder);
        if (this.type != null) {
            stringBuilder.append("type=").append((Object)this.type).append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this, xmlEnvironment);
        this.addCommonAttributes(xmlStringBuilder);
        xmlStringBuilder.optAttribute("type", this.type);
        xmlStringBuilder.rightAngleBracket();
        if (this.type == Type.error) {
            this.appendErrorIfExists(xmlStringBuilder);
        }
        xmlStringBuilder.append(this.getExtensions());
        xmlStringBuilder.closeElement(ELEMENT);
        return xmlStringBuilder;
    }

    @Deprecated
    public Message clone() {
        return new Message(this);
    }

    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }

    public static class Thread
    implements ExtensionElement {
        public static final String ELEMENT = "thread";
        public static final String NAMESPACE = "jabber:client";
        public static final QName QNAME = new QName("jabber:client", "thread");
        public static final String PARENT_ATTRIBUTE_NAME = "parent";
        private final String thread;
        private final String parent;

        public Thread(String string) {
            this(string, null);
        }

        public Thread(String string, String string2) {
            this.thread = StringUtils.requireNotNullNorEmpty(string, "thread must not be null nor empty");
            this.parent = StringUtils.requireNullOrNotEmpty(string2, "parent must be null or not empty");
        }

        public String getThread() {
            return this.thread;
        }

        public String getParent() {
            return this.parent;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return NAMESPACE;
        }

        @Override
        public QName getQName() {
            return QNAME;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this, xmlEnvironment);
            xmlStringBuilder.optAttribute(PARENT_ATTRIBUTE_NAME, this.parent);
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.escape(this.thread);
            xmlStringBuilder.closeElement(this);
            return xmlStringBuilder;
        }
    }

    public static final class Body
    implements ExtensionElement {
        public static final String ELEMENT = "body";
        public static final String NAMESPACE = "jabber:client";
        public static final QName QNAME = new QName("jabber:client", "body");
        private final String message;
        private final String language;
        private final BodyElementNamespace namespace;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Body(String string, String string2) {
            this(string, string2, BodyElementNamespace.client);
        }

        public Body(String string, String string2, BodyElementNamespace bodyElementNamespace) {
            if (string2 == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.language = string;
            this.message = string2;
            this.namespace = Objects.requireNonNull(bodyElementNamespace);
        }

        @Override
        public String getLanguage() {
            return this.language;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(builder -> builder.append(this.language).append(this.message));
        }

        public boolean equals(Object object) {
            return EqualsUtil.equals(this, object, (builder, body) -> builder.append(this.language, body.language).append(this.message, body.message));
        }

        @Override
        public String getElementName() {
            return "body";
        }

        @Override
        public String getNamespace() {
            return this.namespace.xmlNamespace;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this, xmlEnvironment);
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.text(this.message);
            xmlStringBuilder.closeElement(this.getElementName());
            return xmlStringBuilder;
        }

        static enum BodyElementNamespace {
            client("jabber:client"),
            server("jabber:server");

            private final String xmlNamespace;

            private BodyElementNamespace(String string2) {
                this.xmlNamespace = string2;
            }

            public String getNamespace() {
                return this.xmlNamespace;
            }
        }
    }

    public static final class Subject
    implements ExtensionElement {
        public static final String ELEMENT = "subject";
        public static final String NAMESPACE = "jabber:client";
        public static final QName QNAME = new QName("jabber:client", "subject");
        private final String subject;
        private final String language;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Subject(String string, String string2) {
            if (string2 == null) {
                throw new NullPointerException("Subject cannot be null.");
            }
            this.language = string;
            this.subject = string2;
        }

        @Override
        public String getLanguage() {
            return this.language;
        }

        public String getSubject() {
            return this.subject;
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(builder -> builder.append(this.language).append(this.subject));
        }

        public boolean equals(Object object) {
            return EqualsUtil.equals(this, object, (builder, subject) -> builder.append(this.language, subject.language).append(this.subject, subject.subject));
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return NAMESPACE;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this, xmlEnvironment);
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.escape(this.subject);
            xmlStringBuilder.closeElement(this.getElementName());
            return xmlStringBuilder;
        }
    }
}

