/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import org.e.a.i;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.MessageOrPresence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.PresenceView;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class Presence
extends MessageOrPresence<PresenceBuilder>
implements PresenceView {
    public static final String ELEMENT = "presence";
    private Type type = Type.available;
    private String status = null;
    private Byte priority;
    private Mode mode = null;

    @Deprecated
    public Presence(Type type) {
        this.setType(type);
    }

    @Deprecated
    public Presence(i i2, Type type) {
        this(type);
        this.setTo(i2);
    }

    @Deprecated
    public Presence(Type type, String string, int n, Mode mode) {
        this.setType(type);
        this.setStatus(string);
        this.setPriority(n);
        this.setMode(mode);
    }

    Presence(PresenceBuilder presenceBuilder) {
        super(presenceBuilder);
        this.type = presenceBuilder.type;
        this.status = presenceBuilder.status;
        this.priority = presenceBuilder.priority;
        this.mode = presenceBuilder.mode;
    }

    public Presence(Presence presence) {
        super(presence);
        this.type = presence.type;
        this.status = presence.status;
        this.priority = presence.priority;
        this.mode = presence.mode;
    }

    public boolean isAvailable() {
        return this.type == Type.available;
    }

    public boolean isAway() {
        return this.type == Type.available && (this.mode == Mode.away || this.mode == Mode.xa || this.mode == Mode.dnd);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Deprecated
    public void setType(Type type) {
        this.type = Objects.requireNonNull(type, "Type cannot be null");
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Deprecated
    public void setStatus(String string) {
        this.status = string;
    }

    @Override
    public int getPriority() {
        return this.getPriorityByte();
    }

    @Override
    public byte getPriorityByte() {
        if (this.priority == null) {
            return 0;
        }
        return this.priority;
    }

    @Deprecated
    public void setPriority(int n) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException("Priority value " + n + " is not valid. Valid range is -128 through 127.");
        }
        this.setPriority((byte)n);
    }

    public void setPriority(byte by) {
        this.priority = by;
    }

    @Override
    public Mode getMode() {
        if (this.mode == null) {
            return Mode.available;
        }
        return this.mode;
    }

    @Deprecated
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public PresenceBuilder asBuilder() {
        return StanzaBuilder.buildPresenceFrom(this, this.getStanzaId());
    }

    @Override
    public PresenceBuilder asBuilder(String string) {
        return StanzaBuilder.buildPresenceFrom(this, string);
    }

    @Override
    public PresenceBuilder asBuilder(XMPPConnection xMPPConnection) {
        return xMPPConnection.getStanzaFactory().buildPresenceStanzaFrom(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Presence Stanza [");
        this.logCommonAttributes(stringBuilder);
        stringBuilder.append("type=").append((Object)this.type).append(',');
        if (this.mode != null) {
            stringBuilder.append("mode=").append((Object)this.mode).append(',');
        }
        if (!StringUtils.isNullOrEmpty((CharSequence)this.status)) {
            stringBuilder.append("status=").append(this.status).append(',');
        }
        if (this.priority != null) {
            stringBuilder.append("prio=").append(this.priority).append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this, xmlEnvironment);
        this.addCommonAttributes(xmlStringBuilder);
        if (this.type != Type.available) {
            xmlStringBuilder.attribute("type", this.type);
        }
        List<ExtensionElement> list = this.getExtensions();
        if (this.status == null && this.priority == null && (this.mode == null || this.mode == Mode.available) && list.isEmpty() && this.getError() == null) {
            return xmlStringBuilder.closeEmptyElement();
        }
        xmlStringBuilder.rightAngleBracket();
        xmlStringBuilder.optElement("status", this.status);
        xmlStringBuilder.optElement("priority", this.priority);
        if (this.mode != null && this.mode != Mode.available) {
            xmlStringBuilder.element("show", this.mode);
        }
        xmlStringBuilder.append(list);
        this.appendErrorIfExists(xmlStringBuilder);
        xmlStringBuilder.closeElement(ELEMENT);
        return xmlStringBuilder;
    }

    @Deprecated
    public Presence clone() {
        return new Presence(this);
    }

    @Deprecated
    public Presence cloneWithNewId() {
        Presence presence = this.clone();
        presence.setNewStanzaId();
        return presence;
    }

    public static enum Mode {
        chat,
        available,
        away,
        xa,
        dnd;


        public static Mode fromString(String string) {
            return Mode.valueOf(string.toLowerCase(Locale.US));
        }
    }

    public static enum Type {
        available,
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        error,
        probe;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

