/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class StandardExtensionElement
implements ExtensionElement {
    private final String name;
    private final String namespace;
    private final Map<String, String> attributes;
    private final String text;
    private final MultiMap<QName, StandardExtensionElement> elements;
    private XmlStringBuilder xmlCache;

    public StandardExtensionElement(String string, String string2) {
        this(string, string2, null, null, null);
    }

    private StandardExtensionElement(String string, String string2, Map<String, String> map, String string3, MultiMap<QName, StandardExtensionElement> multiMap) {
        this.name = StringUtils.requireNotNullNorEmpty(string, "Name must not be null nor empty");
        this.namespace = StringUtils.requireNotNullNorEmpty(string2, "Namespace must not be null nor empty");
        this.attributes = map == null ? Collections.emptyMap() : map;
        this.text = string3;
        this.elements = multiMap;
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public String getAttributeValue(String string) {
        return this.attributes.get(string);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public StandardExtensionElement getFirstElement(String string, String string2) {
        if (this.elements == null) {
            return null;
        }
        QName qName = new QName(string2, string);
        return this.elements.getFirst(qName);
    }

    public StandardExtensionElement getFirstElement(String string) {
        return this.getFirstElement(string, this.namespace);
    }

    public List<StandardExtensionElement> getElements(String string, String string2) {
        if (this.elements == null) {
            return null;
        }
        QName qName = new QName(string2, string);
        return this.elements.getAll(qName);
    }

    public List<StandardExtensionElement> getElements(String string) {
        return this.getElements(string, this.namespace);
    }

    public List<StandardExtensionElement> getElements() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.values();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        if (this.xmlCache != null) {
            return this.xmlCache;
        }
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this, xmlEnvironment);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            xmlStringBuilder.attribute(entry.getKey(), entry.getValue());
        }
        xmlStringBuilder.rightAngleBracket();
        if (this.text != null) {
            xmlStringBuilder.text(this.text);
        }
        if (this.elements != null) {
            for (Map.Entry<Object, Object> entry : this.elements.entrySet()) {
                xmlStringBuilder.append(((StandardExtensionElement)entry.getValue()).toXML(this.getNamespace()));
            }
        }
        xmlStringBuilder.closeElement(this);
        this.xmlCache = xmlStringBuilder;
        return xmlStringBuilder;
    }

    public static Builder builder(String string, String string2) {
        return new Builder(string, string2);
    }

    public static final class Builder {
        private final String name;
        private final String namespace;
        private Map<String, String> attributes;
        private String text;
        private MultiMap<QName, StandardExtensionElement> elements;

        private Builder(String string, String string2) {
            this.name = string;
            this.namespace = string2;
        }

        public Builder addAttribute(String string, String string2) {
            StringUtils.requireNotNullNorEmpty(string, "Attribute name must be set");
            Objects.requireNonNull(string2, "Attribute value must be not null");
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            this.attributes.put(string, string2);
            return this;
        }

        public Builder addAttributes(Map<String, String> map) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>(map.size());
            }
            this.attributes.putAll(map);
            return this;
        }

        public Builder setText(String string) {
            this.text = Objects.requireNonNull(string, "Text must be not null");
            return this;
        }

        public Builder addElement(StandardExtensionElement standardExtensionElement) {
            Objects.requireNonNull(standardExtensionElement, "Element must not be null");
            if (this.elements == null) {
                this.elements = new MultiMap();
            }
            QName qName = standardExtensionElement.getQName();
            this.elements.put(qName, standardExtensionElement);
            return this;
        }

        public Builder addElement(String string, String string2) {
            StandardExtensionElement standardExtensionElement = StandardExtensionElement.builder(string, this.namespace).setText(string2).build();
            return this.addElement(standardExtensionElement);
        }

        public StandardExtensionElement build() {
            return new StandardExtensionElement(this.name, this.namespace, this.attributes, this.text, this.elements);
        }
    }
}

