/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.AbstractProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public class ProviderFileLoader
implements ProviderLoader {
    private static final Logger LOGGER = Logger.getLogger(ProviderFileLoader.class.getName());
    private final Collection<IQProviderInfo> iqProviders = new LinkedList<IQProviderInfo>();
    private final Collection<ExtensionProviderInfo> extProviders = new LinkedList<ExtensionProviderInfo>();
    private final Collection<StreamFeatureProviderInfo> sfProviders = new LinkedList<StreamFeatureProviderInfo>();
    private List<Exception> exceptions = new LinkedList<Exception>();

    public ProviderFileLoader(InputStream inputStream) {
        this(inputStream, ProviderFileLoader.class.getClassLoader());
    }

    public ProviderFileLoader(InputStream inputStream, ClassLoader classLoader) {
        try (InputStream inputStream2 = inputStream;){
            XmlPullParser xmlPullParser = PacketParserUtils.getParserFor(inputStream2);
            XmlPullParser.Event event = xmlPullParser.getEventType();
            do {
                if (event != XmlPullParser.Event.START_ELEMENT) continue;
                String string = xmlPullParser.getName();
                try {
                    if ("smackProviders".equals(string)) continue;
                    xmlPullParser.next();
                    xmlPullParser.next();
                    String string2 = xmlPullParser.nextText();
                    xmlPullParser.next();
                    xmlPullParser.next();
                    String string3 = xmlPullParser.nextText();
                    xmlPullParser.next();
                    xmlPullParser.next();
                    String string4 = xmlPullParser.nextText();
                    try {
                        Class<?> clazz = classLoader.loadClass(string4);
                        switch (string) {
                            case "iqProvider": {
                                AbstractProvider abstractProvider;
                                if (IqProvider.class.isAssignableFrom(clazz)) {
                                    abstractProvider = (IqProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    this.iqProviders.add(new IQProviderInfo(string2, string3, (IqProvider<IQ>)abstractProvider));
                                    break;
                                }
                                this.exceptions.add(new IllegalArgumentException(string4 + " is not a IQProvider"));
                                break;
                            }
                            case "extensionProvider": {
                                AbstractProvider abstractProvider;
                                if (ExtensionElementProvider.class.isAssignableFrom(clazz)) {
                                    abstractProvider = (ExtensionElementProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    this.extProviders.add(new ExtensionProviderInfo(string2, string3, (ExtensionElementProvider<ExtensionElement>)abstractProvider));
                                    break;
                                }
                                this.exceptions.add(new IllegalArgumentException(string4 + " is not a PacketExtensionProvider"));
                                break;
                            }
                            case "streamFeatureProvider": {
                                AbstractProvider abstractProvider = (ExtensionElementProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                                this.sfProviders.add(new StreamFeatureProviderInfo(string2, string3, (ExtensionElementProvider<ExtensionElement>)abstractProvider));
                                break;
                            }
                            default: {
                                LOGGER.warning("Unknown provider type: " + string);
                                break;
                            }
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOGGER.log(Level.SEVERE, "Could not find provider class", classNotFoundException);
                        this.exceptions.add(classNotFoundException);
                    }
                    catch (InstantiationException instantiationException) {
                        LOGGER.log(Level.SEVERE, "Could not instanciate " + string4, instantiationException);
                        this.exceptions.add(instantiationException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.SEVERE, "Invalid provider type found [" + string + "] when expecting iqProvider or extensionProvider", illegalArgumentException);
                    this.exceptions.add(illegalArgumentException);
                }
            } while ((event = xmlPullParser.next()) != XmlPullParser.Event.END_DOCUMENT);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Unknown error occurred while parsing provider file", exception);
            this.exceptions.add(exception);
        }
    }

    @Override
    public Collection<IQProviderInfo> getIQProviderInfo() {
        return this.iqProviders;
    }

    @Override
    public Collection<ExtensionProviderInfo> getExtensionProviderInfo() {
        return this.extProviders;
    }

    @Override
    public Collection<StreamFeatureProviderInfo> getStreamFeatureProviderInfo() {
        return this.sfProviders;
    }

    public List<Exception> getLoadingExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

