/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.core;

import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.core.ScramHmac;
import org.jivesoftware.smack.sasl.core.ScramMechanism;
import org.jivesoftware.smack.util.MAC;

public class SCRAMSHA1Mechanism
extends ScramMechanism {
    static final int PRIORITY = 110;
    public static final String NAME;
    static final ScramHmac SHA_1_SCRAM_HMAC;

    public SCRAMSHA1Mechanism() {
        super(SHA_1_SCRAM_HMAC);
    }

    @Override
    public int getPriority() {
        return 110;
    }

    @Override
    protected SASLMechanism newInstance() {
        return new SCRAMSHA1Mechanism();
    }

    static {
        SHA_1_SCRAM_HMAC = new ScramHmac(){

            @Override
            public String getHmacName() {
                return "SHA-1";
            }

            @Override
            public byte[] hmac(byte[] byArray, byte[] byArray2) {
                return MAC.hmacsha1(byArray, byArray2);
            }
        };
        NAME = new SCRAMSHA1Mechanism().getName();
    }
}

