/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

public final class EqualsUtil {
    private EqualsUtil() {
    }

    public static <T> boolean equals(T t, Object object, EqualsComperator<T> equalsComperator) {
        int n;
        if (object == null) {
            return false;
        }
        if (t == object) {
            return true;
        }
        Class<?> clazz = t.getClass();
        if (clazz != object.getClass()) {
            return false;
        }
        int n2 = t.hashCode();
        if (n2 != (n = object.hashCode())) {
            return false;
        }
        Builder builder = new Builder();
        equalsComperator.compare(builder, clazz.cast(object));
        return builder.isEquals;
    }

    public static final class Builder {
        private boolean isEquals = true;

        private Builder() {
        }

        private void nullSafeCompare(Object object, Object object2, Runnable runnable) {
            if (!this.isEquals) {
                return;
            }
            if (object == object2) {
                return;
            }
            if (object == null || object2 == null) {
                this.isEquals = false;
                return;
            }
            runnable.run();
        }

        public <O> Builder append(O o, O o2) {
            if (!this.isEquals) {
                return this;
            }
            if (o == o2) {
                return this;
            }
            if (o == null || o2 == null) {
                this.isEquals = false;
                return this;
            }
            this.isEquals = o.equals(o2);
            return this;
        }

        public Builder append(boolean bl, boolean bl2) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = bl == bl2;
            return this;
        }

        public Builder append(boolean[] blArray, boolean[] blArray2) {
            this.nullSafeCompare(blArray, blArray2, () -> {
                if (blArray.length != blArray2.length) {
                    this.isEquals = false;
                    return;
                }
                for (int k = 0; k < blArray.length && this.isEquals; ++k) {
                    this.append(blArray[k], blArray2[k]);
                }
            });
            return this;
        }

        public Builder append(byte by, byte by2) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = by == by2;
            return this;
        }

        public Builder append(byte[] byArray, byte[] byArray2) {
            this.nullSafeCompare(byArray, byArray2, () -> {
                if (byArray.length != byArray2.length) {
                    this.isEquals = false;
                    return;
                }
                for (int k = 0; k < byArray.length && this.isEquals; ++k) {
                    this.append(byArray[k], byArray2[k]);
                }
            });
            return this;
        }

        public Builder append(char c2, char c3) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = c2 == c3;
            return this;
        }

        public Builder append(char[] cArray, char[] cArray2) {
            this.nullSafeCompare(cArray, cArray2, () -> {
                if (cArray.length != cArray2.length) {
                    this.isEquals = false;
                    return;
                }
                for (int k = 0; k < cArray.length && this.isEquals; ++k) {
                    this.append(cArray[k], cArray2[k]);
                }
            });
            return this;
        }

        public Builder append(double d2, double d3) {
            if (!this.isEquals) {
                return this;
            }
            return this.append(Double.doubleToLongBits(d2), Double.doubleToLongBits(d3));
        }

        public Builder append(double[] dArray, double[] dArray2) {
            this.nullSafeCompare(dArray, dArray2, () -> {
                if (dArray.length != dArray2.length) {
                    this.isEquals = false;
                    return;
                }
                for (int k = 0; k < dArray.length && this.isEquals; ++k) {
                    this.append(dArray[k], dArray2[k]);
                }
            });
            return this;
        }

        public Builder append(float f2, float f3) {
            if (!this.isEquals) {
                return this;
            }
            return this.append(Float.floatToIntBits(f2), Float.floatToIntBits(f3));
        }

        public Builder append(float[] fArray, float[] fArray2) {
            this.nullSafeCompare(fArray, fArray2, () -> {
                if (fArray.length != fArray2.length) {
                    this.isEquals = false;
                    return;
                }
                for (int k = 0; k < fArray.length && this.isEquals; ++k) {
                    this.append(fArray[k], fArray2[k]);
                }
            });
            return this;
        }

        public Builder append(int n, int n2) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = n == n2;
            return this;
        }

        public Builder append(int[] nArray, int[] nArray2) {
            this.nullSafeCompare(nArray, nArray2, () -> {
                if (nArray.length != nArray2.length) {
                    this.isEquals = false;
                    return;
                }
                for (int k = 0; k < nArray.length && this.isEquals; ++k) {
                    this.append(nArray[k], nArray2[k]);
                }
            });
            return this;
        }

        public Builder append(long l, long l2) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = l == l2;
            return this;
        }

        public Builder append(long[] lArray, long[] lArray2) {
            this.nullSafeCompare(lArray, lArray2, () -> {
                if (lArray.length != lArray2.length) {
                    this.isEquals = false;
                    return;
                }
                for (int k = 0; k < lArray.length && this.isEquals; ++k) {
                    this.append(lArray[k], lArray2[k]);
                }
            });
            return this;
        }
    }

    @FunctionalInterface
    public static interface EqualsComperator<T> {
        public void compare(Builder var1, T var2);
    }
}

