/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Consumer;

public class MultiMap<K, V> {
    public static final int DEFAULT_MAP_SIZE = 6;
    private static final int ENTRY_LIST_SIZE = 3;
    private final Map<K, List<V>> map;

    public MultiMap() {
        this(6);
    }

    public MultiMap(int n) {
        this(new LinkedHashMap(n));
    }

    private MultiMap(Map<K, List<V>> map) {
        this.map = map;
    }

    public int size() {
        int n = 0;
        for (List<V> list : this.map.values()) {
            n += list.size();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(V v) {
        for (List<V> list : this.map.values()) {
            if (!list.contains(v)) continue;
            return true;
        }
        return false;
    }

    public V getFirst(K k) {
        List<V> list = this.getAll(k);
        if (list.isEmpty()) {
            return null;
        }
        return list.iterator().next();
    }

    public List<V> getAll(K k) {
        List<Object> list = this.map.get(k);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public boolean put(K k, V v) {
        return this.putInternal(k, list -> list.add(v));
    }

    public boolean putFirst(K k, V v) {
        return this.putInternal(k, list -> list.add(0, v));
    }

    private boolean putInternal(K k, Consumer<List<V>> consumer) {
        boolean bl;
        List<V> list = this.map.get(k);
        if (list == null) {
            list = new ArrayList<V>(3);
            this.map.put(k, list);
            bl = false;
        } else {
            bl = true;
        }
        consumer.accept(list);
        return bl;
    }

    public V remove(K k) {
        List<V> list = this.map.remove(k);
        if (list == null) {
            return null;
        }
        assert (!list.isEmpty());
        return list.iterator().next();
    }

    public boolean removeOne(K k, V v) {
        List<V> list = this.map.get(k);
        if (list == null) {
            return false;
        }
        boolean bl = list.remove(v);
        if (list.isEmpty()) {
            this.map.remove(k);
        }
        return bl;
    }

    public List<V> remove(K k, int n) {
        List<V> list = this.map.get(k);
        if (list == null) {
            return Collections.emptyList();
        }
        int n2 = list.size() > n ? n : list.size();
        ArrayList<V> arrayList = new ArrayList<V>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(list.get(0));
        }
        if (list.isEmpty()) {
            this.map.remove(k);
        }
        return arrayList;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        ArrayList<V> arrayList = new ArrayList<V>(this.size());
        for (List<V> list : this.map.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>(this.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K k = entry.getKey();
            for (V v : entry.getValue()) {
                linkedHashSet.add(new SimpleMapEntry(k, v));
            }
        }
        return linkedHashSet;
    }

    public MultiMap<K, V> asUnmodifiableMultiMap() {
        LinkedHashMap<K, List<V>> linkedHashMap = new LinkedHashMap<K, List<V>>(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K k = entry.getKey();
            List<V> list = entry.getValue();
            linkedHashMap.put(k, Collections.unmodifiableList(list));
        }
        return new MultiMap(Collections.unmodifiableMap(linkedHashMap));
    }

    public MultiMap<K, V> clone() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            ArrayList arrayList = CollectionUtil.newListWith((Collection)entry.getValue());
            linkedHashMap.put(entry.getKey(), arrayList);
        }
        return new MultiMap(linkedHashMap);
    }

    private static final class SimpleMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private SimpleMapEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }
    }
}

