/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.e.c.a.c;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.MultiMap;

public class XmppElementUtil {
    private static final c<Class<? extends FullyQualifiedElement>, QName> CLASS_TO_QNAME_CACHE = new c(512);
    public static final Logger LOGGER = Logger.getLogger(XmppElementUtil.class.getName());

    public static QName getQNameFor(Class<? extends FullyQualifiedElement> clazz) {
        String string;
        Object object;
        QName qName = (QName)CLASS_TO_QNAME_CACHE.get(clazz);
        if (qName != null) {
            return qName;
        }
        try {
            object = clazz.getField("QNAME").get(null);
            if (QName.class.isAssignableFrom(object.getClass())) {
                qName = (QName)object;
                CLASS_TO_QNAME_CACHE.put(clazz, (Object)qName);
                return qName;
            }
            LOGGER.warning("The QNAME field of " + clazz + " is not of type QNAME.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.finer("The " + clazz + " has no static QNAME field. Consider adding one.");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
            throw new IllegalArgumentException(exception);
        }
        try {
            object = (String)clazz.getField("ELEMENT").get(null);
            string = (String)clazz.getField("NAMESPACE").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            throw new IllegalArgumentException("The " + clazz + " has no ELEMENT, NAMESPACE or QNAME member. Consider adding QNAME", exception);
        }
        qName = new QName(string, (String)object);
        CLASS_TO_QNAME_CACHE.put(clazz, (Object)qName);
        return qName;
    }

    public static <E extends ExtensionElement> List<E> getElementsFrom(MultiMap<QName, ExtensionElement> multiMap, Class<E> clazz) {
        QName qName = XmppElementUtil.getQNameFor(clazz);
        List<ExtensionElement> list = multiMap.getAll(qName);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<E> arrayList = new ArrayList<E>(list.size());
        for (ExtensionElement extensionElement : list) {
            E e2 = XmppElementUtil.castOrThrow(extensionElement, clazz);
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static <E extends ExtensionElement> E castOrThrow(ExtensionElement extensionElement, Class<E> clazz) {
        if (!clazz.isInstance(extensionElement)) {
            Object object;
            String string;
            QName qName = XmppElementUtil.getQNameFor(clazz);
            if (extensionElement instanceof StandardExtensionElement) {
                string = "because there is no according extension element provider registered with ProviderManager for " + qName + ". WARNING: This indicates a serious problem with your Smack setup, probably causing Smack not being able to properly initialize itself.";
            } else {
                object = ProviderManager.getExtensionProvider(qName);
                string = "because there is an inconsistency with the provider registered with ProviderManager: the active provider for " + qName + " '" + object.getClass() + "' does not return instances of type " + clazz + ", but instead returns instances of type " + extensionElement.getClass() + ".";
            }
            object = "Extension element is not of expected class '" + clazz.getName() + "', " + string;
            throw new IllegalStateException((String)object);
        }
        return (E)((ExtensionElement)clazz.cast(extensionElement));
    }
}

