/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.WindowInsets;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/foundation/layout/ExcludeInsets;", "Landroidx/compose/foundation/layout/WindowInsets;", "included", "excluded", "<init>", "(Landroidx/compose/foundation/layout/WindowInsets;Landroidx/compose/foundation/layout/WindowInsets;)V", "getLeft", "", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getTop", "getRight", "getBottom", "toString", "", "equals", "", "other", "", "hashCode", "foundation-layout"})
final class ExcludeInsets
implements WindowInsets {
    private final WindowInsets included;
    private final WindowInsets excluded;

    public ExcludeInsets(WindowInsets windowInsets, WindowInsets windowInsets2) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"");
        Intrinsics.checkNotNullParameter((Object)windowInsets2, (String)"");
        this.included = windowInsets;
        this.excluded = windowInsets2;
    }

    @Override
    public int getLeft(Density density, LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        return RangesKt.coerceAtLeast((int)(this.included.getLeft(density, layoutDirection) - this.excluded.getLeft(density, layoutDirection)), (int)0);
    }

    @Override
    public int getTop(Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        return RangesKt.coerceAtLeast((int)(this.included.getTop(density) - this.excluded.getTop(density)), (int)0);
    }

    @Override
    public int getRight(Density density, LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        return RangesKt.coerceAtLeast((int)(this.included.getRight(density, layoutDirection) - this.excluded.getRight(density, layoutDirection)), (int)0);
    }

    @Override
    public int getBottom(Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        return RangesKt.coerceAtLeast((int)(this.included.getBottom(density) - this.excluded.getBottom(density)), (int)0);
    }

    public String toString() {
        return "(" + this.included + " - " + this.excluded + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExcludeInsets)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((ExcludeInsets)object).included, (Object)this.included) && Intrinsics.areEqual((Object)((ExcludeInsets)object).excluded, (Object)this.excluded);
    }

    public int hashCode() {
        return 31 * this.included.hashCode() + this.excluded.hashCode();
    }
}

