/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.BrotliEncoderChannel;
import com.aayushatharva.brotli4j.encoder.Encoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.handler.codec.compression.EncoderUtil;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;

@ChannelHandler.Sharable
public final class BrotliEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final AttributeKey<Writer> ATTR = AttributeKey.valueOf((String)"BrotliEncoderWriter");
    private final Encoder.Parameters parameters;
    private final boolean isSharable;
    private Writer writer;

    public BrotliEncoder() {
        this(BrotliOptions.DEFAULT);
    }

    public BrotliEncoder(BrotliOptions brotliOptions) {
        this(brotliOptions.parameters());
    }

    public BrotliEncoder(Encoder.Parameters parameters) {
        this(parameters, true);
    }

    public BrotliEncoder(Encoder.Parameters parameters, boolean bl) {
        this.parameters = (Encoder.Parameters)ObjectUtil.checkNotNull((Object)parameters, (String)"Parameters");
        this.isSharable = bl;
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        Writer writer = new Writer(this.parameters, channelHandlerContext);
        if (this.isSharable) {
            channelHandlerContext.channel().attr(ATTR).set((Object)writer);
        } else {
            this.writer = writer;
        }
        super.handlerAdded(channelHandlerContext);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.finish(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl) {
        if (!byteBuf.isReadable()) {
            return Unpooled.EMPTY_BUFFER;
        }
        Writer writer = this.isSharable ? (Writer)channelHandlerContext.channel().attr(ATTR).get() : this.writer;
        if (writer == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        writer.encode(byteBuf, bl);
        return writer.writableBuffer;
    }

    public boolean isSharable() {
        return this.isSharable;
    }

    public void finish(ChannelHandlerContext channelHandlerContext) {
        this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        Writer writer = this.isSharable ? (Writer)channelHandlerContext.channel().attr(ATTR).getAndSet(null) : this.writer;
        if (writer != null) {
            writer.close();
            this.writer = null;
        }
        return channelPromise;
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        EncoderUtil.closeAfterFinishEncode(channelHandlerContext, channelFuture, channelPromise);
    }

    private static final class Writer
    implements WritableByteChannel {
        private ByteBuf writableBuffer;
        private final BrotliEncoderChannel brotliEncoderChannel;
        private final ChannelHandlerContext ctx;
        private boolean isClosed;

        private Writer(Encoder.Parameters parameters, ChannelHandlerContext channelHandlerContext) {
            this.brotliEncoderChannel = new BrotliEncoderChannel((WritableByteChannel)this, parameters);
            this.ctx = channelHandlerContext;
        }

        private void encode(ByteBuf byteBuf, boolean bl) {
            try {
                this.allocate(bl);
                ByteBuffer byteBuffer = CompressionUtil.safeReadableNioBuffer(byteBuf);
                int n = byteBuffer.position();
                this.brotliEncoderChannel.write(byteBuffer);
                byteBuf.skipBytes(byteBuffer.position() - n);
                this.brotliEncoderChannel.flush();
            }
            catch (Exception exception) {
                ReferenceCountUtil.release((Object)byteBuf);
                throw exception;
            }
        }

        private void allocate(boolean bl) {
            this.writableBuffer = bl ? this.ctx.alloc().ioBuffer() : this.ctx.alloc().buffer();
        }

        @Override
        public int write(ByteBuffer byteBuffer) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.writableBuffer.writeBytes(byteBuffer).readableBytes();
        }

        @Override
        public boolean isOpen() {
            return !this.isClosed;
        }

        @Override
        public void close() {
            final ChannelPromise channelPromise = this.ctx.newPromise();
            this.ctx.executor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Writer.this.finish(channelPromise);
                    }
                    catch (IOException iOException) {
                        channelPromise.setFailure((Throwable)new IllegalStateException("Failed to finish encoding", iOException));
                    }
                }
            });
        }

        public void finish(ChannelPromise channelPromise) {
            if (!this.isClosed) {
                this.allocate(true);
                try {
                    this.brotliEncoderChannel.close();
                    this.isClosed = true;
                }
                catch (Exception exception) {
                    channelPromise.setFailure((Throwable)exception);
                    ReferenceCountUtil.release((Object)this.writableBuffer);
                    return;
                }
                this.ctx.writeAndFlush((Object)this.writableBuffer, channelPromise);
            }
        }
    }
}

