/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.util.internal.ObjectUtil;

public abstract class ZlibDecoder
extends ByteToMessageDecoder {
    protected final int maxAllocation;

    public ZlibDecoder() {
        this(0);
    }

    public ZlibDecoder(int n) {
        this.maxAllocation = ObjectUtil.checkPositiveOrZero((int)n, (String)"maxAllocation");
    }

    public abstract boolean isClosed();

    protected ByteBuf prepareDecompressBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n) {
        if (byteBuf == null) {
            if (this.maxAllocation == 0) {
                return channelHandlerContext.alloc().heapBuffer(n);
            }
            return channelHandlerContext.alloc().heapBuffer(Math.min(n, this.maxAllocation), this.maxAllocation);
        }
        if (byteBuf.ensureWritable(n, true) == 1) {
            this.decompressionBufferExhausted(byteBuf.duplicate());
            byteBuf.skipBytes(byteBuf.readableBytes());
            throw new DecompressionException("Decompression buffer has reached maximum size: " + byteBuf.maxCapacity());
        }
        return byteBuf;
    }

    protected void decompressionBufferExhausted(ByteBuf byteBuf) {
    }
}

