/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.io.path.LinkFollowing;
import kotlin.io.path.PathNode;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlin/io/path/DirectoryEntriesReader;", "Ljava/nio/file/SimpleFileVisitor;", "Ljava/nio/file/Path;", "followLinks", "", "<init>", "(Z)V", "getFollowLinks", "()Z", "directoryNode", "Lkotlin/io/path/PathNode;", "entries", "Lkotlin/collections/ArrayDeque;", "readEntries", "", "preVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "visitFile", "file", "kotlin-stdlib-jdk7"})
final class DirectoryEntriesReader
extends SimpleFileVisitor<Path> {
    private final boolean followLinks;
    private PathNode directoryNode;
    private ArrayDeque<PathNode> entries;

    public DirectoryEntriesReader(boolean bl) {
        this.followLinks = bl;
        this.entries = new ArrayDeque();
    }

    public final boolean getFollowLinks() {
        return this.followLinks;
    }

    public final List<PathNode> readEntries(PathNode pathNode) {
        ArrayDeque<PathNode> arrayDeque;
        Intrinsics.checkNotNullParameter(pathNode, "");
        this.directoryNode = pathNode;
        Files.walkFileTree(pathNode.getPath(), LinkFollowing.INSTANCE.toVisitOptions(this.followLinks), 1, this);
        this.entries.removeFirst();
        ArrayDeque<PathNode> arrayDeque2 = arrayDeque = this.entries;
        boolean bl = false;
        this.entries = new ArrayDeque();
        return arrayDeque;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(basicFileAttributes, "");
        PathNode pathNode = new PathNode(path, basicFileAttributes.fileKey(), this.directoryNode);
        this.entries.add(pathNode);
        FileVisitResult fileVisitResult = super.preVisitDirectory(path, basicFileAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)fileVisitResult, "");
        return fileVisitResult;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(basicFileAttributes, "");
        PathNode pathNode = new PathNode(path, null, this.directoryNode);
        this.entries.add(pathNode);
        FileVisitResult fileVisitResult = super.visitFile(path, basicFileAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)fileVisitResult, "");
        return fileVisitResult;
    }
}

