/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;
import kotlin.time.LongSaturatedMathKt;
import kotlin.time.TimeSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0012B\u0011\bF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u00a4\u0080\u0004J\n\u0010\u000f\u001a\u00020\tH\u0082\u0080\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u0015\u0010\u0002\u001a\u00020\u0003X\u0084\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\t8BX\u0082\u0084\n\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lkotlin/time/AbstractLongTimeSource;", "Lkotlin/time/TimeSource$WithComparableMarks;", "unit", "Lkotlin/time/DurationUnit;", "<init>", "(Lkotlin/time/DurationUnit;)V", "getUnit", "()Lkotlin/time/DurationUnit;", "read", "", "zero", "getZero", "()J", "zero$delegate", "Lkotlin/Lazy;", "adjustedRead", "markNow", "Lkotlin/time/ComparableTimeMark;", "LongTimeMark", "kotlin-stdlib"})
public abstract class AbstractLongTimeSource
implements TimeSource.WithComparableMarks {
    private final DurationUnit unit;
    private final Lazy zero$delegate;

    public AbstractLongTimeSource(DurationUnit durationUnit) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        this.unit = durationUnit;
        this.zero$delegate = LazyKt.lazy(() -> AbstractLongTimeSource.zero_delegate$lambda$0(this));
    }

    protected final DurationUnit getUnit() {
        return this.unit;
    }

    protected abstract long read();

    private final long getZero() {
        Lazy lazy = this.zero$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    private final long adjustedRead() {
        return this.read() - this.getZero();
    }

    @Override
    public ComparableTimeMark markNow() {
        return new LongTimeMark(this.adjustedRead(), this, Duration.Companion.getZERO-UwyO8pc(), null);
    }

    private static final long zero_delegate$lambda$0(AbstractLongTimeSource abstractLongTimeSource) {
        return abstractLongTimeSource.read();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\bF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000b\u001a\u00020\u0007H\u0096\u0080\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0096\u0082\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0001H\u0096\u0082\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0018H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u0096\u0080\u0004R\u000f\u0010\u0002\u001a\u00020\u0003X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0004\u001a\u00020\u0005X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007X\u0082\u0084\b\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001d"}, d2={"Lkotlin/time/AbstractLongTimeSource$LongTimeMark;", "Lkotlin/time/ComparableTimeMark;", "startedAt", "", "timeSource", "Lkotlin/time/AbstractLongTimeSource;", "offset", "Lkotlin/time/Duration;", "<init>", "(JLkotlin/time/AbstractLongTimeSource;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "elapsedNow", "elapsedNow-UwyO8pc", "()J", "plus", "duration", "plus-LRDsOJo", "(J)Lkotlin/time/ComparableTimeMark;", "minus", "other", "minus-UwyO8pc", "(Lkotlin/time/ComparableTimeMark;)J", "equals", "", "", "hashCode", "", "toString", "", "kotlin-stdlib"})
    private static final class LongTimeMark
    implements ComparableTimeMark {
        private final long startedAt;
        private final AbstractLongTimeSource timeSource;
        private final long offset;

        private LongTimeMark(long l, AbstractLongTimeSource abstractLongTimeSource, long l2) {
            Intrinsics.checkNotNullParameter(abstractLongTimeSource, "");
            this.startedAt = l;
            this.timeSource = abstractLongTimeSource;
            this.offset = l2;
        }

        @Override
        public long elapsedNow-UwyO8pc() {
            return Duration.minus-LRDsOJo(LongSaturatedMathKt.saturatingOriginsDiff(this.timeSource.adjustedRead(), this.startedAt, this.timeSource.getUnit()), this.offset);
        }

        @Override
        public ComparableTimeMark plus-LRDsOJo(long l) {
            long l2;
            DurationUnit durationUnit = this.timeSource.getUnit();
            if (Duration.isInfinite-impl(l)) {
                long l3 = LongSaturatedMathKt.saturatingAdd-NuflL3o(this.startedAt, durationUnit, l);
                return new LongTimeMark(l3, this.timeSource, Duration.Companion.getZERO-UwyO8pc(), null);
            }
            long l4 = Duration.truncateTo-UwyO8pc$kotlin_stdlib(l, durationUnit);
            long l5 = Duration.plus-LRDsOJo(Duration.minus-LRDsOJo(l, l4), this.offset);
            long l6 = LongSaturatedMathKt.saturatingAdd-NuflL3o(this.startedAt, durationUnit, l4);
            long l7 = Duration.truncateTo-UwyO8pc$kotlin_stdlib(l5, durationUnit);
            l6 = LongSaturatedMathKt.saturatingAdd-NuflL3o(l6, durationUnit, l7);
            long l8 = Duration.minus-LRDsOJo(l5, l7);
            long l9 = Duration.getInWholeNanoseconds-impl(l8);
            if (l6 != 0L && l9 != 0L && (l6 ^ l9) < 0L) {
                l2 = DurationKt.toDuration(MathKt.getSign(l9), durationUnit);
                l6 = LongSaturatedMathKt.saturatingAdd-NuflL3o(l6, durationUnit, l2);
                l8 = Duration.minus-LRDsOJo(l8, l2);
            }
            long l10 = l2 = l6;
            boolean bl = false;
            long l11 = (l10 - 1L | 1L) == Long.MAX_VALUE ? Duration.Companion.getZERO-UwyO8pc() : l8;
            return new LongTimeMark(l2, this.timeSource, l11, null);
        }

        @Override
        public long minus-UwyO8pc(ComparableTimeMark comparableTimeMark) {
            Intrinsics.checkNotNullParameter(comparableTimeMark, "");
            if (!(comparableTimeMark instanceof LongTimeMark) || !Intrinsics.areEqual(this.timeSource, ((LongTimeMark)comparableTimeMark).timeSource)) {
                throw new IllegalArgumentException("Subtracting or comparing time marks from different time sources is not possible: " + this + " and " + comparableTimeMark);
            }
            long l = LongSaturatedMathKt.saturatingOriginsDiff(this.startedAt, ((LongTimeMark)comparableTimeMark).startedAt, this.timeSource.getUnit());
            return Duration.plus-LRDsOJo(l, Duration.minus-LRDsOJo(this.offset, ((LongTimeMark)comparableTimeMark).offset));
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof LongTimeMark && Intrinsics.areEqual(this.timeSource, ((LongTimeMark)object).timeSource) && Duration.equals-impl0(this.minus-UwyO8pc((ComparableTimeMark)object), Duration.Companion.getZERO-UwyO8pc());
        }

        @Override
        public int hashCode() {
            return Duration.hashCode-impl(this.offset) * 37 + Long.hashCode(this.startedAt);
        }

        public String toString() {
            return "LongTimeMark(" + this.startedAt + DurationUnitKt.shortName(this.timeSource.getUnit()) + " + " + Duration.toString-impl(this.offset) + ", " + this.timeSource + ')';
        }

        public /* synthetic */ LongTimeMark(long l, AbstractLongTimeSource abstractLongTimeSource, long l2, DefaultConstructorMarker defaultConstructorMarker) {
            this(l, abstractLongTimeSource, l2);
        }
    }
}

