/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.IgnorableReturnValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.uuid.SecureRandomHolder;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidSerialized;

@Metadata(mv={2, 3, 0}, k=5, xi=49, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0080\u0080\u0004\u001a\u0012\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0081\u0080\u0004\u001a\u0016\u0010\b\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0081\u0080\u0004\u001a.\u0010\f\u001a\u00020\u0001*\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0081\u0080\u0004\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0081\u0080\u0004\u001a\u0012\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u000e\u0010\u001a\u001a\u00020\u0007*\u00020\u001bH\u0087\u0088\u0004\u001a\u000e\u0010\u001c\u001a\u00020\u001b*\u00020\u0007H\u0087\u0088\u0004\u001a\u000e\u0010\u001d\u001a\u00020\u0007*\u00020\u001eH\u0087\u0080\u0004\u001a\u0016\u0010\u001d\u001a\u00020\u0007*\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0087\u0080\u0004\u001a\u0016\u0010\u001f\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0087\u0080\b\u001a\u001e\u0010\u001f\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0087\u0080\b\u001a\u000e\u0010 \u001a\u00020\t*\u00020\tH\u0080\u0088\u0004\u00a8\u0006!"}, d2={"secureRandomBytes", "", "destination", "", "serializedUuid", "", "uuid", "Lkotlin/uuid/Uuid;", "getLongAt", "", "index", "", "formatBytesInto", "dst", "dstOffset", "startIndex", "endIndex", "setLongAt", "value", "uuidParseHexDash", "hexDashString", "", "uuidParseHexDashOrNull", "uuidParseHex", "hexString", "uuidParseHexOrNull", "toKotlinUuid", "Ljava/util/UUID;", "toJavaUuid", "getUuid", "Ljava/nio/ByteBuffer;", "putUuid", "reverseBytes", "kotlin-stdlib"}, xs="kotlin/uuid/UuidKt")
class UuidKt__UuidJVMKt {
    public static final void secureRandomBytes(byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "");
        SecureRandomHolder.INSTANCE.getInstance().nextBytes(byArray);
    }

    public static final Object serializedUuid(Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "");
        return new UuidSerialized(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static final long getLongAt(byte[] byArray, int n) {
        Intrinsics.checkNotNullParameter(byArray, "");
        return UuidKt.getLongAtCommonImpl(byArray, n);
    }

    public static final void formatBytesInto(long l, byte[] byArray, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        UuidKt.formatBytesIntoCommonImpl(l, byArray, n, n2, n3);
    }

    public static final void setLongAt(byte[] byArray, int n, long l) {
        Intrinsics.checkNotNullParameter(byArray, "");
        UuidKt.setLongAtCommonImpl(byArray, n, l);
    }

    public static final Uuid uuidParseHexDash(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return UuidKt.uuidParseHexDashCommonImpl(string);
    }

    public static final Uuid uuidParseHexDashOrNull(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return UuidKt.uuidParseHexDashOrNullCommonImpl(string);
    }

    public static final Uuid uuidParseHex(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return UuidKt.uuidParseHexCommonImpl(string);
    }

    public static final Uuid uuidParseHexOrNull(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return UuidKt.uuidParseHexOrNullCommonImpl(string);
    }

    public static final Uuid toKotlinUuid(UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "");
        boolean bl = false;
        return Uuid.Companion.fromLongs(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    public static final UUID toJavaUuid(Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "");
        boolean bl = false;
        Uuid uuid2 = uuid;
        long l = uuid2.getLeastSignificantBits();
        long l2 = uuid2.getMostSignificantBits();
        boolean bl2 = false;
        return new UUID(l2, l);
    }

    public static final Uuid getUuid(ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        if (byteBuffer.position() + 15 >= byteBuffer.limit()) {
            throw new BufferUnderflowException();
        }
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l3 = l;
            boolean bl = false;
            l = Long.reverseBytes(l3);
            l3 = l2;
            bl = false;
            l2 = Long.reverseBytes(l3);
        }
        return Uuid.Companion.fromLongs(l, l2);
    }

    public static final Uuid getUuid(ByteBuffer byteBuffer, int n) {
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n);
        }
        if (n + 15 >= byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("Not enough bytes to read a uuid at index: " + n + ", with limit: " + byteBuffer.limit() + ' ');
        }
        long l = byteBuffer.getLong(n);
        long l2 = byteBuffer.getLong(n + 8);
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l3 = l;
            boolean bl = false;
            l = Long.reverseBytes(l3);
            l3 = l2;
            bl = false;
            l2 = Long.reverseBytes(l3);
        }
        return Uuid.Companion.fromLongs(l, l2);
    }

    @IgnorableReturnValue
    public static final ByteBuffer putUuid(ByteBuffer byteBuffer, Uuid uuid) {
        ByteBuffer byteBuffer2;
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        Intrinsics.checkNotNullParameter(uuid, "");
        Uuid uuid2 = uuid;
        long l = uuid2.getLeastSignificantBits();
        long l2 = uuid2.getMostSignificantBits();
        boolean bl = false;
        if (byteBuffer.position() + 15 >= byteBuffer.limit()) {
            throw new BufferOverflowException();
        }
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.BIG_ENDIAN)) {
            byteBuffer.putLong(l2);
            byteBuffer2 = byteBuffer.putLong(l);
        } else {
            long l3 = l2;
            boolean bl2 = false;
            byteBuffer.putLong(Long.reverseBytes(l3));
            l3 = l;
            bl2 = false;
            byteBuffer2 = byteBuffer.putLong(Long.reverseBytes(l3));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "");
        return byteBuffer2;
    }

    @IgnorableReturnValue
    public static final ByteBuffer putUuid(ByteBuffer byteBuffer, int n, Uuid uuid) {
        ByteBuffer byteBuffer2;
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        Intrinsics.checkNotNullParameter(uuid, "");
        Uuid uuid2 = uuid;
        long l = uuid2.getLeastSignificantBits();
        long l2 = uuid2.getMostSignificantBits();
        boolean bl = false;
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n);
        }
        if (n + 15 >= byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("Not enough capacity to write a uuid at index: " + n + ", with limit: " + byteBuffer.limit() + ' ');
        }
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.BIG_ENDIAN)) {
            byteBuffer.putLong(n, l2);
            byteBuffer2 = byteBuffer.putLong(n + 8, l);
        } else {
            long l3 = l2;
            boolean bl2 = false;
            byteBuffer.putLong(n, Long.reverseBytes(l3));
            l3 = l;
            bl2 = false;
            byteBuffer2 = byteBuffer.putLong(n + 8, Long.reverseBytes(l3));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "");
        return byteBuffer2;
    }

    public static final long reverseBytes(long l) {
        boolean bl = false;
        return Long.reverseBytes(l);
    }
}

