/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Clock;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\bB\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0087\u0080\u0004R\u000f\u0010\u0004\u001a\u00020\u0005X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0006\u001a\u00020\u0005X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0007\u001a\u00020\bX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\nX\u0082\u0084\b\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lkotlin/uuid/UuidV7Generator;", "", "<init>", "()V", "TIMESTAMP_BIAS_BITS", "", "VERSION_MASK", "OVERFLOW_MASK", "", "timestampAndCounter", "Lkotlin/concurrent/atomics/AtomicLong;", "Ljava/util/concurrent/atomic/AtomicLong;", "generate", "Lkotlin/uuid/Uuid;", "clock", "Lkotlin/time/Clock;", "kotlin-stdlib"})
final class UuidV7Generator {
    public static final UuidV7Generator INSTANCE = new UuidV7Generator();
    private static final int TIMESTAMP_BIAS_BITS = 16;
    private static final int VERSION_MASK = 28672;
    private static final long OVERFLOW_MASK = 32768L;
    private static final AtomicLong timestampAndCounter = new AtomicLong(0L);

    private UuidV7Generator() {
    }

    public final Uuid generate(Clock clock) {
        long l;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(clock, "");
        byte[] byArray2 = byArray = new byte[10];
        boolean bl = false;
        UuidKt.secureRandomBytes(byArray2);
        byte[] byArray3 = byArray;
        int n = (byArray3[8] & 7) << 8 | byArray3[9] & 0xFF | 0x7000;
        long l2 = 0L;
        while (true) {
            long l3;
            long l4;
            if ((l4 = (l = timestampAndCounter.get()) >>> 16) < (l3 = clock.now().toEpochMilliseconds())) {
                l2 = l3 << 16 | (long)n;
                if (!timestampAndCounter.compareAndSet(l, l2)) continue;
                break;
            }
            l2 = l + 1L;
            if ((l2 & 0x8000L) != 0L) {
                l2 = l4 + 1L << 16 | (long)n;
            }
            if (timestampAndCounter.compareAndSet(l, l2)) break;
        }
        byArray3[0] = (byte)((byte)(byArray3[0] & 0x3F) | 0xFFFFFF80);
        l = UuidKt.getLongAt(byArray3, 0);
        return Uuid.Companion.fromLongs(l2, l);
    }
}

