/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.sqlite.SQLiteCommitListener;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.SQLiteLimits;
import org.sqlite.SQLiteUpdateListener;
import org.sqlite.core.CoreDatabaseMetaData;
import org.sqlite.core.DB;
import org.sqlite.core.NativeDB;
import org.sqlite.jdbc4.JDBC4DatabaseMetaData;

public abstract class SQLiteConnection
implements Connection {
    private static final String RESOURCE_NAME_PREFIX = ":resource:";
    private final DB db;
    private CoreDatabaseMetaData meta = null;
    private final SQLiteConnectionConfig connectionConfig;
    private SQLiteConfig.TransactionMode currentTransactionMode;
    private boolean firstStatementExecuted = false;

    public SQLiteConnection(DB dB) {
        this.db = dB;
        this.connectionConfig = dB.getConfig().newConnectionConfig();
    }

    public SQLiteConnection(String string, String string2) {
        this(string, string2, new Properties());
    }

    public SQLiteConnection(String string, String string2, Properties properties) {
        DB dB = null;
        try {
            this.db = dB = SQLiteConnection.open(string, string2, properties);
            SQLiteConfig sQLiteConfig = this.db.getConfig();
            this.connectionConfig = this.db.getConfig().newConnectionConfig();
            sQLiteConfig.apply(this);
            this.currentTransactionMode = this.getDatabase().getConfig().getTransactionMode();
            this.firstStatementExecuted = false;
        }
        catch (Throwable throwable) {
            try {
                if (dB != null) {
                    dB.close();
                }
            }
            catch (Exception exception) {
                throwable.addSuppressed(exception);
            }
            throw throwable;
        }
    }

    public SQLiteConfig.TransactionMode getCurrentTransactionMode() {
        return this.currentTransactionMode;
    }

    public void setCurrentTransactionMode(SQLiteConfig.TransactionMode transactionMode) {
        this.currentTransactionMode = transactionMode;
    }

    public void setFirstStatementExecuted(boolean bl) {
        this.firstStatementExecuted = bl;
    }

    public boolean isFirstStatementExecuted() {
        return this.firstStatementExecuted;
    }

    public SQLiteConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public CoreDatabaseMetaData getSQLiteDatabaseMetaData() {
        this.checkOpen();
        if (this.meta == null) {
            this.meta = new JDBC4DatabaseMetaData(this);
        }
        return this.meta;
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return this.getSQLiteDatabaseMetaData();
    }

    public String getUrl() {
        return this.db.getUrl();
    }

    @Override
    public void setSchema(String string) {
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    protected void checkCursor(int n, int n2, int n3) {
        if (n != 1003) {
            throw new SQLException("SQLite only supports TYPE_FORWARD_ONLY cursors");
        }
        if (n2 != 1007) {
            throw new SQLException("SQLite only supports CONCUR_READ_ONLY cursors");
        }
        if (n3 != 2) {
            throw new SQLException("SQLite only supports closing cursors at commit");
        }
    }

    protected void setTransactionMode(SQLiteConfig.TransactionMode transactionMode) {
        this.connectionConfig.setTransactionMode(transactionMode);
    }

    @Override
    public int getTransactionIsolation() {
        return this.connectionConfig.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int n) {
        this.checkOpen();
        switch (n) {
            case 2: 
            case 4: 
            case 8: {
                this.getDatabase().exec("PRAGMA read_uncommitted = false;", this.getAutoCommit());
                break;
            }
            case 1: {
                this.getDatabase().exec("PRAGMA read_uncommitted = true;", this.getAutoCommit());
                break;
            }
            default: {
                throw new SQLException("Unsupported transaction isolation level: " + n + ". Must be one of TRANSACTION_READ_UNCOMMITTED, TRANSACTION_READ_COMMITTED, TRANSACTION_REPEATABLE_READ, or TRANSACTION_SERIALIZABLE in java.sql.Connection");
            }
        }
        this.connectionConfig.setTransactionIsolation(n);
    }

    private static DB open(String string, String string2, Properties properties) {
        Serializable serializable;
        Object object;
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        String string3 = SQLiteConnection.extractPragmasFromFilename(string, string2, properties2);
        SQLiteConfig sQLiteConfig = new SQLiteConfig(properties2);
        if (!(string3.isEmpty() || ":memory:".equals(string3) || string3.startsWith("file:") || string3.contains("mode=memory"))) {
            Object object2;
            if (string3.startsWith(RESOURCE_NAME_PREFIX)) {
                object = string3.substring(RESOURCE_NAME_PREFIX.length());
                object2 = Thread.currentThread().getContextClassLoader();
                serializable = ((ClassLoader)object2).getResource((String)object);
                if (serializable == null) {
                    try {
                        serializable = new URL((String)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SQLException(String.format("resource %s not found: %s", object, malformedURLException));
                    }
                }
                try {
                    string3 = SQLiteConnection.extractResource((URL)serializable).getAbsolutePath();
                }
                catch (IOException iOException) {
                    throw new SQLException(String.format("failed to load %s: %s", object, iOException));
                }
            }
            object = new File(string3).getAbsoluteFile();
            object2 = ((File)object).getParentFile();
            if (object2 != null && !((File)object2).exists()) {
                for (Object object3 = object2; object3 != null && !((File)object3).exists(); object3 = ((File)object3).getParentFile()) {
                    object2 = object3;
                }
                throw new SQLException("path to '" + string3 + "': '" + object2 + "' does not exist");
            }
            try {
                if (!((File)object).exists() && ((File)object).createNewFile()) {
                    ((File)object).delete();
                }
            }
            catch (Exception exception) {
                throw new SQLException("opening db: '" + string3 + "': " + exception.getMessage());
            }
            string3 = ((File)object).getAbsolutePath();
        }
        object = null;
        try {
            NativeDB.load();
            object = new NativeDB(string, string3, sQLiteConfig);
        }
        catch (Exception exception) {
            serializable = new SQLException("Error opening connection");
            serializable.initCause(exception);
            throw serializable;
        }
        ((DB)object).open(string3, sQLiteConfig.getOpenModeFlags());
        return object;
    }

    private static File extractResource(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            try {
                return new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException.getMessage());
            }
        }
        String string = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        String string2 = String.format("sqlite-jdbc-tmp-%s.db", UUID.randomUUID());
        File file = new File(string, string2);
        if (file.exists()) {
            long l;
            long l2 = uRL.openConnection().getLastModified();
            if (l2 < (l = file.lastModified())) {
                return file;
            }
            boolean bl = file.delete();
            if (!bl) {
                throw new IOException("failed to remove existing DB file: " + file.getAbsolutePath());
            }
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        try (InputStream inputStream = uRLConnection.getInputStream();){
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file2 = file;
            return file2;
        }
    }

    public DB getDatabase() {
        return this.db;
    }

    @Override
    public boolean getAutoCommit() {
        this.checkOpen();
        return this.connectionConfig.isAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean bl) {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit() == bl) {
            return;
        }
        this.connectionConfig.setAutoCommit(bl);
        if (this.getConnectionConfig().isAutoCommit()) {
            this.db.exec("commit;", bl);
            this.currentTransactionMode = null;
        } else {
            this.db.exec(this.transactionPrefix(), bl);
            this.currentTransactionMode = this.getConnectionConfig().getTransactionMode();
        }
    }

    public int getBusyTimeout() {
        return this.db.getConfig().getBusyTimeout();
    }

    public void setBusyTimeout(int n) {
        this.db.getConfig().setBusyTimeout(n);
        this.db.busy_timeout(n);
    }

    public void setLimit(SQLiteLimits sQLiteLimits, int n) {
        if (n >= 0) {
            this.db.limit(sQLiteLimits.getId(), n);
        }
    }

    public void getLimit(SQLiteLimits sQLiteLimits) {
        this.db.limit(sQLiteLimits.getId(), -1);
    }

    @Override
    public boolean isClosed() {
        return this.db.isClosed();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        if (this.meta != null) {
            this.meta.close();
        }
        this.db.close();
    }

    protected void checkOpen() {
        if (this.isClosed()) {
            throw new SQLException("database connection closed");
        }
    }

    public String libversion() {
        this.checkOpen();
        return this.db.libversion();
    }

    @Override
    public void commit() {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("commit;", this.getAutoCommit());
        this.db.exec(this.transactionPrefix(), this.getAutoCommit());
        this.firstStatementExecuted = false;
        this.setCurrentTransactionMode(this.getConnectionConfig().getTransactionMode());
    }

    @Override
    public void rollback() {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("rollback;", this.getAutoCommit());
        this.db.exec(this.transactionPrefix(), this.getAutoCommit());
        this.firstStatementExecuted = false;
        this.setCurrentTransactionMode(this.getConnectionConfig().getTransactionMode());
    }

    public void addUpdateListener(SQLiteUpdateListener sQLiteUpdateListener) {
        this.db.addUpdateListener(sQLiteUpdateListener);
    }

    public void removeUpdateListener(SQLiteUpdateListener sQLiteUpdateListener) {
        this.db.removeUpdateListener(sQLiteUpdateListener);
    }

    public void addCommitListener(SQLiteCommitListener sQLiteCommitListener) {
        this.db.addCommitListener(sQLiteCommitListener);
    }

    public void removeCommitListener(SQLiteCommitListener sQLiteCommitListener) {
        this.db.removeCommitListener(sQLiteCommitListener);
    }

    protected static String extractPragmasFromFilename(String string, String string2, Properties properties) {
        int n = string2.indexOf(63);
        if (n == -1) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2.substring(0, n));
        int n2 = 0;
        String[] stringArray = string2.substring(n + 1).split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[stringArray.length - 1 - i].trim();
            if (string3.isEmpty()) continue;
            String[] stringArray2 = string3.split("=");
            String string4 = stringArray2[0].trim().toLowerCase();
            if (SQLiteConfig.pragmaSet.contains(string4)) {
                if (stringArray2.length == 1) {
                    throw new SQLException(String.format("Please specify a value for PRAGMA %s in URL %s", string4, string));
                }
                String string5 = stringArray2[1].trim();
                if (string5.isEmpty() || properties.containsKey(string4)) continue;
                properties.setProperty(string4, string5);
                continue;
            }
            stringBuilder.append(n2 == 0 ? (char)'?' : '&');
            stringBuilder.append(string3);
            ++n2;
        }
        String string6 = stringBuilder.toString();
        return string6;
    }

    protected String transactionPrefix() {
        return this.connectionConfig.transactionPrefix();
    }

    public byte[] serialize(String string) {
        return this.db.serialize(string);
    }

    public void deserialize(String string, byte[] byArray) {
        this.db.deserialize(string, byArray);
    }
}

