/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTaskListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class ReconfigureOnChangeTask
extends ContextAwareBase
implements Runnable {
    public static final String DETECTED_CHANGE_IN_CONFIGURATION_FILES = "Detected change in configuration files.";
    static final String RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION = "Re-registering previous fallback configuration once more as a fallback configuration point";
    static final String FALLING_BACK_TO_SAFE_CONFIGURATION = "Given previous errors, falling back to previously registered safe configuration.";
    long birthdate = System.currentTimeMillis();
    List<ReconfigureOnChangeTaskListener> listeners = null;
    ScheduledFuture<?> scheduledFuture;

    @Override
    public void run() {
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRunningEvent((Object)this));
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        if (configurationWatchList == null) {
            this.addWarn("Empty ConfigurationWatchList in context");
            return;
        }
        List list = configurationWatchList.getCopyOfFileWatchList();
        if (list == null || list.isEmpty()) {
            this.addInfo("Empty watch file list. Disabling ");
            return;
        }
        if (!configurationWatchList.changeDetected()) {
            return;
        }
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectedEvent((Object)this));
        this.cancelFutureInvocationsOfThisTaskInstance();
        URL uRL = configurationWatchList.getMainURL();
        this.addInfo(DETECTED_CHANGE_IN_CONFIGURATION_FILES);
        this.addInfo("Will reset and reconfigure context named [" + this.context.getName() + "]");
        LoggerContext loggerContext = (LoggerContext)this.context;
        if (uRL.toString().endsWith("xml")) {
            this.performXMLConfiguration(loggerContext, uRL);
        } else if (uRL.toString().endsWith("groovy")) {
            this.addError("Groovy configuration disabled due to Java 9 compilation issues.");
        }
    }

    private void cancelFutureInvocationsOfThisTaskInstance() {
        boolean bl = this.scheduledFuture.cancel(false);
        if (!bl) {
            this.addWarn("could not cancel " + this.toString());
        }
    }

    private void performXMLConfiguration(LoggerContext loggerContext, URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        StatusUtil statusUtil = new StatusUtil(this.context);
        Model model = joranConfigurator.recallSafeConfiguration();
        URL uRL2 = ConfigurationWatchListUtil.getMainWatchURL((Context)this.context);
        loggerContext.reset();
        long l = System.currentTimeMillis();
        try {
            joranConfigurator.doConfigure(uRL);
            if (statusUtil.hasXMLParsingErrors(l)) {
                this.fallbackConfiguration(loggerContext, model, uRL2);
            }
        }
        catch (JoranException joranException) {
            this.addWarn("Exception occurred during reconfiguration", joranException);
            this.fallbackConfiguration(loggerContext, model, uRL2);
        }
    }

    private void fallbackConfiguration(LoggerContext loggerContext, Model model, URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        ConfigurationWatchList configurationWatchList2 = configurationWatchList.buildClone();
        if (model == null) {
            this.addWarn("No previous configuration to fall back on.");
            return;
        }
        this.addWarn(FALLING_BACK_TO_SAFE_CONFIGURATION);
        this.addInfo("Safe model " + String.valueOf(model));
        try {
            loggerContext.reset();
            ConfigurationWatchListUtil.registerConfigurationWatchList((Context)this.context, (ConfigurationWatchList)configurationWatchList2);
            ModelUtil.resetForReuse((Model)model);
            joranConfigurator.processModel(model);
            this.addInfo(RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION);
            joranConfigurator.registerSafeConfiguration(model);
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedEvent((Object)this));
            this.addInfo("after registerSafeConfiguration");
        }
        catch (Exception exception) {
            this.addError("Unexpected exception thrown by a configuration considered safe.", exception);
        }
    }

    public String toString() {
        return "ReconfigureOnChangeTask(born:" + this.birthdate + ")";
    }

    public void setScheduredFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }
}

