/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.model.ContextNameModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;

public class ContextNameModelHandler
extends ModelHandlerBase {
    public ContextNameModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ContextNameModelHandler(context);
    }

    protected Class<ContextNameModel> getSupportedModelClass() {
        return ContextNameModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        ContextNameModel contextNameModel = (ContextNameModel)model;
        String string = modelInterpretationContext.subst(contextNameModel.getBodyText());
        this.addInfo("Setting logger context name as [" + string + "]");
        try {
            this.context.setName(string);
        }
        catch (IllegalStateException illegalStateException) {
            this.addError("Failed to rename context [" + this.context.getName() + "] as [" + string + "]", illegalStateException);
        }
    }
}

