/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.tyler;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.LevelUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.util.PropertyModelHandlerHelper;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import ch.qos.logback.core.util.StringUtil;
import java.util.Map;

public class TylerConfiguratorBase
extends ContextAwareBase
implements ContextAwarePropertyContainer {
    public static final String SET_CONTEXT_METHOD_NAME = "setContext";
    public static final String SET_CONTEXT_NAME_METHOD_NAME = "setContextName";
    public static final String SETUP_LOGGER_METHOD_NAME = "setupLogger";
    public static final String VARIABLE_SUBSTITUTIONS_HELPER_FIELD_NAME = "variableSubstitutionsHelper";
    public static final String PROPERTY_MODEL_HANDLER_HELPER_FIELD_NAME = "propertyModelHandlerHelper";
    protected VariableSubstitutionsHelper variableSubstitutionsHelper;
    protected PropertyModelHandlerHelper propertyModelHandlerHelper = new PropertyModelHandlerHelper((ContextAware)this);

    protected Logger setupLogger(String string, String string2, Boolean bl) {
        LoggerContext loggerContext = (LoggerContext)this.context;
        Logger logger = loggerContext.getLogger(string);
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)string2)) {
            Level level = LevelUtil.levelStringToLevel(string2);
            logger.setLevel(level);
        }
        if (bl != null) {
            logger.setAdditive(bl);
        }
        return logger;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(context);
        this.propertyModelHandlerHelper.setContext(context);
    }

    protected void setContextName(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            this.addError("Cannot set context name to null or empty string");
            return;
        }
        try {
            String string2 = this.subst(string);
            this.addInfo("Setting context name to [" + string2 + "]");
            this.context.setName(string2);
        }
        catch (IllegalStateException illegalStateException) {
            this.addError("Failed to rename context as [" + string + "]");
        }
    }

    protected void addOnConsoleStatusListener() {
        StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)this.context, (OnConsoleStatusListener)new OnConsoleStatusListener());
    }

    public String subst(String string) {
        return this.variableSubstitutionsHelper.subst(string);
    }

    public void addSubstitutionProperty(String string, String string2) {
        this.variableSubstitutionsHelper.addSubstitutionProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.variableSubstitutionsHelper.getProperty(string);
    }

    public Map<String, String> getCopyOfPropertyMap() {
        return this.variableSubstitutionsHelper.getCopyOfPropertyMap();
    }

    public boolean isNull(String string) {
        String string2 = OptionHelper.propertyLookup((String)string, (PropertyContainer)this, (PropertyContainer)this.context);
        return string2 == null;
    }

    public boolean isDefined(String string) {
        String string2 = OptionHelper.propertyLookup((String)string, (PropertyContainer)this, (PropertyContainer)this.context);
        return string2 != null;
    }

    public String p(String string) {
        return this.property(string);
    }

    public String property(String string) {
        String string2 = OptionHelper.propertyLookup((String)string, (PropertyContainer)this, (PropertyContainer)this.context);
        if (string2 != null) {
            return string2;
        }
        return "";
    }
}

