/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.ArcSplineKt;
import androidx.compose.animation.core.internal.ArraysKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005R\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/ArcSpline;", "", "arcModes", "", "timePoints", "", "y", "", "<init>", "([I[F[[F)V", "arcs", "Landroidx/compose/animation/core/ArcSpline$Arc;", "[[Landroidx/compose/animation/core/ArcSpline$Arc;", "isExtrapolate", "", "getPos", "", "time", "", "v", "getSlope", "Arc", "animation-core"})
public final class ArcSpline {
    private final Arc[][] arcs;
    private final boolean isExtrapolate;
    public static final int $stable = 8;

    public ArcSpline(int[] nArray, float[] fArray, float[][] fArray2) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        this.isExtrapolate = true;
        int n = 1;
        int n2 = 1;
        int n3 = fArray.length - 1;
        Arc[][] arcArrayArray = new Arc[n3][];
        ArcSpline arcSpline = this;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            switch (nArray[n4]) {
                case 1: {
                    n2 = n = 1;
                    break;
                }
                case 2: {
                    n2 = n = 2;
                    break;
                }
                case 3: {
                    n2 = n = n2 == 1 ? 2 : 1;
                    break;
                }
                case 0: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 5;
                    break;
                }
                case 4: {
                    n = 4;
                }
            }
            float[] fArray3 = fArray2[n4];
            float[] fArray4 = fArray2[n4 + 1];
            float f = fArray[n4];
            float f2 = fArray[n4 + 1];
            int n5 = fArray3.length / 2 + fArray3.length % 2;
            int n6 = 0;
            Arc[] arcArray = new Arc[n5];
            int n7 = n4;
            Arc[][] arcArrayArray2 = arcArrayArray;
            while (n6 < n5) {
                int n8 = n6++;
                int n9 = n8 * 2;
                arcArray[n8] = new Arc(n, f, f2, fArray3[n9], fArray3[n9 + 1], fArray4[n9], fArray4[n9 + 1]);
            }
            arcArrayArray2[n7] = arcArray;
        }
        arcSpline.arcs = arcArrayArray;
    }

    public final void getPos(float f, float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        float f2 = f;
        Arc[][] arcArray = this.arcs;
        int n = ((Object[])arcArray).length - 1;
        float f3 = arcArray[0][0].getTime1();
        float f4 = arcArray[n][0].getTime2();
        int n2 = fArray.length;
        if (this.isExtrapolate) {
            if (f2 < f3 || f2 > f4) {
                int n3 = 0;
                float f5 = 0.0f;
                if (f2 > f4) {
                    n3 = n;
                    f5 = f4;
                } else {
                    n3 = 0;
                    f5 = f3;
                }
                float f6 = f2 - f5;
                int n4 = 0;
                int n5 = 0;
                while (n4 < n2 - 1) {
                    boolean bl;
                    Arc arc;
                    Arc arc2 = arcArray[n3][n5];
                    if (arc2.isLinear) {
                        arc = arc2;
                        bl = false;
                        fArray[n4] = arc2.getLinearX(f5) + f6 * arc.ellipseCenterX;
                        arc = arc2;
                        bl = false;
                        fArray[n4 + 1] = arc2.getLinearY(f5) + f6 * arc.ellipseCenterY;
                    } else {
                        arc2.setPoint(f5);
                        arc = arc2;
                        bl = false;
                        fArray[n4] = arc.ellipseCenterX + arc.ellipseA * arc.tmpSinAngle + f6 * arc2.calcDX();
                        arc = arc2;
                        bl = false;
                        fArray[n4 + 1] = arc.ellipseCenterY + arc.ellipseB * arc.tmpCosAngle + f6 * arc2.calcDY();
                    }
                    n4 += 2;
                    ++n5;
                }
                return;
            }
        } else {
            f2 = Math.max(f2, f3);
            f2 = Math.min(f2, f4);
        }
        boolean bl = false;
        int n6 = ((Object[])arcArray).length;
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n2 - 1) {
                Arc arc = arcArray[i2][n7];
                if (f2 <= arc.getTime2()) {
                    if (arc.isLinear) {
                        fArray[n8] = arc.getLinearX(f2);
                        fArray[n8 + 1] = arc.getLinearY(f2);
                    } else {
                        arc.setPoint(f2);
                        Arc arc3 = arc;
                        boolean bl2 = false;
                        fArray[n8] = arc3.ellipseCenterX + arc3.ellipseA * arc3.tmpSinAngle;
                        arc3 = arc;
                        bl2 = false;
                        fArray[n8 + 1] = arc3.ellipseCenterY + arc3.ellipseB * arc3.tmpCosAngle;
                    }
                    bl = true;
                }
                n8 += 2;
                ++n7;
            }
            if (!bl) continue;
            return;
        }
    }

    public final void getSlope(float f, float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Arc[][] arcArray = this.arcs;
        float f2 = f;
        float f3 = arcArray[0][0].getTime1();
        float f4 = arcArray[((Object[])arcArray).length - 1][0].getTime2();
        int n = 0;
        float f5 = f2;
        int n2 = 0;
        f5 = f5 < f3 ? f3 : f5;
        n2 = 0;
        float f6 = f5 > f4 ? f4 : f5;
        int n3 = fArray.length;
        boolean bl = false;
        n = ((Object[])arcArray).length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n4 = 0;
            n2 = 0;
            while (n4 < n3 - 1) {
                Arc arc = arcArray[i2][n2];
                if (f6 <= arc.getTime2()) {
                    if (arc.isLinear) {
                        Arc arc2 = arc;
                        boolean bl2 = false;
                        fArray[n4] = arc2.ellipseCenterX;
                        arc2 = arc;
                        bl2 = false;
                        fArray[n4 + 1] = arc2.ellipseCenterY;
                    } else {
                        arc.setPoint(f6);
                        fArray[n4] = arc.calcDX();
                        fArray[n4 + 1] = arc.calcDY();
                    }
                    bl = true;
                }
                n4 += 2;
                ++n2;
            }
            if (!bl) continue;
            return;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005J\u0011\u0010%\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0082\bJ\t\u0010&\u001a\u00020\u0005H\u0086\bJ\t\u0010'\u001a\u00020\u0005H\u0086\bJ\u0006\u0010(\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0002J-\u0010.\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b/R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001e\u001a\u00020\u00058\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000eR\u0015\u0010 \u001a\u00020\u00058\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000e\u00a8\u00060"}, d2={"Landroidx/compose/animation/core/ArcSpline$Arc;", "", "mode", "", "time1", "", "time2", "x1", "y1", "x2", "y2", "<init>", "(IFFFFFF)V", "getTime1", "()F", "getTime2", "arcDistance", "tmpSinAngle", "tmpCosAngle", "lut", "", "oneOverDeltaTime", "arcVelocity", "vertical", "ellipseA", "ellipseB", "isLinear", "", "ellipseCenterX", "ellipseCenterY", "linearDX", "getLinearDX$animation_core", "linearDY", "getLinearDY$animation_core", "setPoint", "", "time", "calcAngle", "calcX", "calcY", "calcDX", "calcDY", "getLinearX", "getLinearY", "lookup", "v", "buildTable", "buildTable$animation_core", "animation-core"})
    public static final class Arc {
        private final float time1;
        private final float time2;
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private float arcDistance;
        private float tmpSinAngle;
        private float tmpCosAngle;
        private final float[] lut;
        private final float oneOverDeltaTime;
        private final float arcVelocity;
        private final float vertical;
        public final float ellipseA;
        public final float ellipseB;
        public final boolean isLinear;
        public final float ellipseCenterX;
        public final float ellipseCenterY;
        public static final int $stable = 8;

        public Arc(int n, float f, float f2, float f3, float f4, float f5, float f6) {
            boolean bl;
            boolean bl2;
            this.time1 = f;
            this.time2 = f2;
            this.x1 = f3;
            this.y1 = f4;
            this.x2 = f5;
            this.y2 = f6;
            float f7 = this.x2 - this.x1;
            float f8 = this.y2 - this.y1;
            switch (n) {
                case 1: {
                    bl2 = true;
                    break;
                }
                case 5: {
                    if (f8 < 0.0f) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                case 4: {
                    if (f8 > 0.0f) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            boolean bl3 = bl2;
            this.vertical = bl3 ? -1.0f : 1.0f;
            this.oneOverDeltaTime = 1.0f / (this.time2 - this.time1);
            this.lut = new float[101];
            boolean bl4 = bl = n == 3;
            if (bl || Math.abs(f7) < 0.001f || Math.abs(f8) < 0.001f) {
                bl = true;
                this.arcDistance = (float)Math.hypot(f8, f7);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
                this.ellipseCenterX = f7 * this.oneOverDeltaTime;
                this.ellipseCenterY = f8 * this.oneOverDeltaTime;
                this.ellipseA = Float.NaN;
                this.ellipseB = Float.NaN;
            } else {
                this.ellipseA = f7 * this.vertical;
                this.ellipseB = f8 * -this.vertical;
                this.ellipseCenterX = bl3 ? this.x2 : this.x1;
                this.ellipseCenterY = bl3 ? this.y1 : this.y2;
                this.buildTable$animation_core(this.x1, this.y1, this.x2, this.y2);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
            }
            this.isLinear = bl;
        }

        public final float getTime1() {
            return this.time1;
        }

        public final float getTime2() {
            return this.time2;
        }

        public final float getLinearDX$animation_core() {
            boolean bl = false;
            return this.ellipseCenterX;
        }

        public final float getLinearDY$animation_core() {
            boolean bl = false;
            return this.ellipseCenterY;
        }

        public final void setPoint(float f) {
            Arc arc = this;
            boolean bl = false;
            float f2 = (arc.vertical == -1.0f ? arc.time2 - f : f - arc.time1) * arc.oneOverDeltaTime;
            float f3 = 1.5707964f * arc.lookup(f2);
            this.tmpSinAngle = (float)Math.sin(f3);
            this.tmpCosAngle = (float)Math.cos(f3);
        }

        private final float calcAngle(float f) {
            boolean bl = false;
            float f2 = (this.vertical == -1.0f ? this.time2 - f : f - this.time1) * this.oneOverDeltaTime;
            return 1.5707964f * this.lookup(f2);
        }

        public final float calcX() {
            boolean bl = false;
            return this.ellipseCenterX + this.ellipseA * this.tmpSinAngle;
        }

        public final float calcY() {
            boolean bl = false;
            return this.ellipseCenterY + this.ellipseB * this.tmpCosAngle;
        }

        public final float calcDX() {
            float f = this.ellipseA * this.tmpCosAngle;
            float f2 = -this.ellipseB * this.tmpSinAngle;
            float f3 = this.arcVelocity / (float)Math.hypot(f, f2);
            return f * this.vertical * f3;
        }

        public final float calcDY() {
            float f = this.ellipseA * this.tmpCosAngle;
            float f2 = -this.ellipseB * this.tmpSinAngle;
            float f3 = this.arcVelocity / (float)Math.hypot(f, f2);
            return f2 * this.vertical * f3;
        }

        public final float getLinearX(float f) {
            float f2 = f;
            f2 = (f2 - this.time1) * this.oneOverDeltaTime;
            return this.x1 + f2 * (this.x2 - this.x1);
        }

        public final float getLinearY(float f) {
            float f2 = f;
            f2 = (f2 - this.time1) * this.oneOverDeltaTime;
            return this.y1 + f2 * (this.y2 - this.y1);
        }

        private final float lookup(float f) {
            if (f <= 0.0f) {
                return 0.0f;
            }
            if (f >= 1.0f) {
                return 1.0f;
            }
            float f2 = f * (float)100;
            int n = (int)f2;
            float f3 = f2 - (float)((int)f2);
            return this.lut[n] + f3 * (this.lut[n + 1] - this.lut[n]);
        }

        public final void buildTable$animation_core(float f, float f2, float f3, float f4) {
            float f5;
            float f6 = f3 - f;
            float f7 = f2 - f4;
            float f8 = 0.0f;
            float f9 = f7;
            float f10 = 0.0f;
            float[] fArray = ArcSplineKt.access$getOurPercentCache$p();
            int n = fArray.length - 1;
            float f11 = n;
            float[] fArray2 = this.lut;
            int n2 = 1;
            if (n2 <= n) {
                while (true) {
                    double d2 = 90.0 * (double)n2 / (double)n;
                    boolean bl = false;
                    float f12 = (float)(d2 * (Math.PI / 180));
                    float f13 = (float)Math.sin(f12);
                    f5 = (float)Math.cos(f12);
                    float f14 = f6 * f13;
                    float f15 = f7 * f5;
                    fArray[n2] = f10 += (float)Math.hypot(f14 - f8, f15 - f9);
                    f8 = f14;
                    f9 = f15;
                    if (n2 == n) break;
                    ++n2;
                }
            }
            this.arcDistance = f10;
            n2 = 1;
            if (n2 <= n) {
                do {
                    int n3 = ++n2;
                    fArray[n3] = fArray[n3] / f10;
                } while (n2 != n);
            }
            float f16 = 100.0f;
            int n4 = fArray2.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                float f17;
                f5 = (float)i2 / f16;
                int n5 = ArraysKt.binarySearch$default(fArray, f5, 0, 0, 6, null);
                if (n5 >= 0) {
                    fArray2[i2] = (float)n5 / f11;
                    continue;
                }
                if (n5 == -1) {
                    fArray2[i2] = 0.0f;
                    continue;
                }
                int n6 = -n5 - 2;
                int n7 = -n5 - 1;
                fArray2[i2] = f17 = ((float)n6 + (f5 - fArray[n6]) / (fArray[n7] - fArray[n6])) / f11;
            }
        }
    }
}

