/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Interval;
import androidx.compose.ui.graphics.IntervalTree;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/compose/animation/core/PathEasing;", "Landroidx/compose/animation/core/Easing;", "path", "Landroidx/compose/ui/graphics/Path;", "<init>", "(Landroidx/compose/ui/graphics/Path;)V", "intervals", "Landroidx/compose/ui/graphics/IntervalTree;", "Landroidx/compose/ui/graphics/PathSegment;", "transform", "", "fraction", "initializeEasing", "", "animation-core"})
public final class PathEasing
implements Easing {
    private final Path path;
    private IntervalTree<PathSegment> intervals;
    public static final int $stable;

    public PathEasing(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        this.path = path;
    }

    @Override
    public float transform(float f2) {
        IntervalTree<PathSegment> intervalTree;
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (f2 >= 1.0f) {
            return 1.0f;
        }
        if (this.intervals == null) {
            this.initializeEasing();
        }
        if ((intervalTree = this.intervals) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            intervalTree = null;
        }
        Interval interval = IntervalTree.findFirstOverlap$default(intervalTree, (float)f2, (float)0.0f, (int)2, null);
        Object object = interval.getData();
        boolean bl = false;
        if (object == null) {
            boolean bl2 = false;
            PreconditionsKt.throwIllegalStateExceptionForNullCheck("The easing path is invalid. Make sure it is continuous on the x axis.");
            throw new KotlinNothingValueException();
        }
        PathSegment pathSegment = (PathSegment)object;
        float f3 = BezierKt.findFirstRoot((PathSegment)pathSegment, (float)f2);
        bl = !Float.isNaN(f3);
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            PreconditionsKt.throwIllegalStateException("The easing path is invalid. Make sure it does not contain NaN/Infinity values.");
        }
        return BezierKt.evaluateY((PathSegment)pathSegment, (float)f3);
    }

    private final void initializeEasing() {
        IntervalTree intervalTree;
        float[] fArray = new float[5];
        IntervalTree intervalTree2 = intervalTree = new IntervalTree();
        boolean bl = false;
        PathIterator pathIterator = this.path.iterator(PathIterator.ConicEvaluation.AsQuadratics, 2.0E-4f);
        while (pathIterator.hasNext()) {
            boolean bl2;
            PathSegment pathSegment = pathIterator.next();
            boolean bl3 = pathSegment.getType() != PathSegment.Type.Close;
            boolean bl4 = false;
            if (!bl3) {
                bl2 = false;
                PreconditionsKt.throwIllegalArgumentException("The path cannot contain a close() command.");
            }
            if (pathSegment.getType() == PathSegment.Type.Move || pathSegment.getType() == PathSegment.Type.Done) continue;
            long l2 = BezierKt.computeHorizontalBounds$default((PathSegment)pathSegment, (float[])fArray, (int)0, (int)4, null);
            bl2 = false;
            int n = (int)(l2 >> 32);
            boolean bl5 = false;
            float f2 = Float.intBitsToFloat(n);
            bl2 = false;
            n = (int)(l2 & 0xFFFFFFFFL);
            bl5 = false;
            intervalTree2.addInterval(f2, Float.intBitsToFloat(n), (Object)pathSegment);
        }
        IntervalTree intervalTree3 = intervalTree;
        boolean bl6 = intervalTree3.contains(0.0f) && intervalTree3.contains(1.0f);
        boolean bl7 = false;
        if (!bl6) {
            bl = false;
            PreconditionsKt.throwIllegalArgumentException("The easing path must start at 0.0f and end at 1.0f.");
        }
        this.intervals = intervalTree3;
    }
}

