/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.kqueue.AcceptFilter;
import io.netty.channel.kqueue.Native;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

final class BsdSocket
extends Socket {
    private static final int APPLE_SND_LOW_AT_MAX = 131072;
    private static final int FREEBSD_SND_LOW_AT_MAX = 32768;
    static final int BSD_SND_LOW_AT_MAX = Math.min(131072, 32768);
    private static final int UNSPECIFIED_SOURCE_INTERFACE = 0;

    BsdSocket(int n) {
        super(n);
    }

    void setAcceptFilter(AcceptFilter acceptFilter) {
        BsdSocket.setAcceptFilter(this.intValue(), acceptFilter.filterName(), acceptFilter.filterArgs());
    }

    void setTcpNoPush(boolean bl) {
        BsdSocket.setTcpNoPush(this.intValue(), bl ? 1 : 0);
    }

    void setSndLowAt(int n) {
        BsdSocket.setSndLowAt(this.intValue(), n);
    }

    public void setTcpFastOpen(boolean bl) {
        BsdSocket.setTcpFastOpen(this.intValue(), bl ? 1 : 0);
    }

    boolean isTcpNoPush() {
        return BsdSocket.getTcpNoPush(this.intValue()) != 0;
    }

    int getSndLowAt() {
        return BsdSocket.getSndLowAt(this.intValue());
    }

    AcceptFilter getAcceptFilter() {
        String[] stringArray = BsdSocket.getAcceptFilter(this.intValue());
        return stringArray == null ? AcceptFilter.PLATFORM_UNSUPPORTED : new AcceptFilter(stringArray[0], stringArray[1]);
    }

    public boolean isTcpFastOpen() {
        return BsdSocket.isTcpFastOpen(this.intValue()) != 0;
    }

    PeerCredentials getPeerCredentials() {
        return BsdSocket.getPeerCredentials(this.intValue());
    }

    long sendFile(DefaultFileRegion defaultFileRegion, long l, long l2, long l3) {
        defaultFileRegion.open();
        long l4 = BsdSocket.sendFile(this.intValue(), defaultFileRegion, l, l2, l3);
        if (l4 >= 0L) {
            return l4;
        }
        return Errors.ioResult((String)"sendfile", (int)((int)l4));
    }

    int connectx(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, IovArray iovArray, boolean bl) {
        int n;
        int n2;
        long l;
        int n3;
        byte[] byArray;
        InetAddress inetAddress;
        int n4;
        int n5;
        byte[] byArray2;
        boolean bl2;
        int n6;
        ObjectUtil.checkNotNull((Object)inetSocketAddress2, (String)"Destination InetSocketAddress cannot be null.");
        int n7 = n6 = bl ? Native.CONNECT_TCP_FASTOPEN : 0;
        if (inetSocketAddress == null) {
            bl2 = false;
            byArray2 = null;
            n5 = 0;
            n4 = 0;
        } else {
            inetAddress = inetSocketAddress.getAddress();
            bl2 = BsdSocket.useIpv6((Socket)this, (InetAddress)inetAddress);
            if (inetAddress instanceof Inet6Address) {
                byArray2 = inetAddress.getAddress();
                n5 = ((Inet6Address)inetAddress).getScopeId();
            } else {
                n5 = 0;
                byArray2 = NativeInetAddress.ipv4MappedIpv6Address((byte[])inetAddress.getAddress());
            }
            n4 = inetSocketAddress.getPort();
        }
        inetAddress = inetSocketAddress2.getAddress();
        boolean bl3 = BsdSocket.useIpv6((Socket)this, (InetAddress)inetAddress);
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n3 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n3 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address((byte[])inetAddress.getAddress());
        }
        int n8 = inetSocketAddress2.getPort();
        if (iovArray == null || iovArray.count() == 0) {
            l = 0L;
            n2 = 0;
            n = 0;
        } else {
            l = iovArray.memoryAddress(0);
            n2 = iovArray.count();
            long l2 = iovArray.size();
            if (l2 > Integer.MAX_VALUE) {
                throw new IOException("IovArray.size() too big: " + l2 + " bytes.");
            }
            n = (int)l2;
        }
        int n9 = BsdSocket.connectx(this.intValue(), 0, bl2, byArray2, n5, n4, bl3, byArray, n3, n8, n6, l, n2, n);
        if (n9 == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
            return -n;
        }
        if (n9 < 0) {
            return Errors.ioResult((String)"connectx", (int)n9);
        }
        return n9;
    }

    public static BsdSocket newSocketStream() {
        return new BsdSocket(BsdSocket.newSocketStream0());
    }

    public static BsdSocket newSocketStream(InternetProtocolFamily internetProtocolFamily) {
        return new BsdSocket(BsdSocket.newSocketStream0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static BsdSocket newSocketDgram() {
        return new BsdSocket(BsdSocket.newSocketDgram0());
    }

    public static BsdSocket newSocketDgram(InternetProtocolFamily internetProtocolFamily) {
        return new BsdSocket(BsdSocket.newSocketDgram0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static BsdSocket newSocketDomain() {
        return new BsdSocket(BsdSocket.newSocketDomain0());
    }

    public static BsdSocket newSocketDomainDgram() {
        return new BsdSocket(BsdSocket.newSocketDomainDgram0());
    }

    private static native long sendFile(int var0, DefaultFileRegion var1, long var2, long var4, long var6);

    private static native int connectx(int var0, int var1, boolean var2, byte[] var3, int var4, int var5, boolean var6, byte[] var7, int var8, int var9, int var10, long var11, int var13, int var14);

    private static native String[] getAcceptFilter(int var0);

    private static native int getTcpNoPush(int var0);

    private static native int getSndLowAt(int var0);

    private static native int isTcpFastOpen(int var0);

    private static native PeerCredentials getPeerCredentials(int var0);

    private static native void setAcceptFilter(int var0, String var1, String var2);

    private static native void setTcpNoPush(int var0, int var1);

    private static native void setSndLowAt(int var0, int var1);

    private static native void setTcpFastOpen(int var0, int var1);
}

