/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventArray;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class KQueueEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueEventLoop.class);
    private static final AtomicIntegerFieldUpdater<KQueueEventLoop> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueEventLoop.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private static final int KQUEUE_MAX_TIMEOUT_SECONDS = 86399;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final IovArray iovArray = new IovArray();
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        public int get() {
            return KQueueEventLoop.this.kqueueWaitNow();
        }
    };
    private final IntObjectMap<AbstractKQueueChannel> channels = new IntObjectHashMap(4096);
    private volatile int wakenUp;
    private volatile int ioRatio = 50;

    KQueueEventLoop(EventLoopGroup eventLoopGroup, Executor executor, int n, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory, EventLoopTaskQueueFactory eventLoopTaskQueueFactory2) {
        super(eventLoopGroup, executor, false, KQueueEventLoop.newTaskQueue(eventLoopTaskQueueFactory), KQueueEventLoop.newTaskQueue(eventLoopTaskQueueFactory2), rejectedExecutionHandler);
        this.selectStrategy = (SelectStrategy)ObjectUtil.checkNotNull((Object)selectStrategy, (String)"strategy");
        this.kqueueFd = Native.newKQueue();
        if (n == 0) {
            this.allowGrowing = true;
            n = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(n);
        this.eventList = new KQueueEventArray(n);
        int n2 = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (n2 < 0) {
            this.cleanup();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -n2);
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return KQueueEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    void add(AbstractKQueueChannel abstractKQueueChannel) {
        assert (this.inEventLoop());
        AbstractKQueueChannel abstractKQueueChannel2 = (AbstractKQueueChannel)((Object)this.channels.put(abstractKQueueChannel.fd().intValue(), (Object)abstractKQueueChannel));
        assert (abstractKQueueChannel2 == null || !abstractKQueueChannel2.isOpen());
    }

    void evSet(AbstractKQueueChannel abstractKQueueChannel, short s, short s2, int n) {
        assert (this.inEventLoop());
        this.changeList.evSet(abstractKQueueChannel, s, s2, n);
    }

    void remove(AbstractKQueueChannel abstractKQueueChannel) {
        assert (this.inEventLoop());
        int n = abstractKQueueChannel.fd().intValue();
        AbstractKQueueChannel abstractKQueueChannel2 = (AbstractKQueueChannel)((Object)this.channels.remove(n));
        if (abstractKQueueChannel2 != null && abstractKQueueChannel2 != abstractKQueueChannel) {
            this.channels.put(n, (Object)abstractKQueueChannel2);
            assert (!abstractKQueueChannel.isOpen());
        } else if (abstractKQueueChannel.isOpen()) {
            abstractKQueueChannel.unregisterFilters();
        }
    }

    IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    protected void wakeup(boolean bl) {
        if (!bl && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup();
        }
    }

    private void wakeup() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(boolean bl) {
        if (bl && this.hasTasks()) {
            return this.kqueueWaitNow();
        }
        long l = this.delayNanos(System.nanoTime());
        int n = (int)Math.min(l / 1000000000L, 86399L);
        int n2 = (int)(l % 1000000000L);
        return this.kqueueWait(n, n2);
    }

    private int kqueueWaitNow() {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int n, int n2) {
        int n3 = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, n, n2);
        this.changeList.clear();
        return n3;
    }

    private void processReady(int n) {
        for (int i = 0; i < n; ++i) {
            short s = this.eventList.filter(i);
            short s2 = this.eventList.flags(i);
            int n2 = this.eventList.fd(i);
            if (s == Native.EVFILT_USER || (s2 & Native.EV_ERROR) != 0) {
                assert (s != Native.EVFILT_USER || s == Native.EVFILT_USER && n2 == 0);
                continue;
            }
            AbstractKQueueChannel abstractKQueueChannel = (AbstractKQueueChannel)((Object)this.channels.get(n2));
            if (abstractKQueueChannel == null) {
                logger.warn("events[{}]=[{}, {}] had no channel!", new Object[]{i, this.eventList.fd(i), s});
                continue;
            }
            AbstractKQueueChannel.AbstractKQueueUnsafe abstractKQueueUnsafe = (AbstractKQueueChannel.AbstractKQueueUnsafe)abstractKQueueChannel.unsafe();
            if (s == Native.EVFILT_WRITE) {
                abstractKQueueUnsafe.writeReady();
            } else if (s == Native.EVFILT_READ) {
                abstractKQueueUnsafe.readReady(this.eventList.data(i));
            } else if (s == Native.EVFILT_SOCK && (this.eventList.fflags(i) & Native.NOTE_RDHUP) != 0) {
                abstractKQueueUnsafe.readEOF();
            }
            if ((s2 & Native.EV_EOF) == 0) continue;
            abstractKQueueUnsafe.readEOF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void run() {
        block29: while (true) {
            try {
                var1_1 = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                switch (var1_1) {
                    ** case -2:
lbl6:
                    // 1 sources

                    continue block29;
                    case -3: 
                    case -1: {
                        var1_1 = this.kqueueWait(KQueueEventLoop.WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                        if (this.wakenUp == 1) {
                            this.wakeup();
                        }
                    }
                    default: {
                        var2_10 = this.ioRatio;
                        if (var2_10 != 100) ** GOTO lbl22
                        try {
                            if (var1_1 <= 0) ** GOTO lbl32
                            this.processReady(var1_1);
                        }
                        finally {
                            this.runAllTasks();
                        }
lbl22:
                        // 1 sources

                        var3_11 = System.nanoTime();
                        try {
                            if (var1_1 > 0) {
                                this.processReady(var1_1);
                            }
                        }
                        finally {
                            var5_13 = System.nanoTime() - var3_11;
                            this.runAllTasks(var5_13 * (long)(100 - var2_10) / (long)var2_10);
                        }
lbl32:
                        // 3 sources

                        if (!this.allowGrowing || var1_1 != this.eventList.capacity()) continue block29;
                        this.eventList.realloc(false);
                        continue block29;
                    }
                }
            }
            catch (Error var1_4) {
                throw var1_4;
            }
            catch (Throwable var1_5) {
                KQueueEventLoop.handleLoopException(var1_5);
                continue;
            }
            finally {
                try {
                    if (!this.isShuttingDown()) continue;
                    this.closeAll();
                    if (!this.confirmShutdown()) continue;
                    break;
                }
                catch (Error var1_6) {
                    throw var1_6;
                }
                catch (Throwable var1_7) {
                    KQueueEventLoop.handleLoopException(var1_7);
                }
                continue;
            }
            break;
        }
    }

    protected Queue<Runnable> newTaskQueue(int n) {
        return KQueueEventLoop.newTaskQueue0(n);
    }

    private static Queue<Runnable> newTaskQueue0(int n) {
        return n == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue((int)n);
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n) {
        if (n <= 0 || n > 100) {
            throw new IllegalArgumentException("ioRatio: " + n + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n;
    }

    public int registeredChannels() {
        return this.channels.size();
    }

    public Iterator<Channel> registeredChannelsIterator() {
        assert (this.inEventLoop());
        IntObjectMap<AbstractKQueueChannel> intObjectMap = this.channels;
        if (intObjectMap.isEmpty()) {
            return SingleThreadEventLoop.ChannelsReadOnlyIterator.empty();
        }
        return new SingleThreadEventLoop.ChannelsReadOnlyIterator((Iterable)intObjectMap.values());
    }

    protected void cleanup() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the kqueue fd.", (Throwable)iOException);
            }
        }
        finally {
            this.iovArray.release();
            this.changeList.free();
            this.eventList.free();
        }
    }

    private void closeAll() {
        AbstractKQueueChannel[] abstractKQueueChannelArray;
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (AbstractKQueueChannel abstractKQueueChannel : abstractKQueueChannelArray = this.channels.values().toArray(new AbstractKQueueChannel[0])) {
            abstractKQueueChannel.unsafe().close(abstractKQueueChannel.unsafe().voidPromise());
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        KQueue.ensureAvailability();
    }
}

