/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueSocketChannelConfig;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.IovArray;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

public final class KQueueSocketChannel
extends AbstractKQueueStreamChannel
implements SocketChannel {
    private final KQueueSocketChannelConfig config = new KQueueSocketChannelConfig(this);

    public KQueueSocketChannel() {
        super(null, BsdSocket.newSocketStream(), false);
    }

    public KQueueSocketChannel(InternetProtocolFamily internetProtocolFamily) {
        super(null, BsdSocket.newSocketStream(internetProtocolFamily), false);
    }

    public KQueueSocketChannel(int n) {
        super(new BsdSocket(n));
    }

    KQueueSocketChannel(Channel channel, BsdSocket bsdSocket, InetSocketAddress inetSocketAddress) {
        super(channel, bsdSocket, inetSocketAddress);
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public KQueueSocketChannelConfig config() {
        return this.config;
    }

    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect0(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (this.config.isTcpFastOpenConnect()) {
            ByteBuf byteBuf;
            ChannelOutboundBuffer channelOutboundBuffer = this.unsafe().outboundBuffer();
            channelOutboundBuffer.addFlush();
            Object object = channelOutboundBuffer.current();
            if (object instanceof ByteBuf && (byteBuf = (ByteBuf)object).isReadable()) {
                IovArray iovArray = new IovArray(this.config.getAllocator().directBuffer());
                try {
                    iovArray.add(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                    int n = this.socket.connectx((InetSocketAddress)socketAddress2, (InetSocketAddress)socketAddress, iovArray, true);
                    this.writeFilter(true);
                    channelOutboundBuffer.removeBytes((long)Math.abs(n));
                    boolean bl = n > 0;
                    return bl;
                }
                finally {
                    iovArray.release();
                }
            }
        }
        return super.doConnect0(socketAddress, socketAddress2);
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueSocketChannelUnsafe();
    }

    private final class KQueueSocketChannelUnsafe
    extends AbstractKQueueStreamChannel.KQueueStreamUnsafe {
        private KQueueSocketChannelUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            try {
                if (KQueueSocketChannel.this.isOpen() && KQueueSocketChannel.this.config().getSoLinger() > 0) {
                    ((KQueueEventLoop)KQueueSocketChannel.this.eventLoop()).remove(KQueueSocketChannel.this);
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

