/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.desktop;

import dorkbox.executor.Executor;
import dorkbox.jna.linux.GnomeVFS;
import dorkbox.jna.linux.GtkCheck;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.os.OS;
import dorkbox.updates.Updates;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.SwingUtilities;

public class Desktop {
    private static final String GVFS = "/usr/bin/gvfs-open";
    private static final boolean GVFS_VALID = new File("/usr/bin/gvfs-open").canExecute();

    public static String getVersion() {
        return "1.1";
    }

    public static void open(final File file) {
        if (file == null) {
            throw new IOException("File must not be null.");
        }
        if (Desktop.requireUnixLauncher()) {
            Desktop.launchNix(file.toString());
        } else if (Desktop.awtSupported(Desktop.Action.OPEN)) {
            Desktop.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().open(file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `open`");
        }
    }

    public static void browseURL(String string) {
        if (string == null || string.isEmpty()) {
            throw new IOException("Address must not be null or empty.");
        }
        try {
            URI uRI = new URI(string);
            Desktop.browseURL(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Invalid URI " + string);
        }
    }

    public static void browseURL(final URI uRI) {
        if (uRI == null) {
            throw new IOException("URI must not be null.");
        }
        if (Desktop.requireUnixLauncher()) {
            Desktop.launchNix(uRI.toString());
        } else if (Desktop.awtSupported(Desktop.Action.BROWSE)) {
            Desktop.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().browse(uRI);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `browseURL`");
        }
    }

    public static void launchEmail(String string) {
        if (string == null || string.isEmpty()) {
            throw new IOException("Address must not be null or empty.");
        }
        try {
            if (!string.startsWith("mailto:")) {
                string = "mailto:" + string;
            }
            URI uRI = new URI(string);
            Desktop.launchEmail(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Invalid URI " + string);
        }
    }

    public static void launchEmail(final URI uRI) {
        if (uRI == null) {
            throw new IOException("URI must not be null.");
        }
        if (Desktop.requireUnixLauncher()) {
            Desktop.launchNix(uRI.toString());
        } else if (Desktop.awtSupported(Desktop.Action.MAIL)) {
            Desktop.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().mail(uRI);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `launchEmail`");
        }
    }

    public static void browseDirectory(String string) {
        Object object;
        File[] fileArray;
        if (string == null || string.isEmpty()) {
            throw new IOException("Path must not be null or empty.");
        }
        if (OS.INSTANCE.isMacOsX() && (fileArray = ((File)(object = new File(string))).listFiles()) != null && fileArray.length > 0) {
            File file = fileArray[0];
            new Executor().command(new String[]{"open", "-R", file.getCanonicalPath()}).startAsync();
        }
        if (Desktop.requireUnixLauncher()) {
            if (!string.contains("://")) {
                string = "file://" + string;
            }
            Desktop.launchNix(string);
        } else if (Desktop.awtSupported(Desktop.Action.OPEN)) {
            object = string;
            Desktop.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$finalPath;
                {
                    this.val$finalPath = string;
                }

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().open(new File(this.val$finalPath));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `browseDirectory`");
        }
    }

    private static boolean requireUnixLauncher() {
        return (OS.INSTANCE.isUnix() || OS.INSTANCE.isLinux()) && GtkCheck.isGtkLoaded && GtkCheck.isGtk3;
    }

    private static boolean awtSupported(Desktop.Action action) {
        return java.awt.Desktop.isDesktopSupported() && java.awt.Desktop.getDesktop().isSupported(action);
    }

    private static void launchNix(final String string) {
        if (GVFS_VALID) {
            new Executor().command(new String[]{GVFS, string}).startAsync();
        } else if (OS.DesktopEnv.INSTANCE.isGnome() && GnomeVFS.isInited) {
            GtkEventDispatch.dispatch((Runnable)new Runnable(){

                @Override
                public void run() {
                    int n = GnomeVFS.gnome_vfs_url_show_with_env((String)string, null);
                    if (n != 0) {
                        try {
                            new Executor().command(new String[]{"xdg-open", string}).startAsync();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        } else {
            new Executor().command(new String[]{"xdg-open", string}).startAsync();
        }
    }

    private static void invokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static {
        Updates.INSTANCE.add(Desktop.class, "3dc6a3bf880c4b388d07f07070dff520", Desktop.getVersion());
    }
}

