/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u001a\u0014\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"computeDirection", "Landroidx/compose/ui/graphics/Path$Direction;", "Landroidx/compose/ui/graphics/Path;", "divide", "", "contours", "reverse", "destination", "floatCountForType", "", "type", "Landroidx/compose/ui/graphics/PathSegment$Type;", "ui-graphics"})
public final class PathGeometryKt {
    public static final Path.Direction computeDirection(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        boolean bl = true;
        PathIterator pathIterator = path.iterator();
        float[] fArray = new float[8];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        PathSegment.Type type = PathIterator.next$default(pathIterator, fArray, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!bl) break block9;
                    bl = false;
                    f2 = fArray[0];
                    f3 = fArray[1];
                    break;
                }
                case 2: {
                    float f6 = fArray[0];
                    float f7 = fArray[1];
                    float f8 = fArray[2];
                    float f9 = fArray[3];
                    f += BezierKt.cubicArea(f6, f7, f6, f7, f8, f9, f8, f9);
                    f4 = f8;
                    f5 = f9;
                    break;
                }
                case 3: {
                    float f6 = fArray[0];
                    float f10 = fArray[1];
                    float f8 = fArray[2];
                    float f9 = fArray[3];
                    float f11 = fArray[4];
                    float f12 = fArray[5];
                    float f13 = f6 + 0.6666667f * (f8 - f6);
                    float f14 = f10 + 0.6666667f * (f9 - f10);
                    float f15 = f11 + 0.6666667f * (f8 - f11);
                    float f16 = f12 + 0.6666667f * (f9 - f12);
                    f += BezierKt.cubicArea(f6, f10, f13, f14, f15, f16, f11, f12);
                    f4 = f11;
                    f5 = f12;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    f += BezierKt.cubicArea(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    f4 = fArray[6];
                    f5 = fArray[7];
                    break;
                }
                case 6: {
                    float f6 = f4;
                    boolean bl2 = false;
                    if (Math.abs(f6 - f2) < 1.05E-6f) {
                        f6 = f5;
                        bl2 = false;
                        if (Math.abs(f6 - f3) < 1.05E-6f) break;
                    }
                    f += BezierKt.cubicArea(f4, f5, f4, f5, f2, f3, f2, f3);
                    f4 = f2;
                    f5 = f3;
                    break;
                }
                case 7: {
                    break block9;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            type = PathIterator.next$default(pathIterator, fArray, 0, 2, null);
        }
        return f >= 0.0f ? Path.Direction.Clockwise : Path.Direction.CounterClockwise;
    }

    public static final List<Path> divide(Path path, List<Path> list) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Path path2 = SkiaBackedPath_skikoKt.Path();
        boolean bl = true;
        boolean bl2 = true;
        PathIterator pathIterator = path.iterator();
        float[] fArray = new float[8];
        PathSegment.Type type = PathIterator.next$default(pathIterator, fArray, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!bl && !bl2) {
                        list.add(path2);
                        path2 = SkiaBackedPath_skikoKt.Path();
                    }
                    bl = false;
                    bl2 = true;
                    path2.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    path2.lineTo(fArray[2], fArray[3]);
                    bl2 = false;
                    break;
                }
                case 3: {
                    path2.quadraticTo(fArray[2], fArray[3], fArray[4], fArray[5]);
                    bl2 = false;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    path2.cubicTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    bl2 = false;
                    break;
                }
                case 6: {
                    path2.close();
                    break;
                }
                case 7: {
                    continue block9;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            type = PathIterator.next$default(pathIterator, fArray, 0, 2, null);
        }
        if (!bl && !bl2) {
            list.add(path2);
        }
        return list;
    }

    public static /* synthetic */ List divide$default(Path path, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        return PathGeometryKt.divide(path, list);
    }

    public static final Path reverse(Path path, Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"");
        PathIterator pathIterator = path.iterator();
        int n = pathIterator.calculateSize(false);
        ArrayList<PathSegment.Type> arrayList = new ArrayList<PathSegment.Type>(n);
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>(n);
        float[] fArray = new float[8];
        PathSegment.Type type = PathIterator.next$default(pathIterator, fArray, 0, 2, null);
        while (type != PathSegment.Type.Done) {
            arrayList.add(type);
            if (type != PathSegment.Type.Close) {
                float[] fArray2 = Arrays.copyOf(fArray, PathGeometryKt.floatCountForType(type));
                Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"");
                arrayList2.add(fArray2);
            }
            type = PathIterator.next$default(pathIterator, fArray, 0, 2, null);
        }
        boolean bl = true;
        boolean bl2 = false;
        int n2 = arrayList2.size();
        block10: for (int i = arrayList.size() - 1; -1 < i; --i) {
            if (bl) {
                Object e2 = arrayList2.get(--n2);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"");
                fArray = (float[])e2;
                int n3 = ArraysKt.getLastIndex((float[])fArray);
                path2.moveTo(fArray[n3 - 1], fArray[n3]);
                bl = false;
            } else {
                Object e3 = arrayList2.get(n2);
                Intrinsics.checkNotNullExpressionValue(e3, (String)"");
                fArray = (float[])e3;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((PathSegment.Type)((Object)arrayList.get(i))).ordinal()]) {
                case 1: {
                    if (bl2) {
                        path2.close();
                        bl2 = false;
                    }
                    bl = true;
                    continue block10;
                }
                case 2: {
                    path2.lineTo(fArray[0], fArray[1]);
                    --n2;
                    continue block10;
                }
                case 3: {
                    path2.quadraticTo(fArray[2], fArray[3], fArray[0], fArray[1]);
                    --n2;
                    continue block10;
                }
                case 4: {
                    continue block10;
                }
                case 5: {
                    path2.cubicTo(fArray[4], fArray[5], fArray[2], fArray[3], fArray[0], fArray[1]);
                    --n2;
                    continue block10;
                }
                case 6: {
                    bl2 = true;
                    continue block10;
                }
                case 7: {
                    continue block10;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (bl2) {
            path2.close();
        }
        return path2;
    }

    public static /* synthetic */ Path reverse$default(Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            path2 = SkiaBackedPath_skikoKt.Path();
        }
        return PathGeometryKt.reverse(path, path2);
    }

    private static final int floatCountForType(PathSegment.Type type) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 6;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

