/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.graphics.PathSegmentKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.PathSegmentIterator;
import org.jetbrains.skia.PathVerb;
import org.jetbrains.skia.Point;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0017H\u0096\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\t\u0010\u0019\u001a\u00020\u001eH\u0096\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/graphics/SkiaPathIterator;", "Landroidx/compose/ui/graphics/PathIterator;", "path", "Landroidx/compose/ui/graphics/Path;", "conicEvaluation", "Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;", "tolerance", "", "<init>", "(Landroidx/compose/ui/graphics/Path;Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;F)V", "getPath", "()Landroidx/compose/ui/graphics/Path;", "getConicEvaluation", "()Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;", "getTolerance", "()F", "skiaPath", "Lorg/jetbrains/skia/Path;", "iterator", "Lorg/jetbrains/skia/PathSegmentIterator;", "calculateSize", "", "includeConvertedConics", "", "hasNext", "next", "Landroidx/compose/ui/graphics/PathSegment$Type;", "points", "", "offset", "Landroidx/compose/ui/graphics/PathSegment;", "ui-graphics"})
final class SkiaPathIterator
implements PathIterator {
    private final Path path;
    private final PathIterator.ConicEvaluation conicEvaluation;
    private final float tolerance;
    private final org.jetbrains.skia.Path skiaPath;
    private final PathSegmentIterator iterator;

    public SkiaPathIterator(Path path, PathIterator.ConicEvaluation conicEvaluation, float f) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)conicEvaluation), (String)"");
        this.path = path;
        this.conicEvaluation = conicEvaluation;
        this.tolerance = f;
        this.skiaPath = SkiaBackedPath_skikoKt.asSkiaPath(this.getPath());
        this.iterator = this.skiaPath.iterator();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public PathIterator.ConicEvaluation getConicEvaluation() {
        return this.conicEvaluation;
    }

    @Override
    public float getTolerance() {
        return this.tolerance;
    }

    @Override
    public int calculateSize(boolean bl) {
        return this.skiaPath.getVerbsCount();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public PathSegment.Type next(float[] fArray, int n) {
        PathSegment.Type type;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (!(fArray.length - n >= 8)) {
            boolean bl = false;
            String string = "The points array must contain at least 8 floats";
            throw new IllegalStateException(string.toString());
        }
        if (!this.hasNext()) {
            return PathSegment.Type.Done;
        }
        org.jetbrains.skia.PathSegment pathSegment = this.iterator.next();
        if (pathSegment == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getVerb().ordinal()]) {
            case 1: {
                Point point = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[n] = point.getX();
                Point point2 = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point2);
                fArray[n + 1] = point2.getY();
                type = PathSegment.Type.Move;
                break;
            }
            case 2: {
                Point point = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[n] = point.getX();
                Point point3 = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point3);
                fArray[n + 1] = point3.getY();
                Point point4 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point4);
                fArray[n + 2] = point4.getX();
                Point point5 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point5);
                fArray[n + 3] = point5.getY();
                type = PathSegment.Type.Line;
                break;
            }
            case 3: {
                Point point = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[n] = point.getX();
                Point point6 = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point6);
                fArray[n + 1] = point6.getY();
                Point point7 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point7);
                fArray[n + 2] = point7.getX();
                Point point8 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point8);
                fArray[n + 3] = point8.getY();
                Point point9 = pathSegment.getP2();
                Intrinsics.checkNotNull((Object)point9);
                fArray[n + 4] = point9.getX();
                Point point10 = pathSegment.getP2();
                Intrinsics.checkNotNull((Object)point10);
                fArray[n + 5] = point10.getY();
                type = PathSegment.Type.Quadratic;
                break;
            }
            case 4: {
                Point point = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[n] = point.getX();
                Point point11 = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point11);
                fArray[n + 1] = point11.getY();
                Point point12 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point12);
                fArray[n + 2] = point12.getX();
                Point point13 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point13);
                fArray[n + 3] = point13.getY();
                Point point14 = pathSegment.getP2();
                Intrinsics.checkNotNull((Object)point14);
                fArray[n + 4] = point14.getX();
                Point point15 = pathSegment.getP2();
                Intrinsics.checkNotNull((Object)point15);
                fArray[n + 5] = point15.getY();
                fArray[n + 6] = pathSegment.getConicWeight();
                fArray[n + 7] = pathSegment.getConicWeight();
                type = PathSegment.Type.Conic;
                break;
            }
            case 5: {
                Point point = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[n] = point.getX();
                Point point16 = pathSegment.getP0();
                Intrinsics.checkNotNull((Object)point16);
                fArray[n + 1] = point16.getY();
                Point point17 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point17);
                fArray[n + 2] = point17.getX();
                Point point18 = pathSegment.getP1();
                Intrinsics.checkNotNull((Object)point18);
                fArray[n + 3] = point18.getY();
                Point point19 = pathSegment.getP2();
                Intrinsics.checkNotNull((Object)point19);
                fArray[n + 4] = point19.getX();
                Point point20 = pathSegment.getP2();
                Intrinsics.checkNotNull((Object)point20);
                fArray[n + 5] = point20.getY();
                Point point21 = pathSegment.getP3();
                Intrinsics.checkNotNull((Object)point21);
                fArray[n + 6] = point21.getX();
                Point point22 = pathSegment.getP3();
                Intrinsics.checkNotNull((Object)point22);
                fArray[n + 7] = point22.getY();
                type = PathSegment.Type.Cubic;
                break;
            }
            case 6: {
                type = PathSegment.Type.Close;
                break;
            }
            case 7: {
                type = PathSegment.Type.Done;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type;
    }

    @Override
    public PathSegment next() {
        PathSegment pathSegment;
        if (!this.hasNext()) {
            return PathSegmentKt.getDoneSegment();
        }
        org.jetbrains.skia.PathSegment pathSegment2 = this.iterator.next();
        if (pathSegment2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment2.getVerb().ordinal()]) {
            case 1: {
                float[] fArray = new float[2];
                Point point = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point2 = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point2);
                fArray[1] = point2.getY();
                PathSegment pathSegment3 = new PathSegment(PathSegment.Type.Move, fArray, 0.0f);
                pathSegment = pathSegment3;
                break;
            }
            case 2: {
                float[] fArray = new float[4];
                Point point = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point3 = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point3);
                fArray[1] = point3.getY();
                Point point4 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point4);
                fArray[2] = point4.getX();
                Point point5 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point5);
                fArray[3] = point5.getY();
                PathSegment pathSegment4 = new PathSegment(PathSegment.Type.Line, fArray, 0.0f);
                pathSegment = pathSegment4;
                break;
            }
            case 3: {
                float[] fArray = new float[6];
                Point point = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point6 = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point6);
                fArray[1] = point6.getY();
                Point point7 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point7);
                fArray[2] = point7.getX();
                Point point8 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point8);
                fArray[3] = point8.getY();
                Point point9 = pathSegment2.getP2();
                Intrinsics.checkNotNull((Object)point9);
                fArray[4] = point9.getX();
                Point point10 = pathSegment2.getP2();
                Intrinsics.checkNotNull((Object)point10);
                fArray[5] = point10.getY();
                PathSegment pathSegment5 = new PathSegment(PathSegment.Type.Quadratic, fArray, 0.0f);
                pathSegment = pathSegment5;
                break;
            }
            case 4: {
                float[] fArray = new float[6];
                Point point = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point11 = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point11);
                fArray[1] = point11.getY();
                Point point12 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point12);
                fArray[2] = point12.getX();
                Point point13 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point13);
                fArray[3] = point13.getY();
                Point point14 = pathSegment2.getP2();
                Intrinsics.checkNotNull((Object)point14);
                fArray[4] = point14.getX();
                Point point15 = pathSegment2.getP2();
                Intrinsics.checkNotNull((Object)point15);
                fArray[5] = point15.getY();
                PathSegment pathSegment6 = new PathSegment(PathSegment.Type.Quadratic, fArray, pathSegment2.getConicWeight());
                pathSegment = pathSegment6;
                break;
            }
            case 5: {
                float[] fArray = new float[8];
                Point point = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point16 = pathSegment2.getP0();
                Intrinsics.checkNotNull((Object)point16);
                fArray[1] = point16.getY();
                Point point17 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point17);
                fArray[2] = point17.getX();
                Point point18 = pathSegment2.getP1();
                Intrinsics.checkNotNull((Object)point18);
                fArray[3] = point18.getY();
                Point point19 = pathSegment2.getP2();
                Intrinsics.checkNotNull((Object)point19);
                fArray[4] = point19.getX();
                Point point20 = pathSegment2.getP2();
                Intrinsics.checkNotNull((Object)point20);
                fArray[5] = point20.getY();
                Point point21 = pathSegment2.getP3();
                Intrinsics.checkNotNull((Object)point21);
                fArray[6] = point21.getX();
                Point point22 = pathSegment2.getP3();
                Intrinsics.checkNotNull((Object)point22);
                fArray[7] = point22.getY();
                PathSegment pathSegment7 = new PathSegment(PathSegment.Type.Cubic, fArray, 0.0f);
                pathSegment = pathSegment7;
                break;
            }
            case 6: {
                pathSegment = PathSegmentKt.getCloseSegment();
                break;
            }
            case 7: {
                pathSegment = PathSegmentKt.getDoneSegment();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pathSegment;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathVerb.values().length];
            try {
                nArray[PathVerb.MOVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.QUAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.CONIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.CUBIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.CLOSE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.DONE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

