/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.DoubleFunction;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 _2\u00020\u0001:\u0001_B]\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014BE\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0018B]\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0019B%\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u001bB-\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u001cB1\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u001dB%\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0013\u0010\u001fB-\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0013\u0010 BA\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010!B!\b\u0010\u0012\u0006\u0010\"\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010#J\b\u0010=\u001a\u00020\u0005H\u0007J\b\u0010>\u001a\u00020\u0005H\u0007J\b\u0010?\u001a\u00020\u0005H\u0007J\u0012\u0010=\u001a\u00020\u00052\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007J\u0012\u0010>\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\u0005H\u0007J\u0012\u0010?\u001a\u00020\u00052\b\b\u0001\u0010+\u001a\u00020\u0005H\u0007J\u0010\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0012H\u0016J\u0010\u0010B\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0012H\u0016J \u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rH\u0007J\u0012\u0010C\u001a\u00020\u00052\b\b\u0001\u0010G\u001a\u00020\u0005H\u0007J \u0010H\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rH\u0007J\u0012\u0010H\u001a\u00020\u00052\b\b\u0001\u0010G\u001a\u00020\u0005H\u0007J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J%\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bOJ%\u0010P\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bQJ7\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\r2\u0006\u0010U\u001a\u00020\r2\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0001H\u0010\u00a2\u0006\u0004\bX\u0010YJ\u0010\u0010Z\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0013\u0010[\u001a\u00020:2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0096\u0002J\b\u0010^\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0014\u0010+\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u0014\u0010-\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u0014\u00104\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010/R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00101R\u0014\u00107\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010/R\u0014\u00109\u001a\u00020:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010;R\u0014\u0010<\u001a\u00020:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010;\u00a8\u0006`"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "name", "", "primaries", "", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "transform", "oetf", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "eotf", "min", "", "max", "transferParameters", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "id", "", "<init>", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;[FLandroidx/compose/ui/graphics/colorspace/DoubleFunction;Landroidx/compose/ui/graphics/colorspace/DoubleFunction;FFLandroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "toXYZ", "Lkotlin/Function1;", "", "(Ljava/lang/String;[FLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;FF)V", "function", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/TransferParameters;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/TransferParameters;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "gamma", "(Ljava/lang/String;[FD)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;D)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;DFFI)V", "colorSpace", "(Landroidx/compose/ui/graphics/colorspace/Rgb;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;)V", "getWhitePoint", "()Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "getTransferParameters", "()Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "getPrimaries$ui_graphics", "()[F", "getTransform$ui_graphics", "inverseTransform", "getInverseTransform$ui_graphics", "oetfOrig", "getOetfOrig$ui_graphics", "()Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "getOetf", "()Lkotlin/jvm/functions/Function1;", "oetfFunc", "getOetfFunc$ui_graphics", "eotfOrig", "getEotfOrig$ui_graphics", "getEotf", "eotfFunc", "getEotfFunc$ui_graphics", "isWideGamut", "", "()Z", "isSrgb", "getPrimaries", "getTransform", "getInverseTransform", "getMinValue", "component", "getMaxValue", "toLinear", "r", "g", "b", "v", "fromLinear", "toXyz", "toXy", "", "v0", "v1", "v2", "toXy$ui_graphics", "toZ", "toZ$ui_graphics", "xyzaToColor", "Landroidx/compose/ui/graphics/Color;", "x", "y", "z", "a", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "fromXyz", "equals", "other", "", "hashCode", "Companion", "ui-graphics"})
public final class Rgb
extends ColorSpace {
    public static final Companion Companion = new Companion(null);
    private final WhitePoint whitePoint;
    private final float min;
    private final float max;
    private final TransferParameters transferParameters;
    private final float[] primaries;
    private final float[] transform;
    private final float[] inverseTransform;
    private final DoubleFunction oetfOrig;
    private final Function1<Double, Double> oetf;
    private final DoubleFunction oetfFunc;
    private final DoubleFunction eotfOrig;
    private final Function1<Double, Double> eotf;
    private final DoubleFunction eotfFunc;
    private final boolean isWideGamut;
    private final boolean isSrgb;
    private static final DoubleFunction DoubleIdentity = Rgb::DoubleIdentity$lambda$10;

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, float[] fArray2, DoubleFunction doubleFunction, DoubleFunction doubleFunction2, float f, float f2, TransferParameters transferParameters, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter((Object)doubleFunction, (String)"");
        Intrinsics.checkNotNullParameter((Object)doubleFunction2, (String)"");
        super(string, ColorModel.Companion.getRgb-xdoWZVw(), n, null);
        this.whitePoint = whitePoint;
        this.min = f;
        this.max = f2;
        this.transferParameters = transferParameters;
        this.oetfOrig = doubleFunction;
        this.oetf = arg_0 -> Rgb.oetf$lambda$0(this, arg_0);
        this.oetfFunc = arg_0 -> Rgb.oetfFunc$lambda$1(this, arg_0);
        this.eotfOrig = doubleFunction2;
        this.eotf = arg_0 -> Rgb.eotf$lambda$2(this, arg_0);
        this.eotfFunc = arg_0 -> Rgb.eotfFunc$lambda$3(this, arg_0);
        if (fArray.length != 6 && fArray.length != 9) {
            throw new IllegalArgumentException("The color space's primaries must be defined as an array of 6 floats in xyY or 9 floats in XYZ");
        }
        if (this.min >= this.max) {
            throw new IllegalArgumentException("Invalid range: min=" + this.min + ", max=" + this.max + "; min must be strictly < max");
        }
        this.primaries = Rgb.Companion.xyPrimaries(fArray);
        if (fArray2 == null) {
            this.transform = Rgb.Companion.computeXYZMatrix(this.primaries, this.whitePoint);
        } else {
            if (fArray2.length != 9) {
                throw new IllegalArgumentException("Transform must have 9 entries! Has " + fArray2.length);
            }
            this.transform = fArray2;
        }
        this.inverseTransform = ColorSpaceKt.inverse3x3(this.transform);
        this.isWideGamut = Rgb.Companion.isWideGamut(this.primaries, this.min, this.max);
        this.isSrgb = Rgb.Companion.isSrgb(this.primaries, this.whitePoint, doubleFunction, doubleFunction2, this.min, this.max, n);
    }

    public final WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    public final TransferParameters getTransferParameters() {
        return this.transferParameters;
    }

    public final float[] getPrimaries$ui_graphics() {
        return this.primaries;
    }

    public final float[] getTransform$ui_graphics() {
        return this.transform;
    }

    public final float[] getInverseTransform$ui_graphics() {
        return this.inverseTransform;
    }

    public final DoubleFunction getOetfOrig$ui_graphics() {
        return this.oetfOrig;
    }

    public final Function1<Double, Double> getOetf() {
        return this.oetf;
    }

    public final DoubleFunction getOetfFunc$ui_graphics() {
        return this.oetfFunc;
    }

    public final DoubleFunction getEotfOrig$ui_graphics() {
        return this.eotfOrig;
    }

    public final Function1<Double, Double> getEotf() {
        return this.eotf;
    }

    public final DoubleFunction getEotfFunc$ui_graphics() {
        return this.eotfFunc;
    }

    @Override
    public boolean isWideGamut() {
        return this.isWideGamut;
    }

    @Override
    public boolean isSrgb() {
        return this.isSrgb;
    }

    public final float[] getPrimaries() {
        float[] fArray = Arrays.copyOf(this.primaries, this.primaries.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        return fArray;
    }

    public final float[] getTransform() {
        float[] fArray = Arrays.copyOf(this.transform, this.transform.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        return fArray;
    }

    public final float[] getInverseTransform() {
        float[] fArray = Arrays.copyOf(this.inverseTransform, this.inverseTransform.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        return fArray;
    }

    public Rgb(String string, float[] fArray, Function1<? super Double, Double> function1, Function1<? super Double, Double> function12) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function12, (String)"");
        this(string, Companion.computePrimaries$ui_graphics(fArray), Rgb.Companion.computeWhitePoint(fArray), null, arg_0 -> Rgb._init_$lambda$4(function1, arg_0), arg_0 -> Rgb._init_$lambda$5(function12, arg_0), 0.0f, 1.0f, null, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, Function1<? super Double, Double> function1, Function1<? super Double, Double> function12, float f, float f2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function12, (String)"");
        this(string, fArray, whitePoint, null, arg_0 -> Rgb._init_$lambda$6(function1, arg_0), arg_0 -> Rgb._init_$lambda$7(function12, arg_0), f, f2, null, -1);
    }

    public Rgb(String string, float[] fArray, TransferParameters transferParameters) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)transferParameters, (String)"");
        this(string, Companion.computePrimaries$ui_graphics(fArray), Rgb.Companion.computeWhitePoint(fArray), transferParameters, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, TransferParameters transferParameters) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter((Object)transferParameters, (String)"");
        this(string, fArray, whitePoint, transferParameters, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, TransferParameters transferParameters, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter((Object)transferParameters, (String)"");
        this(string, fArray, whitePoint, null, Rgb.Companion.generateOetf(transferParameters), Rgb.Companion.generateEotf(transferParameters), 0.0f, 1.0f, transferParameters, n);
    }

    public Rgb(String string, float[] fArray, double d) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        this(string, Companion.computePrimaries$ui_graphics(fArray), Rgb.Companion.computeWhitePoint(fArray), d, 0.0f, 1.0f, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, double d) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        this(string, fArray, whitePoint, d, 0.0f, 1.0f, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, double d, float f, float f2, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        this(string, fArray, whitePoint, null, d == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$8(d, arg_0), d == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$9(d, arg_0), f, f2, new TransferParameters(d, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 96, null), n);
    }

    public Rgb(Rgb rgb, float[] fArray, WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        this(rgb.getName(), rgb.primaries, whitePoint, fArray, rgb.oetfOrig, rgb.eotfOrig, rgb.min, rgb.max, rgb.transferParameters, -1);
    }

    public final float[] getPrimaries(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return ArraysKt.copyInto$default((float[])this.primaries, (float[])fArray, (int)0, (int)0, (int)0, (int)14, null);
    }

    public final float[] getTransform(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return ArraysKt.copyInto$default((float[])this.transform, (float[])fArray, (int)0, (int)0, (int)0, (int)14, null);
    }

    public final float[] getInverseTransform(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return ArraysKt.copyInto$default((float[])this.inverseTransform, (float[])fArray, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Override
    public float getMinValue(int n) {
        return this.min;
    }

    @Override
    public float getMaxValue(int n) {
        return this.max;
    }

    public final float[] toLinear(float f, float f2, float f3) {
        float[] fArray = new float[]{f, f2, f3};
        return this.toLinear(fArray);
    }

    public final float[] toLinear(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.eotfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.eotfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.eotfFunc.invoke(fArray[2]);
        return fArray;
    }

    public final float[] fromLinear(float f, float f2, float f3) {
        float[] fArray = new float[]{f, f2, f3};
        return this.fromLinear(fArray);
    }

    public final float[] fromLinear(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.oetfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.oetfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.oetfFunc.invoke(fArray[2]);
        return fArray;
    }

    @Override
    public float[] toXyz(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.eotfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.eotfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.eotfFunc.invoke(fArray[2]);
        return ColorSpaceKt.mul3x3Float3(this.transform, fArray);
    }

    @Override
    public long toXy$ui_graphics(float f, float f2, float f3) {
        float f4 = (float)this.eotfFunc.invoke(f);
        float f5 = (float)this.eotfFunc.invoke(f2);
        float f6 = (float)this.eotfFunc.invoke(f3);
        if (this.transform.length < 9) {
            return 0L;
        }
        float[] fArray = this.transform;
        boolean bl = false;
        float f7 = fArray[0] * f4 + fArray[3] * f5 + fArray[6] * f6;
        float[] fArray2 = this.transform;
        boolean bl2 = false;
        float f8 = fArray2[1] * f4 + fArray2[4] * f5 + fArray2[7] * f6;
        boolean bl3 = false;
        long l = Float.floatToRawIntBits(f7);
        long l2 = Float.floatToRawIntBits(f8);
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    @Override
    public float toZ$ui_graphics(float f, float f2, float f3) {
        float f4 = (float)this.eotfFunc.invoke(f);
        float f5 = (float)this.eotfFunc.invoke(f2);
        float f6 = (float)this.eotfFunc.invoke(f3);
        float[] fArray = this.transform;
        boolean bl = false;
        float f7 = fArray[2] * f4 + fArray[5] * f5 + fArray[8] * f6;
        return f7;
    }

    @Override
    public long xyzaToColor-JlNiLsg$ui_graphics(float f, float f2, float f3, float f4, ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"");
        float[] fArray = this.inverseTransform;
        boolean bl = false;
        float f5 = fArray[0] * f + fArray[3] * f2 + fArray[6] * f3;
        float[] fArray2 = this.inverseTransform;
        boolean bl2 = false;
        float f6 = fArray2[1] * f + fArray2[4] * f2 + fArray2[7] * f3;
        float[] fArray3 = this.inverseTransform;
        boolean bl3 = false;
        float f7 = fArray3[2] * f + fArray3[5] * f2 + fArray3[8] * f3;
        f5 = (float)this.oetfFunc.invoke(f5);
        f6 = (float)this.oetfFunc.invoke(f6);
        f7 = (float)this.oetfFunc.invoke(f7);
        return ColorKt.Color(f5, f6, f7, f4, colorSpace);
    }

    @Override
    public float[] fromXyz(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        ColorSpaceKt.mul3x3Float3(this.inverseTransform, fArray);
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.oetfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.oetfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.oetfFunc.invoke(fArray[2]);
        return fArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Rgb rgb = (Rgb)object;
        if (Float.compare(rgb.min, this.min) != 0) {
            return false;
        }
        if (Float.compare(rgb.max, this.max) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.whitePoint, (Object)rgb.whitePoint)) {
            return false;
        }
        if (!Arrays.equals(this.primaries, rgb.primaries)) {
            return false;
        }
        if (this.transferParameters != null) {
            return Intrinsics.areEqual((Object)this.transferParameters, (Object)rgb.transferParameters);
        }
        if (rgb.transferParameters == null) {
            return true;
        }
        return !Intrinsics.areEqual((Object)this.oetfOrig, (Object)rgb.oetfOrig) ? false : Intrinsics.areEqual((Object)this.eotfOrig, (Object)rgb.eotfOrig);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.whitePoint.hashCode();
        n = 31 * n + Arrays.hashCode(this.primaries);
        n = 31 * n + (!(this.min == 0.0f) ? Float.floatToIntBits(this.min) : 0);
        n = 31 * n + (!(this.max == 0.0f) ? Float.floatToIntBits(this.max) : 0);
        TransferParameters transferParameters = this.transferParameters;
        n = 31 * n + (transferParameters != null ? transferParameters.hashCode() : 0);
        if (this.transferParameters == null) {
            n = 31 * n + this.oetfOrig.hashCode();
            n = 31 * n + this.eotfOrig.hashCode();
        }
        return n;
    }

    private static final double oetf$lambda$0(Rgb rgb, double d) {
        return RangesKt.coerceIn((double)rgb.oetfOrig.invoke(d), (double)rgb.min, (double)rgb.max);
    }

    private static final double oetfFunc$lambda$1(Rgb rgb, double d) {
        return RangesKt.coerceIn((double)rgb.oetfOrig.invoke(d), (double)rgb.min, (double)rgb.max);
    }

    private static final double eotf$lambda$2(Rgb rgb, double d) {
        return rgb.eotfOrig.invoke(RangesKt.coerceIn((double)d, (double)rgb.min, (double)rgb.max));
    }

    private static final double eotfFunc$lambda$3(Rgb rgb, double d) {
        return rgb.eotfOrig.invoke(RangesKt.coerceIn((double)d, (double)rgb.min, (double)rgb.max));
    }

    private static final double _init_$lambda$4(Function1 function1, double d) {
        return ((Number)function1.invoke((Object)d)).doubleValue();
    }

    private static final double _init_$lambda$5(Function1 function1, double d) {
        return ((Number)function1.invoke((Object)d)).doubleValue();
    }

    private static final double _init_$lambda$6(Function1 function1, double d) {
        return ((Number)function1.invoke((Object)d)).doubleValue();
    }

    private static final double _init_$lambda$7(Function1 function1, double d) {
        return ((Number)function1.invoke((Object)d)).doubleValue();
    }

    private static final double _init_$lambda$8(double d, double d2) {
        return Math.pow(d2 < 0.0 ? 0.0 : d2, 1.0 / d);
    }

    private static final double _init_$lambda$9(double d, double d2) {
        return Math.pow(d2 < 0.0 ? 0.0 : d2, d);
    }

    private static final double DoubleIdentity$lambda$10(double d) {
        return d;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J)\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0082\bJ\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb$Companion;", "", "<init>", "()V", "DoubleIdentity", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "isSrgb", "", "primaries", "", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "OETF", "EOTF", "min", "", "max", "id", "", "compare", "point", "", "a", "b", "isWideGamut", "area", "cross", "ax", "ay", "bx", "by", "contains", "p1", "p2", "computePrimaries", "toXYZ", "computePrimaries$ui_graphics", "computeWhitePoint", "xyPrimaries", "computeXYZMatrix", "generateOetf", "function", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "generateEotf", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSrgb(float[] fArray, WhitePoint whitePoint, DoubleFunction doubleFunction, DoubleFunction doubleFunction2, float f, float f2, int n) {
            if (n == 0) {
                return true;
            }
            if (!ColorSpaceKt.compare(fArray, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics())) {
                return false;
            }
            if (!ColorSpaceKt.compare(whitePoint, Illuminant.INSTANCE.getD65())) {
                return false;
            }
            if (!(f == 0.0f)) {
                return false;
            }
            if (!(f2 == 1.0f)) {
                return false;
            }
            Rgb rgb = ColorSpaces.INSTANCE.getSrgb();
            for (double d = 0.0; d <= 1.0; d += 0.00392156862745098) {
                if (!this.compare(d, doubleFunction, rgb.getOetfOrig$ui_graphics())) {
                    return false;
                }
                if (this.compare(d, doubleFunction2, rgb.getEotfOrig$ui_graphics())) continue;
                return false;
            }
            return true;
        }

        private final boolean compare(double d, DoubleFunction doubleFunction, DoubleFunction doubleFunction2) {
            double d2;
            double d3 = doubleFunction.invoke(d);
            return Math.abs(d3 - (d2 = doubleFunction2.invoke(d))) <= 0.001;
        }

        private final boolean isWideGamut(float[] fArray, float f, float f2) {
            return this.area(fArray) / this.area(ColorSpaces.INSTANCE.getNtsc1953Primaries$ui_graphics()) > 0.9f && this.contains(fArray, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics()) || f < 0.0f && f2 > 1.0f;
        }

        private final float area(float[] fArray) {
            if (fArray.length < 6) {
                return 0.0f;
            }
            float f = fArray[0];
            float f2 = fArray[3];
            float f3 = fArray[1];
            float f4 = fArray[4];
            float f5 = fArray[2];
            float f6 = fArray[5];
            float f7 = f * f2 + f3 * f4 + f5 * f6 - f2 * f4 - f3 * f5 - f * f6;
            float f8 = 0.5f * f7;
            return f8 < 0.0f ? -f8 : f8;
        }

        private final float cross(float f, float f2, float f3, float f4) {
            boolean bl = false;
            return f * f4 - f2 * f3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean contains(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[]{fArray[0] - fArray2[0], fArray[1] - fArray2[1], fArray[2] - fArray2[2], fArray[3] - fArray2[3], fArray[4] - fArray2[4], fArray[5] - fArray2[5]};
            float[] fArray4 = fArray3;
            Companion companion = this;
            float f = fArray4[0];
            float f2 = fArray4[1];
            float f3 = fArray2[0] - fArray2[4];
            float f4 = fArray2[1] - fArray2[5];
            boolean bl = false;
            if (f * f4 - f2 * f3 < 0.0f) return false;
            Companion companion2 = this;
            f = fArray2[0] - fArray2[2];
            f2 = fArray2[1] - fArray2[3];
            f3 = fArray4[0];
            f4 = fArray4[1];
            bl = false;
            if (f * f4 - f2 * f3 < 0.0f) {
                return false;
            }
            Companion companion3 = this;
            f = fArray4[2];
            f2 = fArray4[3];
            f3 = fArray2[2] - fArray2[0];
            f4 = fArray2[3] - fArray2[1];
            bl = false;
            if (f * f4 - f2 * f3 < 0.0f) return false;
            Companion companion4 = this;
            f = fArray2[2] - fArray2[4];
            f2 = fArray2[3] - fArray2[5];
            f3 = fArray4[2];
            f4 = fArray4[3];
            bl = false;
            if (f * f4 - f2 * f3 < 0.0f) {
                return false;
            }
            Companion companion5 = this;
            f = fArray4[4];
            f2 = fArray4[5];
            f3 = fArray2[4] - fArray2[2];
            f4 = fArray2[5] - fArray2[3];
            bl = false;
            if (f * f4 - f2 * f3 < 0.0f) return false;
            Companion companion6 = this;
            f = fArray2[4] - fArray2[0];
            f2 = fArray2[5] - fArray2[1];
            f3 = fArray4[4];
            f4 = fArray4[5];
            bl = false;
            if (f * f4 - f2 * f3 < 0.0f) return false;
            return true;
        }

        public final float[] computePrimaries$ui_graphics(float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
            float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f};
            float[] fArray3 = ColorSpaceKt.mul3x3Float3(fArray, fArray2);
            float[] fArray4 = new float[]{0.0f, 1.0f, 0.0f};
            fArray2 = ColorSpaceKt.mul3x3Float3(fArray, fArray4);
            float[] fArray5 = new float[]{0.0f, 0.0f, 1.0f};
            fArray4 = ColorSpaceKt.mul3x3Float3(fArray, fArray5);
            float f = fArray3[0] + fArray3[1] + fArray3[2];
            float f2 = fArray2[0] + fArray2[1] + fArray2[2];
            float f3 = fArray4[0] + fArray4[1] + fArray4[2];
            float[] fArray6 = new float[]{fArray3[0] / f, fArray3[1] / f, fArray2[0] / f2, fArray2[1] / f2, fArray4[0] / f3, fArray4[1] / f3};
            return fArray6;
        }

        private final WhitePoint computeWhitePoint(float[] fArray) {
            float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f};
            float[] fArray3 = ColorSpaceKt.mul3x3Float3(fArray, fArray2);
            float f = fArray3[0] + fArray3[1] + fArray3[2];
            return new WhitePoint(fArray3[0] / f, fArray3[1] / f);
        }

        private final float[] xyPrimaries(float[] fArray) {
            float[] fArray2 = new float[6];
            if (fArray.length == 9) {
                float f = fArray[0] + fArray[1] + fArray[2];
                fArray2[0] = fArray[0] / f;
                fArray2[1] = fArray[1] / f;
                f = fArray[3] + fArray[4] + fArray[5];
                fArray2[2] = fArray[3] / f;
                fArray2[3] = fArray[4] / f;
                f = fArray[6] + fArray[7] + fArray[8];
                fArray2[4] = fArray[6] / f;
                fArray2[5] = fArray[7] / f;
            } else {
                ArraysKt.copyInto$default((float[])fArray, (float[])fArray2, (int)0, (int)0, (int)6, (int)6, null);
            }
            return fArray2;
        }

        private final float[] computeXYZMatrix(float[] fArray, WhitePoint whitePoint) {
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray[3];
            float f5 = fArray[4];
            float f6 = fArray[5];
            float f7 = whitePoint.getX();
            float f8 = whitePoint.getY();
            float f9 = (1.0f - f) / f2;
            float f10 = (1.0f - f3) / f4;
            float f11 = (1.0f - f5) / f6;
            float f12 = (1.0f - f7) / f8;
            float f13 = f / f2;
            float f14 = f3 / f4;
            float f15 = f5 / f6;
            float f16 = f7 / f8;
            float f17 = (f12 - f9) * (f14 - f13) - (f16 - f13) * (f10 - f9);
            float f18 = (f11 - f9) * (f14 - f13) - (f15 - f13) * (f10 - f9);
            float f19 = f17 / f18;
            float f20 = (f16 - f13 - f19 * (f15 - f13)) / (f14 - f13);
            float f21 = 1.0f - f20 - f19;
            float f22 = f21 / f2;
            float f23 = f20 / f4;
            float f24 = f19 / f6;
            float[] fArray2 = new float[]{f22 * f, f21, f22 * (1.0f - f - f2), f23 * f3, f20, f23 * (1.0f - f3 - f4), f24 * f5, f19, f24 * (1.0f - f5 - f6)};
            return fArray2;
        }

        private final DoubleFunction generateOetf(TransferParameters transferParameters) {
            return transferParameters.isHLGish$ui_graphics() ? arg_0 -> Companion.generateOetf$lambda$0(transferParameters, arg_0) : (transferParameters.isPQish$ui_graphics() ? arg_0 -> Companion.generateOetf$lambda$1(transferParameters, arg_0) : (transferParameters.getE() == 0.0 && transferParameters.getF() == 0.0 ? arg_0 -> Companion.generateOetf$lambda$2(transferParameters, arg_0) : arg_0 -> Companion.generateOetf$lambda$3(transferParameters, arg_0)));
        }

        private final DoubleFunction generateEotf(TransferParameters transferParameters) {
            return transferParameters.isHLGish$ui_graphics() ? arg_0 -> Companion.generateEotf$lambda$4(transferParameters, arg_0) : (transferParameters.isPQish$ui_graphics() ? arg_0 -> Companion.generateEotf$lambda$5(transferParameters, arg_0) : (transferParameters.getE() == 0.0 && transferParameters.getF() == 0.0 ? arg_0 -> Companion.generateEotf$lambda$6(transferParameters, arg_0) : arg_0 -> Companion.generateEotf$lambda$7(transferParameters, arg_0)));
        }

        private static final double generateOetf$lambda$0(TransferParameters transferParameters, double d) {
            return ColorSpaces.INSTANCE.transferHlgOetf$ui_graphics(transferParameters, d);
        }

        private static final double generateOetf$lambda$1(TransferParameters transferParameters, double d) {
            return ColorSpaces.INSTANCE.transferSt2048Oetf$ui_graphics(transferParameters, d);
        }

        private static final double generateOetf$lambda$2(TransferParameters transferParameters, double d) {
            return ColorSpaceKt.rcpResponse(d, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getGamma());
        }

        private static final double generateOetf$lambda$3(TransferParameters transferParameters, double d) {
            return ColorSpaceKt.rcpResponse(d, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getE(), transferParameters.getF(), transferParameters.getGamma());
        }

        private static final double generateEotf$lambda$4(TransferParameters transferParameters, double d) {
            return ColorSpaces.INSTANCE.transferHlgEotf$ui_graphics(transferParameters, d);
        }

        private static final double generateEotf$lambda$5(TransferParameters transferParameters, double d) {
            return ColorSpaces.INSTANCE.transferSt2048Eotf$ui_graphics(transferParameters, d);
        }

        private static final double generateEotf$lambda$6(TransferParameters transferParameters, double d) {
            return ColorSpaceKt.response(d, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getGamma());
        }

        private static final double generateEotf$lambda$7(TransferParameters transferParameters, double d) {
            return ColorSpaceKt.response(d, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getE(), transferParameters.getF(), transferParameters.getGamma());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

