/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.shadow;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.BrushKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.CompositeShaderBrush;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapConfig;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.ShaderKt;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.shadow.BlurKt;
import androidx.compose.ui.graphics.shadow.Blur_skikoKt;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.graphics.shadow.ShadowRenderer;
import androidx.compose.ui.unit.DpOffset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.MaskFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002JQ\u0010\"\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010'\u001a\u00020(H\u0014\u00a2\u0006\u0004\b)\u0010*J?\u0010+\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020$H\u0002\u00a2\u0006\u0004\b0\u00101J?\u00102\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b3\u00104R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u00065"}, d2={"Landroidx/compose/ui/graphics/shadow/InnerShadowRenderer;", "Landroidx/compose/ui/graphics/shadow/ShadowRenderer;", "shadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "outline", "Landroidx/compose/ui/graphics/Outline;", "<init>", "(Landroidx/compose/ui/graphics/shadow/Shadow;Landroidx/compose/ui/graphics/Outline;)V", "paint", "Landroidx/compose/ui/graphics/Paint;", "shadowMask", "Landroidx/compose/ui/graphics/ShaderBrush;", "compositeShader", "Landroidx/compose/ui/graphics/CompositeShaderBrush;", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "obtainMatrix", "obtainMatrix-sQKQjiQ", "()[F", "buildShadow", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "size", "Landroidx/compose/ui/geometry/Size;", "cornerRadius", "Landroidx/compose/ui/geometry/CornerRadius;", "path", "Landroidx/compose/ui/graphics/Path;", "buildShadow-_SMYjrA", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;)V", "obtainCompositeBrush", "brush", "Landroidx/compose/ui/graphics/Brush;", "onDrawShadow", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "onDrawShadow-MLmccfk", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;FLandroidx/compose/ui/graphics/ColorFilter;Landroidx/compose/ui/graphics/Brush;I)V", "createInnerPathShadowBrush", "radius", "spread", "offsetX", "offsetY", "createInnerPathShadowBrush-LjSzlW0", "(JLandroidx/compose/ui/graphics/Path;FFFF)Landroidx/compose/ui/graphics/ShaderBrush;", "createInnerShadowBrush", "createInnerShadowBrush-u1Psq-8", "(JFFFFJ)Landroidx/compose/ui/graphics/ShaderBrush;", "ui-graphics"})
public final class InnerShadowRenderer
extends ShadowRenderer {
    private final Shadow shadow;
    private final Paint paint;
    private ShaderBrush shadowMask;
    private CompositeShaderBrush compositeShader;
    private float[] matrix;

    public InnerShadowRenderer(Shadow shadow, Outline outline) {
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"");
        Intrinsics.checkNotNullParameter((Object)outline, (String)"");
        super(outline);
        this.shadow = shadow;
        this.paint = SkiaBackedPaint_skikoKt.Paint();
    }

    private final float[] obtainMatrix-sQKQjiQ() {
        float[] fArray = this.matrix;
        if (this.matrix == null) {
            float[] fArray2;
            float[] fArray3 = fArray2 = Matrix.constructor-impl$default(null, 1, null);
            boolean bl = false;
            this.matrix = fArray3;
            fArray = fArray2;
        }
        return fArray;
    }

    @Override
    protected void buildShadow-_SMYjrA(DrawScope drawScope, long l, long l2, Path path) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
        float f = drawScope.toPx-0680j_4(this.shadow.getRadius-D9Ej5fM());
        float f2 = drawScope.toPx-0680j_4(this.shadow.getSpread-D9Ej5fM());
        float f3 = drawScope.toPx-0680j_4(DpOffset.getX-D9Ej5fM((long)this.shadow.getOffset-RKDOV3M()));
        float f4 = drawScope.toPx-0680j_4(DpOffset.getY-D9Ej5fM((long)this.shadow.getOffset-RKDOV3M()));
        this.shadowMask = path != null ? this.createInnerPathShadowBrush-LjSzlW0(l, path, f, f2, f3, f4) : this.createInnerShadowBrush-u1Psq-8(l, f, f2, f3, f4, l2);
    }

    private final CompositeShaderBrush obtainCompositeBrush(ShaderBrush shaderBrush, Brush brush) {
        CompositeShaderBrush compositeShaderBrush = this.compositeShader;
        if (compositeShaderBrush == null || !Intrinsics.areEqual((Object)compositeShaderBrush.getSrcBrush(), (Object)brush)) {
            CompositeShaderBrush compositeShaderBrush2;
            CompositeShaderBrush compositeShaderBrush3 = compositeShaderBrush2 = new CompositeShaderBrush(BrushKt.toShaderBrush(shaderBrush), BrushKt.toShaderBrush(brush), BlendMode.Companion.getSrcIn-0nO6VwU(), null);
            boolean bl = false;
            this.compositeShader = compositeShaderBrush3;
            compositeShaderBrush = compositeShaderBrush2;
        }
        return compositeShaderBrush;
    }

    @Override
    protected void onDrawShadow-MLmccfk(DrawScope drawScope, long l, long l2, Path path, float f, ColorFilter colorFilter, Brush brush, int n) {
        block4: {
            ShaderBrush shaderBrush;
            Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
            ShaderBrush shaderBrush2 = this.shadowMask;
            if (shaderBrush2 == null) break block4;
            ShaderBrush shaderBrush3 = shaderBrush2;
            boolean bl = false;
            ShaderBrush shaderBrush4 = shaderBrush = this.shadow.getBrush() instanceof ShaderBrush ? (ShaderBrush)this.obtainCompositeBrush(shaderBrush3, this.shadow.getBrush()) : shaderBrush3;
            if (path != null) {
                DrawScope.drawPath-GBMwjPU$default(drawScope, path, shaderBrush, f, null, colorFilter, n, 8, null);
            } else if (CornerRadius.equals-impl0((long)l2, (long)CornerRadius.Companion.getZero-kKHJgLs())) {
                DrawScope.drawRect-AsUm42w$default(drawScope, shaderBrush, 0L, 0L, f, null, colorFilter, n, 22, null);
            } else {
                int n2 = this.shadow.getBlendMode-0nO6VwU();
                DrawScope.drawRoundRect-ZuiqVtQ$default(drawScope, shaderBrush, 0L, 0L, l2, f, null, colorFilter, n2, 38, null);
            }
        }
    }

    private final ShaderBrush createInnerPathShadowBrush-LjSzlW0(long l, Path path, float f, float f2, float f3, float f4) {
        Canvas canvas;
        ImageBitmap imageBitmap = null;
        int n = 0;
        long l2 = l;
        boolean bl = false;
        int n2 = (int)(l2 >> 32);
        int n3 = 0;
        int n4 = (int)Math.ceil(Float.intBitsToFloat(n2));
        boolean bl2 = false;
        long l3 = l;
        n2 = 0;
        n3 = (int)(l3 & 0xFFFFFFFFL);
        boolean bl3 = false;
        n = (int)Math.ceil(Float.intBitsToFloat(n3));
        if (f2 > 0.0f) {
            Rect rect;
            Rect rect2 = rect = path.getBounds();
            n2 = 0;
            float f5 = rect2.getRight() - rect2.getLeft();
            Object object = rect;
            n3 = 0;
            float f6 = object.getBottom() - object.getTop();
            imageBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default((int)Math.ceil(f5), (int)Math.ceil(f6), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
            Object object2 = object = CanvasKt.Canvas(imageBitmap);
            bl3 = false;
            object2.drawPath(path, this.paint);
            Canvas.clipRect-N_I0leg$default((Canvas)object2, 0.0f, 0.0f, f5, f6, 0, 16, null);
            Paint paint = this.paint;
            int n5 = PaintingStyle.Companion.getStroke-TiuSbCo();
            int n6 = BlendMode.Companion.getClear-0nO6VwU();
            Paint paint2 = paint = BlurKt.configureShadow-FoewPVk$default(paint, 0L, n6, null, n5, 5, null);
            Path path2 = path;
            Object object3 = object2;
            n6 = 0;
            paint2.setStrokeWidth(f2 * 2.0f);
            Unit unit = Unit.INSTANCE;
            object3.drawPath(path2, paint);
        } else {
            imageBitmap = null;
        }
        int n7 = (int)Math.ceil(f);
        ImageBitmap imageBitmap2 = ImageBitmapKt.ImageBitmap-x__-hDU$default(n4 + n7 * 2, n + n7 * 2, ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas canvas2 = canvas = CanvasKt.Canvas(imageBitmap2);
        boolean bl4 = false;
        if (imageBitmap != null) {
            canvas2.drawRect(0.0f, 0.0f, imageBitmap2.getWidth(), imageBitmap2.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, null, 0, 15, null));
            bl3 = false;
            boolean bl5 = false;
            long l4 = Float.floatToRawIntBits(f3);
            long l5 = Float.floatToRawIntBits(f4);
            Paint paint = this.paint;
            MaskFilter maskFilter = f > 0.0f ? Blur_skikoKt.BlurFilter(f) : null;
            int n8 = BlendMode.Companion.getXor-0nO6VwU();
            canvas2.drawImage-d-4ec7I(imageBitmap, Offset.constructor-impl((long)(l4 << 32 | l5 & 0xFFFFFFFFL)), BlurKt.configureShadow-FoewPVk$default(paint, 0L, n8, maskFilter, 0, 9, null));
            return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(imageBitmap2, 0, 0, 6, null));
        }
        canvas2.save();
        canvas2.translate(f3, f4);
        canvas2.drawPath(path, BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, f > 0.0f ? Blur_skikoKt.BlurFilter(f) : null, 0, 11, null));
        canvas2.restore();
        canvas2.drawRect(0.0f, 0.0f, imageBitmap2.getWidth(), imageBitmap2.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, BlendMode.Companion.getXor-0nO6VwU(), null, 0, 13, null));
        return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(imageBitmap2, 0, 0, 6, null));
    }

    private final ShaderBrush createInnerShadowBrush-u1Psq-8(long l, float f, float f2, float f3, float f4, long l2) {
        Canvas canvas;
        boolean bl = false;
        long l3 = l;
        boolean bl2 = false;
        int n = (int)(l3 >> 32);
        boolean bl3 = false;
        int n2 = (int)Math.ceil(Float.intBitsToFloat(n));
        bl = false;
        l3 = l;
        bl2 = false;
        n = (int)(l3 & 0xFFFFFFFFL);
        bl3 = false;
        ImageBitmap imageBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(n2, (int)Math.ceil(Float.intBitsToFloat(n)), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas canvas2 = canvas = CanvasKt.Canvas(imageBitmap);
        boolean bl4 = false;
        float f5 = f3 + f2;
        float f6 = f4 + f2;
        bl3 = false;
        long l4 = l;
        boolean bl5 = false;
        int n3 = (int)(l4 >> 32);
        int n4 = 0;
        float f7 = f3 + Float.intBitsToFloat(n3) - f2;
        float f8 = Math.max(f5, f7);
        boolean bl6 = false;
        long l5 = l;
        n3 = 0;
        n4 = (int)(l5 & 0xFFFFFFFFL);
        boolean bl7 = false;
        float f9 = f4 + Float.intBitsToFloat(n4) - f2;
        f7 = Math.max(f6, f9);
        boolean bl8 = false;
        l5 = l2;
        n3 = 0;
        n4 = (int)(l5 >> 32);
        bl7 = false;
        float f10 = Float.intBitsToFloat(n4);
        bl8 = false;
        l5 = l2;
        n3 = 0;
        n4 = (int)(l5 & 0xFFFFFFFFL);
        bl7 = false;
        canvas2.drawRoundRect(f5, f6, f8, f7, f10, Float.intBitsToFloat(n4), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, f > 0.0f ? Blur_skikoKt.BlurFilter(f) : null, 0, 11, null));
        canvas2.drawRect(0.0f, 0.0f, imageBitmap.getWidth(), imageBitmap.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, BlendMode.Companion.getXor-0nO6VwU(), null, 0, 13, null));
        return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(imageBitmap, 0, 0, 6, null));
    }
}

