/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.DropShadowScope;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.graphics.shadow.DropShadowPainter;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.ObserverModifierNode;
import androidx.compose.ui.node.ObserverModifierNodeKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpOffset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B(\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010@\u001a\u00020\tH\u0016J\b\u0010A\u001a\u00020\tH\u0016J\b\u0010B\u001a\u00020\tH\u0002J'\u0010C\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\nJ\f\u0010D\u001a\u00020\t*\u00020EH\u0016J\b\u0010F\u001a\u00020\u0012H\u0002J\b\u0010G\u001a\u00020\tH\u0016J\b\u0010H\u001a\u00020\tH\u0002J\u0013\u0010I\u001a\u00020\u00142\b\u0010J\u001a\u0004\u0018\u00010KH\u0096\u0002J\b\u0010L\u001a\u00020MH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R@\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR$\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010!R&\u0010&\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020%@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R&\u0010-\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020,@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b.\u0010(\"\u0004\b/\u0010*R(\u00101\u001a\u0004\u0018\u0001002\b\u0010\u0015\u001a\u0004\u0018\u000100@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00106\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001b\"\u0004\b8\u0010!R&\u0010:\u001a\u0002092\u0006\u0010\u0015\u001a\u000209@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010?\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006N"}, d2={"Landroidx/compose/ui/draw/BlockDropShadowNode;", "Landroidx/compose/ui/node/DrawModifierNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/ObserverModifierNode;", "Landroidx/compose/ui/draw/DropShadowScope;", "shape", "Landroidx/compose/ui/graphics/Shape;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Landroidx/compose/ui/graphics/Shape;Lkotlin/jvm/functions/Function1;)V", "densityObject", "Landroidx/compose/ui/unit/Density;", "targetShadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "shadowPainter", "Landroidx/compose/ui/graphics/shadow/DropShadowPainter;", "blockRead", "", "value", "setBlock", "(Lkotlin/jvm/functions/Function1;)V", "density", "", "getDensity", "()F", "fontScale", "getFontScale", "radius", "getRadius", "setRadius", "(F)V", "spread", "getSpread", "setSpread", "Landroidx/compose/ui/geometry/Offset;", "offset", "getOffset-F1C5BW0", "()J", "setOffset-k-4lQ0M", "(J)V", "J", "Landroidx/compose/ui/graphics/Color;", "color", "getColor-0d7_KjU", "setColor-8_81llA", "Landroidx/compose/ui/graphics/Brush;", "brush", "getBrush", "()Landroidx/compose/ui/graphics/Brush;", "setBrush", "(Landroidx/compose/ui/graphics/Brush;)V", "alpha", "getAlpha", "setAlpha", "Landroidx/compose/ui/graphics/BlendMode;", "blendMode", "getBlendMode-0nO6VwU", "()I", "setBlendMode-s9anfk8", "(I)V", "I", "onAttach", "onDensityChange", "updateDensity", "update", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "obtainPainter", "onObservedReadsChanged", "invalidateShadow", "equals", "other", "", "hashCode", "", "ui"})
public final class BlockDropShadowNode
extends Modifier.Node
implements DropShadowScope,
DrawModifierNode,
ObserverModifierNode {
    private Shape shape;
    private Density densityObject;
    private Shadow targetShadow;
    private DropShadowPainter shadowPainter;
    private boolean blockRead;
    private Function1<? super DropShadowScope, Unit> block;
    private float radius;
    private float spread;
    private long offset;
    private long color;
    private Brush brush;
    private float alpha;
    private int blendMode;
    public static final int $stable;

    public BlockDropShadowNode(Shape shape, Function1<? super DropShadowScope, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.shape = shape;
        this.block = function1;
        this.offset = Offset.Companion.getZero-F1C5BW0();
        this.color = Color.Companion.getBlack-0d7_KjU();
        this.alpha = 1.0f;
        this.blendMode = BlendMode.Companion.getSrcOver-0nO6VwU();
    }

    private final void setBlock(Function1<? super DropShadowScope, Unit> function1) {
        if (this.block != function1) {
            this.block = function1;
            this.blockRead = false;
            DrawModifierNodeKt.invalidateDraw(this);
        }
    }

    public float getDensity() {
        Density density = this.densityObject;
        return density != null ? density.getDensity() : 1.0f;
    }

    public float getFontScale() {
        Density density = this.densityObject;
        return density != null ? density.getFontScale() : 1.0f;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(float f2) {
        if (!(this.radius == f2)) {
            this.radius = f2;
            this.invalidateShadow();
        }
    }

    @Override
    public float getSpread() {
        return this.spread;
    }

    @Override
    public void setSpread(float f2) {
        if (!(this.spread == f2)) {
            this.spread = f2;
            this.invalidateShadow();
        }
    }

    @Override
    public long getOffset-F1C5BW0() {
        return this.offset;
    }

    @Override
    public void setOffset-k-4lQ0M(long l2) {
        if (!Offset.equals-impl0((long)this.offset, (long)l2)) {
            this.offset = l2;
            DrawModifierNodeKt.invalidateDraw(this);
        }
    }

    @Override
    public long getColor-0d7_KjU() {
        return this.color;
    }

    @Override
    public void setColor-8_81llA(long l2) {
        long l3;
        long l4 = l2;
        boolean bl = false;
        long l5 = l3 = l4 != 16L ? l2 : Color.Companion.getBlack-0d7_KjU();
        if (!Color.equals-impl0((long)this.color, (long)l3)) {
            this.color = l3;
            this.invalidateShadow();
        }
    }

    @Override
    public Brush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(Brush brush) {
        if (!Intrinsics.areEqual((Object)this.brush, (Object)brush)) {
            this.brush = brush;
            this.invalidateShadow();
        }
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float f2) {
        if (!(this.alpha == f2)) {
            this.alpha = f2;
            this.invalidateShadow();
        }
    }

    @Override
    public int getBlendMode-0nO6VwU() {
        return this.blendMode;
    }

    @Override
    public void setBlendMode-s9anfk8(int n) {
        if (!BlendMode.equals-impl0((int)this.blendMode, (int)n)) {
            this.blendMode = n;
            this.invalidateShadow();
        }
    }

    @Override
    public void onAttach() {
        super.onAttach();
        this.updateDensity();
    }

    @Override
    public void onDensityChange() {
        if (this.isAttached()) {
            this.updateDensity();
        }
    }

    private final void updateDensity() {
        Density density = DelegatableNodeKt.requireDensity(this);
        if (!Intrinsics.areEqual((Object)this.densityObject, (Object)density)) {
            this.densityObject = density;
            this.block.invoke((Object)this);
            this.invalidateShadow();
        }
    }

    public final void update(Shape shape, Function1<? super DropShadowScope, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.shape = shape;
        this.setBlock(function1);
    }

    @Override
    public void draw(ContentDrawScope contentDrawScope) {
        Intrinsics.checkNotNullParameter((Object)contentDrawScope, (String)"");
        DropShadowPainter dropShadowPainter = this.obtainPainter();
        boolean bl = false;
        Painter.draw-x_KDEd0$default((Painter)((Painter)dropShadowPainter), (DrawScope)((DrawScope)contentDrawScope), (long)contentDrawScope.getSize-NH-jbRc(), (float)0.0f, null, (int)6, null);
        contentDrawScope.drawContent();
    }

    private final DropShadowPainter obtainPainter() {
        if (!this.blockRead) {
            this.blockRead = true;
            ObserverModifierNodeKt.observeReads((Modifier.Node)this, (Function0<Unit>)((Function0)() -> BlockDropShadowNode.obtainPainter$lambda$1(this)));
        }
        Shadow shadow = this.targetShadow;
        DropShadowPainter dropShadowPainter = this.shadowPainter;
        Brush brush = this.getBrush();
        float f2 = this.toDp-u2uoSUM(this.getRadius());
        float f3 = this.toDp-u2uoSUM(this.getSpread());
        long l2 = this.getOffset-F1C5BW0();
        boolean bl = false;
        long l3 = l2;
        boolean bl2 = false;
        int n = (int)(l3 >> 32);
        int n2 = 0;
        float f4 = this.toDp-u2uoSUM(Float.intBitsToFloat(n));
        long l4 = this.getOffset-F1C5BW0();
        boolean bl3 = false;
        long l5 = l4;
        n = 0;
        n2 = (int)(l5 & 0xFFFFFFFFL);
        boolean bl4 = false;
        float f5 = this.toDp-u2uoSUM(Float.intBitsToFloat(n2));
        bl = false;
        float f6 = f4;
        float f7 = f5;
        bl2 = false;
        long l6 = Float.floatToRawIntBits(f6);
        long l7 = Float.floatToRawIntBits(f7);
        long l8 = DpOffset.constructor-impl((long)(l6 << 32 | l7 & 0xFFFFFFFFL));
        if (!(dropShadowPainter != null && shadow != null && Dp.equals-impl0((float)shadow.getRadius-D9Ej5fM(), (float)f2) && Dp.equals-impl0((float)shadow.getSpread-D9Ej5fM(), (float)f3) && Color.equals-impl0((long)shadow.getColor-0d7_KjU(), (long)this.getColor-0d7_KjU()) && Intrinsics.areEqual((Object)shadow.getBrush(), (Object)brush) && shadow.getAlpha() == this.getAlpha() && BlendMode.equals-impl0((int)shadow.getBlendMode-0nO6VwU(), (int)this.getBlendMode-0nO6VwU()) && DpOffset.equals-impl0((long)shadow.getOffset-RKDOV3M(), (long)l8))) {
            Shadow shadow2;
            Shadow shadow3 = shadow2 = brush != null ? new Shadow(f2, brush, f3, l8, this.getAlpha(), this.getBlendMode-0nO6VwU(), null) : new Shadow(f2, this.getColor-0d7_KjU(), f3, l8, this.getAlpha(), this.getBlendMode-0nO6VwU(), null);
            bl = false;
            this.targetShadow = shadow3;
            shadow = shadow2;
            shadow3 = shadow2 = DelegatableNodeKt.requireGraphicsContext(this).getShadowContext().createDropShadowPainter(this.shape, shadow);
            bl = false;
            this.shadowPainter = shadow3;
            dropShadowPainter = shadow2;
        }
        return dropShadowPainter;
    }

    @Override
    public void onObservedReadsChanged() {
        this.invalidateShadow();
        this.blockRead = false;
    }

    private final void invalidateShadow() {
        this.targetShadow = null;
        this.shadowPainter = null;
        DrawModifierNodeKt.invalidateDraw(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BlockDropShadowNode)) {
            return false;
        }
        if (!(this.getAlpha() == ((BlockDropShadowNode)object).getAlpha())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shape, (Object)((BlockDropShadowNode)object).shape)) {
            return false;
        }
        if (this.block != ((BlockDropShadowNode)object).block) {
            return false;
        }
        if (!(this.getRadius() == ((BlockDropShadowNode)object).getRadius())) {
            return false;
        }
        if (!(this.getSpread() == ((BlockDropShadowNode)object).getSpread())) {
            return false;
        }
        if (!Offset.equals-impl0((long)this.getOffset-F1C5BW0(), (long)((BlockDropShadowNode)object).getOffset-F1C5BW0())) {
            return false;
        }
        if (!Color.equals-impl0((long)this.getColor-0d7_KjU(), (long)((BlockDropShadowNode)object).getColor-0d7_KjU())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBrush(), (Object)((BlockDropShadowNode)object).getBrush())) {
            return false;
        }
        return BlendMode.equals-impl0((int)this.getBlendMode-0nO6VwU(), (int)((BlockDropShadowNode)object).getBlendMode-0nO6VwU());
    }

    public int hashCode() {
        int n = Float.hashCode(this.getAlpha());
        n = 31 * n + this.shape.hashCode();
        n = 31 * n + this.block.hashCode();
        n = 31 * n + Float.hashCode(this.getRadius());
        n = 31 * n + Float.hashCode(this.getSpread());
        n = 31 * n + Offset.hashCode-impl((long)this.getOffset-F1C5BW0());
        n = 31 * n + Color.hashCode-impl((long)this.getColor-0d7_KjU());
        Brush brush = this.getBrush();
        n = 31 * n + (brush != null ? brush.hashCode() : 0);
        n = 31 * n + BlendMode.hashCode-impl((int)this.getBlendMode-0nO6VwU());
        return n;
    }

    private static final Unit obtainPainter$lambda$1(BlockDropShadowNode blockDropShadowNode) {
        blockDropShadowNode.block.invoke((Object)blockDropShadowNode);
        return Unit.INSTANCE;
    }
}

