/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessible;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0015B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0014\u001a\b\u0018\u00010\u0010R\u00020\u0000H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\u000f\u001a\u00060\u0010R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeSceneAccessible;", "Ljavax/accessibility/Accessible;", "forceEnableA11y", "", "accessibilityControllersProvider", "Lkotlin/Function0;", "", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "<init>", "(ZLkotlin/jvm/functions/Function0;)V", "a11yEnabled", "getA11yEnabled", "()Z", "a11yEnabled$delegate", "Lkotlin/Lazy;", "_accessibleContext", "Landroidx/compose/ui/platform/a11y/ComposeSceneAccessible$ComposeSceneAccessibleContext;", "get_accessibleContext", "()Landroidx/compose/ui/platform/a11y/ComposeSceneAccessible$ComposeSceneAccessibleContext;", "_accessibleContext$delegate", "getAccessibleContext", "ComposeSceneAccessibleContext", "ui"})
public final class ComposeSceneAccessible
implements Accessible {
    private final boolean forceEnableA11y;
    private final Function0<List<AccessibilityController>> accessibilityControllersProvider;
    private final Lazy a11yEnabled$delegate;
    private final Lazy _accessibleContext$delegate;
    public static final int $stable = 8;

    public ComposeSceneAccessible(boolean bl, Function0<? extends List<AccessibilityController>> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"");
        this.forceEnableA11y = bl;
        this.accessibilityControllersProvider = function0;
        this.a11yEnabled$delegate = LazyKt.lazy(() -> ComposeSceneAccessible.a11yEnabled_delegate$lambda$0(this));
        this._accessibleContext$delegate = LazyKt.lazy(() -> ComposeSceneAccessible._accessibleContext_delegate$lambda$1(this));
    }

    public /* synthetic */ ComposeSceneAccessible(boolean bl, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        this(bl, (Function0<? extends List<AccessibilityController>>)function0);
    }

    private final boolean getA11yEnabled() {
        Lazy lazy = this.a11yEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    private final ComposeSceneAccessibleContext get_accessibleContext() {
        Lazy lazy = this._accessibleContext$delegate;
        return (ComposeSceneAccessibleContext)lazy.getValue();
    }

    @Override
    public ComposeSceneAccessibleContext getAccessibleContext() {
        if (!this.getA11yEnabled()) {
            return null;
        }
        return this.get_accessibleContext();
    }

    private static final boolean a11yEnabled_delegate$lambda$0(ComposeSceneAccessible composeSceneAccessible) {
        return composeSceneAccessible.forceEnableA11y || !Intrinsics.areEqual((Object)System.getProperty("compose.accessibility.enable"), (Object)"false") && System.getenv("COMPOSE_DISABLE_ACCESSIBILITY") == null;
    }

    private static final ComposeSceneAccessibleContext _accessibleContext_delegate$lambda$1(ComposeSceneAccessible composeSceneAccessible) {
        return composeSceneAccessible.new ComposeSceneAccessibleContext();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010#\u001a\u00020\u0002H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u00020)2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010/\u001a\u00020)2\b\u00100\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u00101\u001a\u00020)2\b\u00102\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020\u0014H\u0016J\n\u00105\u001a\u0004\u0018\u000106H\u0016J\u0012\u00107\u001a\u00020)2\b\u00108\u001a\u0004\u0018\u000106H\u0016J\n\u00109\u001a\u0004\u0018\u000106H\u0016J\u0012\u0010:\u001a\u00020)2\b\u00108\u001a\u0004\u0018\u000106H\u0016J\n\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010=\u001a\u00020)2\b\u0010>\u001a\u0004\u0018\u00010<H\u0016J\n\u0010?\u001a\u0004\u0018\u00010@H\u0016J\u0012\u0010A\u001a\u00020)2\b\u0010B\u001a\u0004\u0018\u00010@H\u0016J\u0014\u0010C\u001a\u0004\u0018\u00010D2\b\u0010B\u001a\u0004\u0018\u00010@H\u0016J\u0010\u0010E\u001a\u00020)2\u0006\u00104\u001a\u00020\u0014H\u0016J\u0012\u0010F\u001a\u00020)2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0012\u0010I\u001a\u00020)2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006J"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeSceneAccessible$ComposeSceneAccessibleContext;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeSceneAccessible;)V", "accessibilityControllers", "", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "getAccessibilityControllers$ui", "()Ljava/util/List;", "accessibilityController", "getAccessibilityController", "()Landroidx/compose/ui/platform/a11y/AccessibilityController;", "getMainOwnerAccessibleRoot", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "getAccessibleAt", "Ljavax/accessibility/Accessible;", "p", "Ljava/awt/Point;", "contains", "", "getAccessibleIndexInParent", "", "getAccessibleChildrenCount", "getAccessibleChild", "i", "getSize", "Ljava/awt/Dimension;", "getLocationOnScreen", "getLocation", "getBounds", "Ljava/awt/Rectangle;", "isShowing", "isFocusTraversable", "getAccessibleParent", "getAccessibleComponent", "getLocale", "Ljava/util/Locale;", "isVisible", "isEnabled", "requestFocus", "", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "setLocation", "setBounds", "r", "setSize", "d", "setVisible", "b", "getBackground", "Ljava/awt/Color;", "setBackground", "c", "getForeground", "setForeground", "getCursor", "Ljava/awt/Cursor;", "setCursor", "cursor", "getFont", "Ljava/awt/Font;", "setFont", "f", "getFontMetrics", "Ljava/awt/FontMetrics;", "setEnabled", "addFocusListener", "l", "Ljava/awt/event/FocusListener;", "removeFocusListener", "ui"})
    public final class ComposeSceneAccessibleContext
    extends AccessibleContext
    implements AccessibleComponent {
        public final List<AccessibilityController> getAccessibilityControllers$ui() {
            return (List)ComposeSceneAccessible.this.accessibilityControllersProvider.invoke();
        }

        private final AccessibilityController getAccessibilityController() {
            return (AccessibilityController)CollectionsKt.firstOrNull(this.getAccessibilityControllers$ui());
        }

        private final ComposeAccessible getMainOwnerAccessibleRoot() {
            AccessibilityController accessibilityController = this.getAccessibilityController();
            return accessibilityController != null ? accessibilityController.getRootAccessible() : null;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"");
            for (AccessibilityController accessibilityController : this.getAccessibilityControllers$ui()) {
                Accessible accessible;
                ComposeAccessible composeAccessible = accessibilityController.getRootAccessible();
                ComposeAccessible.ComposeAccessibleComponent composeAccessibleComponent = composeAccessible.getComposeAccessibleContext();
                if (composeAccessibleComponent.getAccessibleAt(point) == null || Intrinsics.areEqual((Object)accessible, (Object)composeAccessible)) continue;
                return accessible;
            }
            return null;
        }

        @Override
        public boolean contains(Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"");
            return true;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.getAccessibilityControllers$ui().size();
        }

        @Override
        public Accessible getAccessibleChild(int n2) {
            return this.getAccessibilityControllers$ui().get(n2).getRootAccessible();
        }

        @Override
        public Dimension getSize() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getSize() : null;
        }

        @Override
        public Point getLocationOnScreen() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getLocationOnScreen() : null;
        }

        @Override
        public Point getLocation() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getLocation() : null;
        }

        @Override
        public Rectangle getBounds() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getBounds() : null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public Accessible getAccessibleParent() {
            return null;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
            return locale;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole;
            if (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()] == 1) {
                AccessibleRole accessibleRole2 = AccessibleRole.PANEL;
                accessibleRole = accessibleRole2;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole2, (String)"");
            } else {
                AccessibleRole accessibleRole3 = AccessibleRole.UNKNOWN;
                accessibleRole = accessibleRole3;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole3, (String)"");
            }
            return accessibleRole;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public void setBounds(Rectangle rectangle) {
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public Color getBackground() {
            return null;
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            return null;
        }

        @Override
        public void setForeground(Color color) {
        }

        @Override
        public Cursor getCursor() {
            return null;
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public Font getFont() {
            return null;
        }

        @Override
        public void setFont(Font font) {
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public void addFocusListener(FocusListener focusListener2) {
        }

        @Override
        public void removeFocusListener(FocusListener focusListener2) {
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OS.values().length];
                try {
                    nArray[OS.MacOS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

