/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.b.E;
import androidx.b.l;
import androidx.b.m;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.semantics.LtrBoundsComparator;
import androidx.compose.ui.semantics.RtlBoundsComparator;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.TopBottomBoundsComparator;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u001aH\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a`\u0010\b\u001a\u00020\t*\u00020\u00022\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000bj\b\u0012\u0004\u0012\u00020\u0002`\f2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u000eH\u0002\u001aL\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0012H\u0000\u001aL\u0010\u0013\u001a\u00020\u00052:\u0010\u0014\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u00150\u000bj\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u0015`\f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\"&\u0010\u0019\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00020\u001bj\b\u0012\u0004\u0012\u00020\u0002`\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\" \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"subtreeSortedByGeometryGrouping", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "isVisible", "Lkotlin/Function1;", "", "isFocusableContainer", "listToSort", "geometryDepthFirstSearch", "", "geometryList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "containerMapToChildren", "Landroidx/collection/MutableIntObjectMap;", "sortByGeometryGroupings", "parentListToSort", "containerChildrenMapping", "Landroidx/collection/IntObjectMap;", "placedEntryRowOverlaps", "rowGroupings", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Rect;", "", "node", "semanticComparators", "", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "[Ljava/util/Comparator;", "UnmergedConfigComparator", "Lkotlin/Function2;", "", "ui"})
public final class SemanticsSortKt {
    private static final Comparator<SemanticsNode>[] semanticComparators;
    private static final Function2<SemanticsNode, SemanticsNode, Integer> UnmergedConfigComparator;

    public static final List<SemanticsNode> subtreeSortedByGeometryGrouping(SemanticsNode semanticsNode, Function1<? super SemanticsNode, Boolean> function1, Function1<? super SemanticsNode, Boolean> function12, List<SemanticsNode> list) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function12, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        E e2 = m.c();
        ArrayList<SemanticsNode> arrayList = new ArrayList<SemanticsNode>();
        List<SemanticsNode> list2 = list;
        boolean bl = false;
        int n2 = ((Collection)list2).size();
        for (int j = 0; j < n2; ++j) {
            SemanticsNode semanticsNode2;
            SemanticsNode semanticsNode3 = semanticsNode2 = list2.get(j);
            boolean bl2 = false;
            SemanticsSortKt.geometryDepthFirstSearch(semanticsNode3, arrayList, function1, function12, (E<List<SemanticsNode>>)e2);
        }
        return SemanticsSortKt.sortByGeometryGroupings(semanticsNode, (List<SemanticsNode>)arrayList, function12, (l<List<SemanticsNode>>)((l)e2));
    }

    private static final void geometryDepthFirstSearch(SemanticsNode semanticsNode, ArrayList<SemanticsNode> arrayList, Function1<? super SemanticsNode, Boolean> function1, Function1<? super SemanticsNode, Boolean> function12, E<List<SemanticsNode>> e2) {
        boolean bl = semanticsNode.getUnmergedConfig$ui().getOrElse(SemanticsProperties.INSTANCE.getIsTraversalGroup(), SemanticsSortKt::geometryDepthFirstSearch$lambda$1);
        if ((bl || ((Boolean)function12.invoke((Object)semanticsNode)).booleanValue()) && ((Boolean)function1.invoke((Object)semanticsNode)).booleanValue()) {
            arrayList.add(semanticsNode);
        }
        if (bl) {
            e2.a(semanticsNode.getId(), SemanticsSortKt.subtreeSortedByGeometryGrouping(semanticsNode, function1, function12, semanticsNode.getChildren()));
        } else {
            List<SemanticsNode> list = semanticsNode.getChildren();
            boolean bl2 = false;
            int n2 = ((Collection)list).size();
            for (int j = 0; j < n2; ++j) {
                SemanticsNode semanticsNode2;
                SemanticsNode semanticsNode3 = semanticsNode2 = list.get(j);
                boolean bl3 = false;
                SemanticsSortKt.geometryDepthFirstSearch(semanticsNode3, arrayList, function1, function12, e2);
            }
        }
    }

    public static final List<SemanticsNode> sortByGeometryGroupings(SemanticsNode semanticsNode, List<SemanticsNode> list, Function1<? super SemanticsNode, Boolean> function1, l<List<SemanticsNode>> l2) {
        Object e2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(l2, (String)"");
        boolean bl = semanticsNode.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
        ArrayList<Pair<Rect, List<SemanticsNode>>> arrayList = new ArrayList<Pair<Rect, List<SemanticsNode>>>(list.size() / 2);
        int n2 = 0;
        int n3 = CollectionsKt.getLastIndex(list);
        if (n2 <= n3) {
            while (true) {
                object = list.get(n2);
                if (n2 == 0 || !SemanticsSortKt.placedEntryRowOverlaps(arrayList, (SemanticsNode)object)) {
                    Rect rect = ((SemanticsNode)object).getBoundsInWindow();
                    Object[] objectArray = new SemanticsNode[]{object};
                    arrayList.add((Pair<Rect, List<SemanticsNode>>)new Pair((Object)rect, (Object)CollectionsKt.mutableListOf((Object[])objectArray)));
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        CollectionsKt.sortWith((List)arrayList, (Comparator)TopBottomBoundsComparator.INSTANCE);
        ArrayList arrayList2 = new ArrayList();
        Comparator<SemanticsNode> comparator = semanticComparators[bl ? 0 : 1];
        object = arrayList;
        int n4 = 0;
        int n5 = ((Collection)object).size();
        for (int j = 0; j < n5; ++j) {
            e2 = object.get(j);
            Pair pair = (Pair)e2;
            boolean bl2 = false;
            CollectionsKt.sortWith((List)((List)pair.getSecond()), comparator);
            arrayList2.addAll((Collection)pair.getSecond());
        }
        CollectionsKt.sortWith((List)arrayList2, (arg_0, arg_1) -> SemanticsSortKt.sortByGeometryGroupings$lambda$5(UnmergedConfigComparator, arg_0, arg_1));
        int n6 = 0;
        while (n6 <= CollectionsKt.getLastIndex((List)arrayList2)) {
            n4 = ((SemanticsNode)arrayList2.get(n6)).getId();
            List list2 = (List)l2.a(n4);
            if (list2 != null) {
                Object e3 = arrayList2.get(n6);
                Intrinsics.checkNotNullExpressionValue(e3, (String)"");
                n5 = ((Boolean)function1.invoke(e3)).booleanValue() ? 1 : 0;
                if (n5 == 0) {
                    e2 = arrayList2.remove(n6);
                    Intrinsics.checkNotNull(e2);
                } else {
                    ++n6;
                }
                arrayList2.addAll(n6, list2);
                n6 += list2.size();
                continue;
            }
            ++n6;
        }
        return arrayList2;
    }

    public static /* synthetic */ List sortByGeometryGroupings$default(SemanticsNode semanticsNode, List list, Function1 function1, l l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = SemanticsSortKt::sortByGeometryGroupings$lambda$3;
        }
        if ((n2 & 4) != 0) {
            l2 = m.b();
        }
        return SemanticsSortKt.sortByGeometryGroupings(semanticsNode, list, (Function1<? super SemanticsNode, Boolean>)function1, (l<List<SemanticsNode>>)l2);
    }

    private static final boolean placedEntryRowOverlaps(ArrayList<Pair<Rect, List<SemanticsNode>>> arrayList, SemanticsNode semanticsNode) {
        float f2;
        float f3 = semanticsNode.getBoundsInWindow().getTop();
        boolean bl = f3 >= (f2 = semanticsNode.getBoundsInWindow().getBottom());
        int n2 = 0;
        int n3 = CollectionsKt.getLastIndex((List)arrayList);
        if (n2 <= n3) {
            while (true) {
                boolean bl2;
                Rect rect;
                boolean bl3 = (rect = (Rect)arrayList.get(n2).getFirst()).getTop() >= rect.getBottom();
                boolean bl4 = bl2 = !bl && !bl3 && Math.max(f3, rect.getTop()) < Math.min(f2, rect.getBottom());
                if (bl2) {
                    Rect rect2 = rect.intersect(0.0f, f3, Float.POSITIVE_INFINITY, f2);
                    arrayList.set(n2, (Pair<Rect, List<SemanticsNode>>)new Pair((Object)rect2, arrayList.get(n2).getSecond()));
                    ((List)arrayList.get(n2).getSecond()).add(semanticsNode);
                    return true;
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        return false;
    }

    private static final boolean geometryDepthFirstSearch$lambda$1() {
        return false;
    }

    private static final boolean sortByGeometryGroupings$lambda$3(SemanticsNode semanticsNode) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        return false;
    }

    private static final int sortByGeometryGroupings$lambda$5(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    private static final float UnmergedConfigComparator$lambda$10$lambda$8() {
        return 0.0f;
    }

    private static final float UnmergedConfigComparator$lambda$10$lambda$9() {
        return 0.0f;
    }

    private static final int UnmergedConfigComparator$lambda$10(SemanticsNode semanticsNode, SemanticsNode semanticsNode2) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        Intrinsics.checkNotNullParameter((Object)semanticsNode2, (String)"");
        return Float.compare(((Number)semanticsNode.getUnmergedConfig$ui().getOrElse(SemanticsProperties.INSTANCE.getTraversalIndex(), SemanticsSortKt::UnmergedConfigComparator$lambda$10$lambda$8)).floatValue(), ((Number)semanticsNode2.getUnmergedConfig$ui().getOrElse(SemanticsProperties.INSTANCE.getTraversalIndex(), SemanticsSortKt::UnmergedConfigComparator$lambda$10$lambda$9)).floatValue());
    }

    static {
        Comparator[] comparatorArray = new Comparator[2];
        for (int j = 0; j < 2; ++j) {
            Comparator comparator;
            int n2 = j;
            Comparator comparator2 = comparator = n2 == 0 ? (Comparator)RtlBoundsComparator.INSTANCE : (Comparator)LtrBoundsComparator.INSTANCE;
            Comparator<LayoutNode> comparator3 = LayoutNode.Companion.getZComparator$ui();
            comparator2 = new Comparator(comparator2, comparator3){
                final /* synthetic */ Comparator $this_thenBy;
                final /* synthetic */ Comparator $comparator;
                {
                    this.$this_thenBy = comparator;
                    this.$comparator = comparator2;
                }

                public final int compare(T t2, T t3) {
                    int n2;
                    int n3 = this.$this_thenBy.compare(t2, t3);
                    if (n3 != 0) {
                        n2 = n3;
                    } else {
                        SemanticsNode semanticsNode = (SemanticsNode)t2;
                        Comparator comparator = this.$comparator;
                        boolean bl = false;
                        semanticsNode = (SemanticsNode)t3;
                        LayoutNode layoutNode = semanticsNode.getLayoutNode$ui();
                        bl = false;
                        LayoutNode layoutNode2 = semanticsNode.getLayoutNode$ui();
                        n2 = comparator.compare(layoutNode, layoutNode2);
                    }
                    return n2;
                }
            };
            comparatorArray[n2] = new Comparator(comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = comparator;
                }

                public final int compare(T t2, T t3) {
                    int n2;
                    int n3 = this.$this_thenBy.compare(t2, t3);
                    if (n3 != 0) {
                        n2 = n3;
                    } else {
                        SemanticsNode semanticsNode = (SemanticsNode)t2;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(semanticsNode.getId());
                        semanticsNode = (SemanticsNode)t3;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n2 = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(semanticsNode.getId()));
                    }
                    return n2;
                }
            };
        }
        semanticComparators = comparatorArray;
        UnmergedConfigComparator = SemanticsSortKt::UnmergedConfigComparator$lambda$10;
    }
}

