/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\b\u001a\u00020\t*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\r\"\u0014\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017\"\u0018\u0010\u0018\u001a\u00020\u0016*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"GlobalDensity", "Landroidx/compose/ui/unit/Density;", "getGlobalDensity", "()Landroidx/compose/ui/unit/Density;", "density", "Ljava/awt/Component;", "getDensity", "(Ljava/awt/Component;)Landroidx/compose/ui/unit/Density;", "sizeInPx", "Landroidx/compose/ui/geometry/Size;", "getSizeInPx", "(Ljava/awt/Component;)J", "Ljava/awt/GraphicsConfiguration;", "(Ljava/awt/GraphicsConfiguration;)Landroidx/compose/ui/unit/Density;", "GlobalLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getGlobalLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "layoutDirection", "Ljava/util/Locale;", "getLayoutDirection", "(Ljava/util/Locale;)Landroidx/compose/ui/unit/LayoutDirection;", "Ljava/awt/ComponentOrientation;", "(Ljava/awt/ComponentOrientation;)Landroidx/compose/ui/unit/LayoutDirection;", "componentOrientation", "getComponentOrientation", "(Landroidx/compose/ui/unit/LayoutDirection;)Ljava/awt/ComponentOrientation;", "layoutDirectionFor", "component", "ui"})
public final class LayoutConfiguration_desktopKt {
    public static final Density getGlobalDensity() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"");
        return LayoutConfiguration_desktopKt.getDensity(graphicsConfiguration);
    }

    public static final Density getDensity(Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"");
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"");
        return LayoutConfiguration_desktopKt.getDensity(graphicsConfiguration);
    }

    public static final long getSizeInPx(Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"");
        float f2 = LayoutConfiguration_desktopKt.getDensity(component).getDensity();
        float f3 = (float)component.getWidth() * f2;
        float f4 = (float)component.getHeight() * f2;
        boolean bl = false;
        boolean bl2 = false;
        long l2 = Float.floatToRawIntBits(f3);
        long l3 = Float.floatToRawIntBits(f4);
        return Size.constructor-impl((long)(l2 << 32 | l3 & 0xFFFFFFFFL));
    }

    private static final Density getDensity(GraphicsConfiguration graphicsConfiguration) {
        return DensityKt.Density((float)((float)graphicsConfiguration.getDefaultTransform().getScaleX()), (float)1.0f);
    }

    public static final LayoutDirection getGlobalLayoutDirection() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
        return LayoutConfiguration_desktopKt.getLayoutDirection(locale);
    }

    public static final LayoutDirection getLayoutDirection(Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"");
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(locale);
        Intrinsics.checkNotNullExpressionValue((Object)componentOrientation, (String)"");
        return LayoutConfiguration_desktopKt.getLayoutDirection(componentOrientation);
    }

    public static final LayoutDirection getLayoutDirection(ComponentOrientation componentOrientation) {
        Intrinsics.checkNotNullParameter((Object)componentOrientation, (String)"");
        return componentOrientation.isLeftToRight() ? LayoutDirection.Ltr : (componentOrientation.isHorizontal() ? LayoutDirection.Rtl : LayoutDirection.Ltr);
    }

    public static final ComponentOrientation getComponentOrientation(LayoutDirection layoutDirection) {
        ComponentOrientation componentOrientation;
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[layoutDirection.ordinal()]) {
            case 1: {
                ComponentOrientation componentOrientation2 = ComponentOrientation.LEFT_TO_RIGHT;
                componentOrientation = componentOrientation2;
                Intrinsics.checkNotNullExpressionValue((Object)componentOrientation2, (String)"");
                break;
            }
            case 2: {
                ComponentOrientation componentOrientation3 = ComponentOrientation.RIGHT_TO_LEFT;
                componentOrientation = componentOrientation3;
                Intrinsics.checkNotNullExpressionValue((Object)componentOrientation3, (String)"");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return componentOrientation;
    }

    public static final LayoutDirection layoutDirectionFor(Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"");
        ComponentOrientation componentOrientation = component.getComponentOrientation();
        if (Intrinsics.areEqual((Object)componentOrientation, (Object)ComponentOrientation.UNKNOWN)) {
            Locale locale = component.getLocale();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
            return LayoutConfiguration_desktopKt.getLayoutDirection(locale);
        }
        Intrinsics.checkNotNull((Object)componentOrientation);
        return LayoutConfiguration_desktopKt.getLayoutDirection(componentOrientation);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayoutDirection.values().length];
            try {
                nArray[LayoutDirection.Ltr.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LayoutDirection.Rtl.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

