/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.runtime.Applier;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\f\u0010\u001b\u001a\u00020\u0004*\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Landroidx/compose/ui/window/MenuItemApplier;", "Landroidx/compose/runtime/Applier;", "Ljava/awt/MenuItem;", "root", "Ljava/awt/Menu;", "<init>", "(Ljava/awt/Menu;)V", "current", "getCurrent", "()Ljava/awt/MenuItem;", "setCurrent", "(Ljava/awt/MenuItem;)V", "up", "", "down", "node", "clear", "insertBottomUp", "index", "", "instance", "insertTopDown", "move", "from", "to", "count", "remove", "asMenu", "ui"})
public final class MenuItemApplier
implements Applier<MenuItem> {
    private final Menu root;
    private MenuItem current;
    public static final int $stable = 8;

    public MenuItemApplier(Menu menu) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"");
        this.root = menu;
        this.current = this.root;
    }

    public MenuItem getCurrent() {
        return this.current;
    }

    public void setCurrent(MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
        this.current = menuItem;
    }

    public void up() {
        if (!(!Intrinsics.areEqual((Object)this.getCurrent(), (Object)this.root))) {
            throw new IllegalStateException("Check failed.");
        }
        MenuContainer menuContainer = this.getCurrent().getParent();
        Intrinsics.checkNotNull((Object)menuContainer);
        this.setCurrent((MenuItem)((Object)menuContainer));
    }

    public void down(MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
        if (!Intrinsics.areEqual((Object)this.getCurrent(), (Object)menuItem.getParent())) {
            throw new IllegalStateException("Check failed.");
        }
        this.setCurrent(menuItem);
    }

    public void clear() {
        this.setCurrent(this.root);
        this.root.removeAll();
    }

    public void insertBottomUp(int n2, MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
    }

    public void insertTopDown(int n2, MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
        Menu menu = this.asMenu(this.getCurrent());
        menu.insert(menuItem, n2);
    }

    public void move(int n2, int n3, int n4) {
        Menu menu = this.asMenu(this.getCurrent());
        boolean bl = false;
        if (n2 > n3) {
            int n5 = 0;
            n5 = n3;
            int n6 = 0;
            while (n6 < n4) {
                int n7 = n6++;
                boolean bl2 = false;
                int n8 = n2;
                int n9 = 0;
                MenuItem menuItem = menu.getItem(n8);
                n8 = n2;
                n9 = 0;
                menu.remove(n8);
                n9 = n5++;
                MenuItem menuItem2 = menuItem;
                boolean bl3 = false;
                menu.insert(menuItem2, n9);
            }
        } else {
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n10++;
                boolean bl4 = false;
                int n12 = n2;
                int n13 = 0;
                MenuItem menuItem = menu.getItem(n12);
                n12 = n2;
                n13 = 0;
                menu.remove(n12);
                n13 = n3 - 1;
                MenuItem menuItem3 = menuItem;
                boolean bl5 = false;
                menu.insert(menuItem3, n13);
            }
        }
    }

    public void remove(int n2, int n3) {
        Menu menu = this.asMenu(this.getCurrent());
        int n4 = n2 + n3 - 1;
        if (n2 <= n4) {
            while (true) {
                menu.remove(n4);
                if (n4 == n2) break;
                --n4;
            }
        }
    }

    private final Menu asMenu(MenuItem menuItem) {
        if (!(menuItem instanceof Menu)) {
            throw new IllegalStateException(("Can only insert MenuItem into Menu, not " + Reflection.getOrCreateKotlinClass(menuItem.getClass())).toString());
        }
        return (Menu)menuItem;
    }
}

