/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.Bzip2BitWriter;
import io.netty.handler.codec.compression.Bzip2BlockCompressor;
import io.netty.handler.codec.compression.EncoderUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;

public class Bzip2Encoder
extends MessageToByteEncoder<ByteBuf> {
    private State currentState = State.INIT;
    private final Bzip2BitWriter writer = new Bzip2BitWriter();
    private final int streamBlockSize;
    private int streamCRC;
    private Bzip2BlockCompressor blockCompressor;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Bzip2Encoder() {
        this(9);
    }

    public Bzip2Encoder(int n) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("blockSizeMultiplier: " + n + " (expected: 1-9)");
        }
        this.streamBlockSize = n * 100000;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        block6: while (true) {
            switch (this.currentState) {
                case INIT: {
                    byteBuf2.ensureWritable(4);
                    byteBuf2.writeMedium(4348520);
                    byteBuf2.writeByte(48 + this.streamBlockSize / 100000);
                    this.currentState = State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    this.blockCompressor = new Bzip2BlockCompressor(this.writer, this.streamBlockSize);
                    this.currentState = State.WRITE_DATA;
                }
                case WRITE_DATA: {
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    Bzip2BlockCompressor bzip2BlockCompressor = this.blockCompressor;
                    int n = Math.min(byteBuf.readableBytes(), bzip2BlockCompressor.availableSize());
                    int n2 = bzip2BlockCompressor.write(byteBuf, byteBuf.readerIndex(), n);
                    byteBuf.skipBytes(n2);
                    if (!bzip2BlockCompressor.isFull()) {
                        if (byteBuf.isReadable()) continue block6;
                        return;
                    }
                    this.currentState = State.CLOSE_BLOCK;
                }
                case CLOSE_BLOCK: {
                    this.closeBlock(byteBuf2);
                    this.currentState = State.INIT_BLOCK;
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private void closeBlock(ByteBuf byteBuf) {
        Bzip2BlockCompressor bzip2BlockCompressor = this.blockCompressor;
        if (!bzip2BlockCompressor.isEmpty()) {
            bzip2BlockCompressor.close(byteBuf);
            int n = bzip2BlockCompressor.crc();
            this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ n;
        }
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    public ChannelFuture close(final ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelFuture channelFuture = Bzip2Encoder.this.finishEncode(Bzip2Encoder.this.ctx(), channelPromise);
                PromiseNotifier.cascade((Future)channelFuture, (Promise)channelPromise);
            }
        });
        return channelPromise;
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        EncoderUtil.closeAfterFinishEncode(channelHandlerContext, channelFuture, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
        this.closeBlock(byteBuf);
        int n = this.streamCRC;
        Bzip2BitWriter bzip2BitWriter = this.writer;
        try {
            bzip2BitWriter.writeBits(byteBuf, 24, 1536581L);
            bzip2BitWriter.writeBits(byteBuf, 24, 3690640L);
            bzip2BitWriter.writeInt(byteBuf, n);
            bzip2BitWriter.flush(byteBuf);
        }
        finally {
            this.blockCompressor = null;
        }
        return channelHandlerContext.writeAndFlush((Object)byteBuf, channelPromise);
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    private static enum State {
        INIT,
        INIT_BLOCK,
        WRITE_DATA,
        CLOSE_BLOCK;

    }
}

