/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.CompressionUtil;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public final class Lz4XXHash32
extends ByteBufChecksum {
    private static final XXHash32 XXHASH32 = XXHashFactory.fastestInstance().hash32();
    private final int seed;
    private boolean used;
    private int value;

    public Lz4XXHash32(int n) {
        this.seed = n;
    }

    @Override
    public void update(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.used) {
            throw new IllegalStateException();
        }
        this.value = XXHASH32.hash(byArray, n, n2, this.seed);
        this.used = true;
    }

    @Override
    public void update(ByteBuf byteBuf, int n, int n2) {
        if (this.used) {
            throw new IllegalStateException();
        }
        this.value = byteBuf.hasArray() ? XXHASH32.hash(byteBuf.array(), byteBuf.arrayOffset() + n, n2, this.seed) : XXHASH32.hash(CompressionUtil.safeNioBuffer(byteBuf, n, n2), this.seed);
        this.used = true;
    }

    @Override
    public long getValue() {
        if (!this.used) {
            throw new IllegalStateException();
        }
        return (long)this.value & 0xFFFFFFFL;
    }

    @Override
    public void reset() {
        this.used = false;
    }
}

