/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdConstants;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;

public final class ZstdEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int blockSize;
    private final int compressionLevel;
    private final int maxEncodeSize;
    private ByteBuf buffer;

    public ZstdEncoder() {
        this(ZstdConstants.DEFAULT_COMPRESSION_LEVEL, 65536, ZstdConstants.MAX_BLOCK_SIZE);
    }

    public ZstdEncoder(int n) {
        this(n, 65536, ZstdConstants.MAX_BLOCK_SIZE);
    }

    public ZstdEncoder(int n, int n2) {
        this(ZstdConstants.DEFAULT_COMPRESSION_LEVEL, n, n2);
    }

    public ZstdEncoder(int n, int n2, int n3) {
        super(true);
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.compressionLevel = ObjectUtil.checkInRange((int)n, (int)ZstdConstants.MIN_COMPRESSION_LEVEL, (int)ZstdConstants.MAX_COMPRESSION_LEVEL, (String)"compressionLevel");
        this.blockSize = ObjectUtil.checkPositive((int)n2, (String)"blockSize");
        this.maxEncodeSize = ObjectUtil.checkPositive((int)n3, (String)"maxEncodeSize");
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl) {
        if (this.buffer == null) {
            throw new IllegalStateException("not added to a pipeline,or has been removed,buffer is null");
        }
        int n = byteBuf.readableBytes() + this.buffer.readableBytes();
        if (n < 0) {
            throw new EncoderException("too much data to allocate a buffer for compression");
        }
        long l = 0L;
        while (n > 0) {
            int n2 = Math.min(this.blockSize, n);
            n -= n2;
            l += com.github.luben.zstd.Zstd.compressBound((long)n2);
        }
        if (l > (long)this.maxEncodeSize || 0L > l) {
            throw new EncoderException("requested encode buffer size (" + l + " bytes) exceeds the maximum allowable size (" + this.maxEncodeSize + " bytes)");
        }
        return channelHandlerContext.alloc().directBuffer((int)l);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n;
        if (this.buffer == null) {
            throw new IllegalStateException("not added to a pipeline,or has been removed,buffer is null");
        }
        ByteBuf byteBuf3 = this.buffer;
        while ((n = byteBuf.readableBytes()) > 0) {
            int n2 = Math.min(n, byteBuf3.writableBytes());
            byteBuf.readBytes(byteBuf3, n2);
            if (byteBuf3.isWritable()) continue;
            this.flushBufferedData(byteBuf2);
        }
    }

    private void flushBufferedData(ByteBuf byteBuf) {
        int n;
        int n2 = this.buffer.readableBytes();
        if (n2 == 0) {
            return;
        }
        int n3 = (int)com.github.luben.zstd.Zstd.compressBound((long)n2);
        byteBuf.ensureWritable(n3);
        int n4 = byteBuf.writerIndex();
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n4, byteBuf.writableBytes());
            n = com.github.luben.zstd.Zstd.compress((ByteBuffer)byteBuffer, (ByteBuffer)this.buffer.internalNioBuffer(this.buffer.readerIndex(), n2), (int)this.compressionLevel);
        }
        catch (Exception exception) {
            throw new CompressionException(exception);
        }
        byteBuf.writerIndex(n4 + n);
        this.buffer.clear();
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.buffer != null && this.buffer.isReadable()) {
            ByteBuf byteBuf = this.allocateBuffer(channelHandlerContext, Unpooled.EMPTY_BUFFER, this.isPreferDirect());
            this.flushBufferedData(byteBuf);
            channelHandlerContext.write((Object)byteBuf);
        }
        channelHandlerContext.flush();
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.buffer = channelHandlerContext.alloc().directBuffer(this.blockSize);
        this.buffer.clear();
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved(channelHandlerContext);
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }
}

